/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sql;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sql.ExecSQLData;
import org.pentaho.di.trans.steps.sql.ExecSQLMeta;
import org.pentaho.di.trans.steps.sql.Messages;

public class ExecSQL
extends BaseStep
implements StepInterface {
    private ExecSQLMeta meta;
    private ExecSQLData data;

    public ExecSQL(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMeta meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMeta(upd, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesUpdated()));
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMeta(ins, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesOutput()));
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMeta(del, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesDeleted()));
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMeta(read, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesRead()));
        }
        return resultRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block14: {
            String sql;
            int numMarkers;
            this.meta = (ExecSQLMeta)smi;
            this.data = (ExecSQLData)sdi;
            if (!this.meta.isExecutedEachInputRow()) {
                RowMetaAndData resultRow = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                this.putRow(resultRow.getRowMeta(), resultRow.getData());
                this.setOutputDone();
                return false;
            }
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.argumentIndexes = new int[this.meta.getArguments().length];
                for (int i = 0; i < this.meta.getArguments().length; ++i) {
                    this.data.argumentIndexes[i] = this.getInputRowMeta().indexOfValue(this.meta.getArguments()[i]);
                    if (this.data.argumentIndexes[i] >= 0) continue;
                    this.logError(Messages.getString("ExecSQL.Log.ErrorFindingField") + this.meta.getArguments()[i] + "]");
                    throw new KettleStepException(Messages.getString("ExecSQL.Exception.CouldNotFindField", this.meta.getArguments()[i]));
                }
                this.data.markerPositions = new ArrayList<Integer>();
                int len = this.data.sql.length();
                for (int pos = len - 1; pos >= 0; --pos) {
                    if (this.data.sql.charAt(pos) != '?') continue;
                    this.data.markerPositions.add(pos);
                }
            }
            if ((numMarkers = this.data.markerPositions.size()) > 0) {
                StringBuffer buf = new StringBuffer(this.data.sql);
                for (int i = 0; i < numMarkers; ++i) {
                    int index = this.data.argumentIndexes[this.data.markerPositions.size() - i - 1];
                    ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
                    Object valueData = row[index];
                    int pos = this.data.markerPositions.get(i);
                    String replaceValue = valueMeta.getString(valueData);
                    replaceValue = Const.NVL((String)replaceValue, (String)"");
                    buf.replace(pos, pos + 1, replaceValue);
                }
                sql = buf.toString();
            } else {
                sql = this.data.sql;
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("ExecSQL.Log.ExecutingSQLScript") + Const.CR + this.data.sql);
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                this.data.result = this.data.db.execStatements(sql);
                RowMetaAndData add = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (!this.data.db.isAutoCommit()) {
                    this.data.db.commit();
                }
                this.putRow(this.data.outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("ExecSQL.Log.LineNumber") + this.getLinesWritten());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleStepException(Messages.getString("ExecSQL.Log.ErrorInStep"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block14;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSQL001");
            }
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (this.log.isBasic()) {
            this.logBasic(Messages.getString("ExecSQL.Log.FinishingReadingQuery"));
        }
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public synchronized void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (this.data.db != null && !this.data.isCanceled) {
            this.data.db.cancelQuery();
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("ExecSQL.Log.ConnectedToDB"));
                }
                this.data.sql = this.meta.isReplaceVariables() ? this.environmentSubstitute(this.meta.getSql()) : this.meta.getSql();
                if (!this.meta.isExecutedEachInputRow()) {
                    this.data.result = this.data.db.execStatements(this.data.sql);
                    if (!this.data.db.isAutoCommit()) {
                        this.data.db.commit();
                    }
                }
                return true;
            }
            catch (KettleException e) {
                this.logError(Messages.getString("ExecSQL.Log.ErrorOccurred") + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

