/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mondrianinput;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianHelper {
    private DatabaseMeta databaseMeta;
    private String catalog;
    private String queryString;
    private RowMetaInterface outputRowMeta;
    private Result result;
    private Query query;
    private VariableSpace space;
    private List<List<Object>> rows;
    private List<String> headings;
    private Connection connection;

    public MondrianHelper(DatabaseMeta databaseMeta, String catalog, String queryString, VariableSpace space) {
        this.databaseMeta = databaseMeta;
        this.catalog = catalog;
        this.queryString = queryString;
        this.space = space;
    }

    public void openQuery() throws KettleDatabaseException {
        String connectString = "Provider=mondrian;Jdbc='" + this.space.environmentSubstitute(this.databaseMeta.getURL()) + "';" + "Catalog='" + this.space.environmentSubstitute(this.catalog) + "';" + "JdbcDrivers=" + this.space.environmentSubstitute(this.databaseMeta.getDriverClass()) + ";";
        if (!Const.isEmpty((String)this.databaseMeta.getUsername())) {
            connectString = connectString + "JdbcUser=" + this.space.environmentSubstitute(this.databaseMeta.getUsername()) + ";";
        }
        if (!Const.isEmpty((String)this.databaseMeta.getPassword())) {
            connectString = connectString + "JdbcPassword=" + this.space.environmentSubstitute(this.databaseMeta.getPassword()) + ";";
        }
        this.connection = DriverManager.getConnection((String)connectString, null);
        this.query = this.connection.parseQuery(this.queryString);
        this.result = this.connection.execute(this.query);
    }

    public void close() {
        if (this.result != null) {
            this.result.close();
        }
        if (this.query != null) {
            this.query.clone();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void createRectangularOutput() throws KettleDatabaseException {
        Axis[] axes = this.result.getAxes();
        if (axes.length != 2) {
            throw new KettleDatabaseException("Tabular output only supported for 2-dimensional results");
        }
        this.headings = new ArrayList<String>();
        this.rows = new ArrayList<List<Object>>();
        Axis rowsAxis = axes[1];
        Axis columnsAxis = axes[0];
        int rowOrdinal = -1;
        int[] coords = new int[]{0, 0};
        for (Position rowPos : rowsAxis.getPositions()) {
            coords[1] = ++rowOrdinal;
            if (rowOrdinal == 0) {
                for (Member rowMember : rowPos) {
                    this.headings.add(rowMember.getHierarchy().getUniqueName());
                }
                for (Position columnPos : columnsAxis.getPositions()) {
                    String heading = "";
                    for (Member columnMember : columnPos) {
                        if (!heading.equals("")) {
                            heading = heading + ", ";
                        }
                        heading = heading + columnMember.getUniqueName();
                    }
                    this.headings.add(heading);
                }
            }
            ArrayList<Object> rowValues = new ArrayList<Object>();
            for (Member rowMember : rowPos) {
                rowValues.add(rowMember.getUniqueName());
            }
            int columnOrdinal = 0;
            while (columnOrdinal < columnsAxis.getPositions().size()) {
                coords[0] = columnOrdinal++;
                Cell cell = this.result.getCell(coords);
                rowValues.add(cell.getValue());
            }
            this.rows.add(rowValues);
        }
        this.outputRowMeta = new RowMeta();
        for (int i = 0; i < this.rows.size() && i < 1; ++i) {
            List<Object> rowValues = this.rows.get(i);
            for (int c = 0; c < rowValues.size(); ++c) {
                ValueMeta valueMeta = new ValueMeta(this.headings.get(c));
                Object valueData = rowValues.get(c);
                if (valueData instanceof String) {
                    valueMeta.setType(2);
                } else if (valueData instanceof Date) {
                    valueMeta.setType(3);
                } else if (valueData instanceof Boolean) {
                    valueMeta.setType(4);
                } else if (valueData instanceof Long) {
                    valueMeta.setType(5);
                } else if (valueData instanceof Double) {
                    valueMeta.setType(1);
                } else if (valueData instanceof BigDecimal) {
                    valueMeta.setType(6);
                } else {
                    throw new KettleDatabaseException("Unhandled data type found '" + valueData.getClass().toString() + "'");
                }
                this.outputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
        }
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        DBCache.getInstance().put(cacheEntry, this.outputRowMeta);
    }

    public void createFlattenedOutput() throws KettleDatabaseException {
        Axis[] axes = this.result.getAxes();
        this.rows = new ArrayList<List<Object>>();
        this.headings = new ArrayList<String>();
        for (Axis axis : axes) {
            List positions = axis.getPositions();
            if (positions.isEmpty()) {
                return;
            }
            for (Member member : (Position)positions.get(0)) {
                Hierarchy hierarchy = member.getHierarchy();
                this.headings.add(hierarchy.getUniqueName());
            }
        }
        int[] coords = new int[axes.length];
        MondrianHelper.outputFlattenedRecurse(this.result, this.rows, new ArrayList<Object>(), coords, 0);
        this.outputRowMeta = new RowMeta();
        for (int i = 0; i < this.rows.size() && i < 1; ++i) {
            List<Object> rowValues = this.rows.get(i);
            for (int c = 0; c < rowValues.size(); ++c) {
                ValueMeta valueMeta = new ValueMeta(this.headings.get(c));
                Object valueData = rowValues.get(c);
                if (valueData instanceof String) {
                    valueMeta.setType(2);
                } else if (valueData instanceof Date) {
                    valueMeta.setType(3);
                } else if (valueData instanceof Boolean) {
                    valueMeta.setType(4);
                } else if (valueData instanceof Long) {
                    valueMeta.setType(5);
                } else if (valueData instanceof Double) {
                    valueMeta.setType(1);
                } else if (valueData instanceof BigDecimal) {
                    valueMeta.setType(6);
                } else {
                    throw new KettleDatabaseException("Unhandled data type found '" + valueData.getClass().toString() + "'");
                }
                this.outputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
        }
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        DBCache.getInstance().put(cacheEntry, this.outputRowMeta);
    }

    public RowMetaInterface getCachedRowMeta() {
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        return DBCache.getInstance().get(cacheEntry);
    }

    private static void outputFlattenedRecurse(Result result, List<List<Object>> rows, List<Object> rowValues, int[] coords, int axisOrdinal) {
        Axis[] axes = result.getAxes();
        if (axisOrdinal == axes.length) {
            Cell cell = result.getCell(coords);
            rowValues.add(cell.getValue());
            rows.add(new ArrayList<Object>(rowValues));
        } else {
            Axis axis = axes[axisOrdinal];
            int k = -1;
            int saveLength = rowValues.size();
            for (Position position : axis.getPositions()) {
                coords[axisOrdinal] = ++k;
                for (Member member : position) {
                    rowValues.add(member.getUniqueName());
                }
                MondrianHelper.outputFlattenedRecurse(result, rows, rowValues, coords, axisOrdinal + 1);
                while (rowValues.size() > saveLength) {
                    rowValues.remove(rowValues.size() - 1);
                }
            }
        }
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public Result getResult() {
        return this.result;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public List<String> getHeadings() {
        return this.headings;
    }
}

