/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.errorhandling;

import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.errorhandling.AbstractFileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.Messages;

public class FileErrorHandlerMissingFiles
extends AbstractFileErrorHandler {
    public static final String THIS_FILE_DOES_NOT_EXIST = Messages.getString("FileErrorHandlerMissingFiles.FILE_DOES_NOT_EXIST");
    public static final String THIS_FILE_WAS_NOT_ACCESSIBLE = Messages.getString("FileErrorHandlerMissingFiles.FILE_WAS_NOT_ACCESSIBLE");

    public FileErrorHandlerMissingFiles(Date date, String destinationDirectory, String fileExtension, String encoding, BaseStep baseStep) {
        super(date, destinationDirectory, fileExtension, encoding, baseStep);
    }

    public void handleLineError(long lineNr, String filePart) {
    }

    public void handleNonExistantFile(FileObject file) throws KettleException {
        this.handleFile(file);
        try {
            this.getWriter("NO_PARTS").write(THIS_FILE_DOES_NOT_EXIST);
            this.getWriter("NO_PARTS").write(Const.CR);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FileErrorHandlerMissingFiles.Exception.CouldNotCreateNonExistantFile") + file.getName().getURI(), (Throwable)e);
        }
    }

    public void handleNonAccessibleFile(FileObject file) throws KettleException {
        this.handleFile(file);
        try {
            this.getWriter("NO_PARTS").write(THIS_FILE_WAS_NOT_ACCESSIBLE);
            this.getWriter("NO_PARTS").write(Const.CR);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FileErrorHandlerMissingFiles.Exception.CouldNotCreateNonAccessibleFile") + file.getName().getURI(), (Throwable)e);
        }
    }
}

