/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SSL2HandshakeMessageParser<T extends SSL2HandshakeMessage>
extends ProtocolMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2HandshakeMessageParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, version, config);
    }

    protected void parseMessageLength(T message) {
        int mask;
        byte[] length;
        if ((this.peek() & 0xFFFFFF80) != 0) {
            length = this.parseByteArrayField(2);
            mask = 63;
            ((SSL2HandshakeMessage)message).setPaddingLength(0);
        } else {
            length = this.parseByteArrayField(3);
            mask = 127;
            ((SSL2HandshakeMessage)message).setPaddingLength(Integer.valueOf(length[2]));
        }
        int intLength = (length[0] & mask) << 8 | length[1] & 0xFF;
        ((SSL2HandshakeMessage)message).setMessageLength(intLength);
        LOGGER.debug("MessageLength: " + ((SSL2HandshakeMessage)message).getMessageLength().getValue());
    }

    protected void parseType(T msg) {
        ((SSL2HandshakeMessage)msg).setType(this.parseByteField(1));
        LOGGER.debug("Type: " + ((SSL2HandshakeMessage)msg).getType().getValue());
    }
}

