/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebXmlUpdater {
    private static final String JERSEY_PROP_PACKAGES = "com.sun.jersey.config.property.packages";
    private static final String JERSEY_PROP_PACKAGES_DESC = "Multiple packages, separated by semicolon(;), can be specified in param-value";
    private static final String POJO_MAPPING_FEATURE = "com.sun.jersey.api.json.POJOMappingFeature";
    private static final String PARAM_NAME_APPLICATION_CLASS = "javax.ws.rs.Application";
    private RestSupport restSupport;

    public WebXmlUpdater(RestSupport restSupport) {
        this.restSupport = restSupport;
    }

    public static Servlet getRestServletAdaptorByName(WebApp webApp, String servletName) {
        if (webApp != null) {
            for (Servlet s : webApp.getServlet()) {
                if (!servletName.equals(s.getServletName())) continue;
                return s;
            }
        }
        return null;
    }

    public WebApp findWebApp() {
        FileObject ddFo;
        WebModule wm = WebModule.getWebModule((FileObject)this.restSupport.getProject().getProjectDirectory());
        if (wm != null && (ddFo = wm.getDeploymentDescriptor()) != null) {
            try {
                return DDProvider.getDefault().getDDRoot(ddFo);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public void configRestPackages(String ... packs) throws IOException {
        try {
            InitParam initParam;
            this.addResourceConfigToWebApp();
            FileObject ddFO = this.getWebXml(false);
            WebApp webApp = this.findWebApp();
            if (webApp == null) {
                return;
            }
            if (webApp.getStatus() == 2 || webApp.getStatus() == 3) {
                return;
            }
            boolean needsSave = false;
            Servlet adaptorServlet = WebXmlUpdater.getRestServletAdaptor(webApp);
            if (adaptorServlet == null) {
                return;
            }
            InitParam[] initParams = adaptorServlet.getInitParam();
            boolean jerseyParamFound = false;
            boolean jacksonParamFound = false;
            for (InitParam initParam2 : initParams) {
                String paramValue;
                if (initParam2.getParamName().equals(JERSEY_PROP_PACKAGES)) {
                    jerseyParamFound = true;
                    paramValue = initParam2.getParamValue();
                    paramValue = paramValue != null ? paramValue.trim() : "";
                    if (paramValue.length() == 0 || paramValue.equals(".")) {
                        initParam2.setParamValue(this.getPackagesList(packs));
                        needsSave = true;
                        continue;
                    }
                    String[] existed = paramValue.split(";");
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    set.addAll(Arrays.asList(existed));
                    set.addAll(Arrays.asList(packs));
                    initParam2.setParamValue(this.getPackagesList(set));
                    needsSave = existed.length != set.size();
                    continue;
                }
                if (!initParam2.getParamName().equals(POJO_MAPPING_FEATURE)) continue;
                jacksonParamFound = true;
                paramValue = initParam2.getParamValue();
                if (paramValue != null) {
                    paramValue = paramValue.trim();
                }
                if (Boolean.TRUE.toString().equals(paramValue)) continue;
                initParam2.setParamValue(Boolean.TRUE.toString());
                needsSave = true;
            }
            if (!jerseyParamFound) {
                initParam = this.createJerseyPackagesInitParam(adaptorServlet, packs);
                adaptorServlet.addInitParam(initParam);
                needsSave = true;
            }
            if (!jacksonParamFound) {
                initParam = this.createInitParam(adaptorServlet, POJO_MAPPING_FEATURE, Boolean.TRUE.toString(), null);
                adaptorServlet.addInitParam(initParam);
                needsSave = true;
            }
            if (needsSave) {
                webApp.write(ddFO);
                this.restSupport.logResourceCreation();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getPackagesList(Iterable<String> packs) {
        StringBuilder builder = new StringBuilder();
        for (String pack : packs) {
            builder.append(pack);
            builder.append(';');
        }
        String packages = builder.length() > 0 ? builder.substring(0, builder.length() - 1) : builder.toString();
        return packages;
    }

    private String getPackagesList(String[] packs) {
        return this.getPackagesList(Arrays.asList(packs));
    }

    private InitParam createJerseyPackagesInitParam(Servlet adaptorServlet, String ... packs) throws ClassNotFoundException {
        return this.createInitParam(adaptorServlet, JERSEY_PROP_PACKAGES, this.getPackagesList(packs), JERSEY_PROP_PACKAGES_DESC);
    }

    private InitParam createInitParam(Servlet adaptorServlet, String name, String value, String description) throws ClassNotFoundException {
        InitParam initParam = (InitParam)adaptorServlet.createBean("InitParam");
        initParam.setParamName(name);
        initParam.setParamValue(value);
        if (description != null) {
            initParam.setDescription(description);
        }
        return initParam;
    }

    public void addResourceConfigToWebApp() throws IOException {
        FileObject ddFO = this.getWebXml(true);
        WebApp webApp = null;
        try {
            webApp = this.getWebApp();
        }
        catch (IllegalStateException ex) {
            return;
        }
        boolean servletUpdated = false;
        try {
            Servlet adaptorServlet = WebXmlUpdater.getRestServletAdaptor(webApp);
            if (adaptorServlet == null) {
                adaptorServlet = (Servlet)webApp.createBean("Servlet");
                adaptorServlet.setServletName("ServletAdaptor");
                boolean isSpring = this.restSupport.hasSpringSupport();
                if (isSpring) {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)adaptorServlet.createBean("InitParam");
                    initParam.setParamName(JERSEY_PROP_PACKAGES);
                    initParam.setParamValue(".");
                    initParam.setDescription(JERSEY_PROP_PACKAGES_DESC);
                    adaptorServlet.addInitParam(initParam);
                } else if (this.restSupport.hasJersey2(true)) {
                    adaptorServlet.setServletClass("org.glassfish.jersey.servlet.ServletContainer");
                } else {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                adaptorServlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(adaptorServlet);
                servletUpdated = true;
            }
            boolean mappingsUpdated = this.updateServletMapping(webApp, adaptorServlet.getServletName());
            if (servletUpdated || mappingsUpdated) {
                webApp.write(ddFO);
                this.restSupport.logResourceCreation();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void addJersey2ResourceConfigToWebApp(RestSupport.RestConfig restConfig) throws IOException {
        String applicationClassName = restConfig.getAppClassName();
        if (applicationClassName == null) {
            return;
        }
        FileObject ddFO = this.getWebXml(true);
        WebApp webApp = null;
        try {
            webApp = this.getWebApp();
        }
        catch (IllegalStateException ex) {
            return;
        }
        boolean servletUpdated = false;
        try {
            Servlet adaptorServlet = WebXmlUpdater.getRestServletAdaptor(webApp);
            if (adaptorServlet == null) {
                adaptorServlet = (Servlet)webApp.createBean("Servlet");
                adaptorServlet.setServletName("ServletAdaptor");
                adaptorServlet.setServletClass("org.glassfish.jersey.servlet.ServletContainer");
                InitParam initParam = (InitParam)adaptorServlet.createBean("InitParam");
                initParam.setParamName(PARAM_NAME_APPLICATION_CLASS);
                initParam.setParamValue(applicationClassName);
                adaptorServlet.addInitParam(initParam);
                adaptorServlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(adaptorServlet);
                servletUpdated = true;
            }
            boolean mappingsUpdated = this.updateServletMapping(webApp, adaptorServlet.getServletName());
            if (servletUpdated || mappingsUpdated) {
                webApp.write(ddFO);
                this.restSupport.logResourceCreation();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private boolean updateServletMapping(WebApp webApp, String servletName) throws ClassNotFoundException {
        boolean updated = false;
        String resourcesUrl = "/webresources/*";
        ServletMapping25 sm = WebXmlUpdater.getRestServletMapping(webApp);
        if (sm == null) {
            sm = (ServletMapping25)webApp.createBean("ServletMapping");
            sm.setServletName(servletName);
            sm.addUrlPattern(resourcesUrl);
            webApp.addServletMapping((ServletMapping)sm);
            updated = true;
        } else {
            boolean urlPatternChanged = false;
            String[] urlPatterns = sm.getUrlPatterns();
            if (urlPatterns.length == 0 || !resourcesUrl.equals(urlPatterns[0])) {
                urlPatternChanged = true;
            }
            if (urlPatternChanged) {
                if (urlPatterns.length > 0) {
                    sm.setUrlPattern(0, resourcesUrl);
                } else {
                    sm.addUrlPattern(resourcesUrl);
                }
                updated = true;
            }
        }
        return updated;
    }

    private WebApp getWebApp() throws IllegalStateException {
        WebApp webApp = this.findWebApp();
        if (webApp == null) {
            throw new IllegalStateException("Can not parse web.xml");
        }
        if (webApp.getStatus() == 2 || webApp.getStatus() == 3) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RestSupport.class, (String)"MSG_InvalidDD", (Object)webApp.getError()), 0));
            throw new IllegalStateException("Invalid web.xml");
        }
        return webApp;
    }

    public static ServletMapping25 getRestServletMapping(WebApp webApp) {
        if (webApp == null) {
            return null;
        }
        String servletName = null;
        for (Servlet servlet : webApp.getServlet()) {
            String servletClass = servlet.getServletClass();
            if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(servletClass) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(servletClass) && !"org.glassfish.jersey.servlet.ServletContainer".equals(servletClass)) continue;
            servletName = servlet.getServletName();
            break;
        }
        if (servletName != null) {
            for (Servlet servlet : webApp.getServletMapping()) {
                if (!servletName.equals(servlet.getServletName())) continue;
                return (ServletMapping25)servlet;
            }
        }
        return null;
    }

    public FileObject getWebXml(boolean createWebXmlIfMissing) throws IOException {
        WebModule wm = WebModule.getWebModule((FileObject)this.restSupport.getProject().getProjectDirectory());
        if (wm != null) {
            FileObject ddFo = wm.getDeploymentDescriptor();
            if (ddFo == null && createWebXmlIfMissing) {
                FileObject docBase;
                FileObject webInf = wm.getWebInf();
                if (webInf == null && (docBase = wm.getDocumentBase()) != null) {
                    webInf = docBase.createFolder("WEB-INF");
                }
                if (webInf != null) {
                    ddFo = DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInf);
                }
            }
            return ddFo;
        }
        return null;
    }

    private static Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet s : webApp.getServlet()) {
                String servletClass = s.getServletClass();
                if (!"org.glassfish.jersey.servlet.ServletContainer".equals(servletClass) && !"com.sun.jersey.spi.container.servlet.ServletContainer".equals(servletClass) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(servletClass) && !"com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servletClass)) continue;
                return s;
            }
        }
        return null;
    }

    public static boolean hasRestServletAdaptor(WebApp wa) {
        return WebXmlUpdater.getRestServletAdaptor(wa) != null;
    }
}

