/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.scopes;

import eu.hansolo.jdktools.scopes.Scope;
import java.util.Arrays;
import java.util.List;

public enum DownloadScope implements Scope
{
    DIRECTLY("Directly downloadable", "directly_downloadable"),
    NOT_DIRECTLY("Not directly downloadable", "not_directly_downloadable");

    private final String uiString;
    private final String apiString;

    private DownloadScope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    public static Scope fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "directly": 
            case "directly_downloadable": 
            case "directlyDownloadable": 
            case "DIRECTLY_DOWNLOADABLE": {
                return DIRECTLY;
            }
            case "not_directly": 
            case "not_directly_downloadable": 
            case "notDirectlyDownloadable": 
            case "NOT_DIRECTLY_DOWNLOADABLE": {
                return NOT_DIRECTLY;
            }
        }
        return NOT_FOUND;
    }

    public static List<DownloadScope> getAsList() {
        return Arrays.asList(DownloadScope.values());
    }
}

