/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.bucket.BucketItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class CloudAssetsJavaCompletion
implements Processor {
    private static final String JAVAX_DATA_SOURCE = "javax.sql.DataSource";
    private static final String JAKARTA_NAMED_ANNOTATION = "jakarta.inject.Named";
    private static final String MICRONAUT_JDBC_REPOSITORY_ANNOTATION = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String MICRONAUT_OBJECT_STORAGE = "io.micronaut.objectstorage.ObjectStorageOperations";
    private static final Set<String> supportedAnnotationTypes = Set.of("jakarta.inject.Named", "io.micronaut.data.jdbc.annotation.JdbcRepository");
    private Reference<ProcessingEnvironment> processingEnv;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        switch (((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString()) {
            case "jakarta.inject.Named": {
                if (!"value".contentEquals(member.getSimpleName())) break;
                return CloudAssetsJavaCompletion.completeReferenceNamesByClass(this.element2ReferenceClass(element));
            }
            case "io.micronaut.data.jdbc.annotation.JdbcRepository": {
                if (!"dataSource".contentEquals(member.getSimpleName())) break;
                return CloudAssetsJavaCompletion.completeReferenceNamesByClass(DatabaseItem.class);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = new WeakReference<ProcessingEnvironment>(processingEnv);
    }

    private Class<? extends OCIItem> element2ReferenceClass(Element element) {
        TypeMirror tm = element.asType();
        if (tm.getKind() == TypeKind.EXECUTABLE) {
            tm = ((ExecutableType)tm).getReturnType();
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            Elements elements = this.processingEnv.get().getElementUtils();
            Types types = this.processingEnv.get().getTypeUtils();
            tm = types.erasure(tm);
            TypeElement javaxDataSource = elements.getTypeElement(JAVAX_DATA_SOURCE);
            if (javaxDataSource != null && types.isAssignable(tm, javaxDataSource.asType())) {
                return DatabaseItem.class;
            }
            TypeElement objectStorage = elements.getTypeElement(MICRONAUT_OBJECT_STORAGE);
            if (objectStorage != null && types.isAssignable(tm, objectStorage.asType())) {
                return BucketItem.class;
            }
        }
        return null;
    }

    private static Iterable<? extends Completion> completeReferenceNamesByClass(Class<? extends OCIItem> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        final String format = "\"%s\"";
        return CloudAssets.getDefault().getReferenceNamesByClass(cls).stream().map(name -> new Completion(){
            final /* synthetic */ String val$name;
            {
                this.val$name = string2;
            }

            @Override
            public String getValue() {
                return String.format(format, this.val$name);
            }

            @Override
            public String getMessage() {
                return null;
            }
        }).collect(Collectors.toList());
    }
}

