/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.adm.AuditException;
import org.netbeans.modules.cloud.oracle.adm.AuditOptions;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.netbeans.modules.cloud.oracle.adm.ErrorUtils;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.adm.VulnerabilityWorker;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;

public class RunFileADMAction
implements ActionListener {
    private final FileObject file;

    public RunFileADMAction(FileObject file) {
        this.file = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Project project = FileOwnerQuery.getOwner((FileObject)this.file);
        KnowledgeBaseItem kbItem = VulnerabilityWorker.getKnowledgeBaseForProject(project);
        String projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
        if (kbItem != null) {
            try {
                VulnerabilityWorker.getInstance().findVulnerability(project, AuditOptions.makeNewAudit());
            }
            catch (AuditException exc) {
                ErrorUtils.processError(exc, Bundle.MSG_CreatingAuditFailed(projectDisplayName));
            }
        } else if (OCIManager.getDefault().getActiveProfile(kbItem) == null) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ProjectAuditInfo()));
        } else {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ProjectAuditNoKB(projectDisplayName)));
        }
    }
}

