/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.EnumSet;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBEnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;
    private boolean m_usesOrdinalValues;

    public JAXBEnumTypeConverter(Mapping mapping, String enumClassName, boolean usesOrdinalValues) {
        super((DatabaseMapping)mapping);
        this.m_enumClassName = enumClassName;
        this.m_usesOrdinalValues = usesOrdinalValues;
    }

    private ValidationException getClassForNameException(Exception ex) {
        return ValidationException.classNotFoundWhileConvertingClassNames((String)this.m_enumClassName, (Exception)ex);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        CallGetClassForName callGetClassForName = new CallGetClassForName(classLoader, this.m_enumClassName);
        this.m_enumClass = (Class)PrivilegedAccessHelper.callDoPrivilegedWithException((PrivilegedAccessHelper.PrivilegedExceptionCallable)callGetClassForName, this::getClassForNameException);
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        for (Enum theEnum : EnumSet.allOf(this.m_enumClass)) {
            if (this.getAttributeToFieldValues().get(theEnum) != null) continue;
            Object existingVal = this.getAttributeToFieldValues().get(theEnum.name());
            if (existingVal != null) {
                this.getAttributeToFieldValues().remove(theEnum.name());
                this.addConversionValue(existingVal, theEnum);
                continue;
            }
            if (this.m_usesOrdinalValues) {
                this.addConversionValue(theEnum.ordinal(), theEnum);
                continue;
            }
            this.addConversionValue(theEnum.name(), theEnum);
        }
        super.initialize(mapping, session);
    }

    public boolean usesOrdinalValues() {
        return this.m_usesOrdinalValues;
    }

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        try {
            return super.convertDataValueToObjectValue(fieldValue, session);
        }
        catch (DescriptorException e) {
            if (116 == e.getErrorCode() && fieldValue instanceof String) {
                fieldValue = ((String)fieldValue).trim();
                return super.convertDataValueToObjectValue(fieldValue, session);
            }
            throw e;
        }
    }

    private static final class CallGetClassForName
    implements PrivilegedAccessHelper.PrivilegedExceptionCallable<Class<?>> {
        private final ClassLoader classLoader;
        private final String m_enumClassName;

        private CallGetClassForName(ClassLoader classLoader, String m_enumClassName) {
            this.classLoader = classLoader;
            this.m_enumClassName = m_enumClassName;
        }

        public Class<?> call() throws Exception {
            return PrivilegedAccessHelper.getClassForName((String)this.m_enumClassName, (boolean)true, (ClassLoader)this.classLoader);
        }
    }
}

