/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.util.Arrays;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class NotJavaIdentifierValidator
extends StringValidator {
    private static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    NotJavaIdentifierValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String text) {
        if (text.trim().length() == 0) {
            return;
        }
        if (!NotJavaIdentifierValidator.isJavaIdentifier(text)) {
            problems.append(LocalizationSupport.getMessage(NotJavaIdentifierValidator.class, "ERR_JAVA_IDENTIFIER", text));
        }
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return Arrays.binarySearch(keywords, id) < 0;
    }
}

