/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.core.CreatorProvider;
import org.netbeans.modules.websvc.core.HandlerCreator;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.dev.wizard.FinishableProxyWizardPanel;
import org.netbeans.modules.websvc.core.dev.wizard.MessageHandlerWizard;
import org.netbeans.modules.websvc.core.dev.wizard.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LogicalHandlerWizard
implements WizardDescriptor.InstantiatingIterator {
    public int currentPanel = 0;
    private WizardDescriptor.Panel[] wizardPanels;
    private WizardDescriptor.Panel<WizardDescriptor> firstPanel;
    private WizardDescriptor wiz;
    private Project project;
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String[] HANDLER_STEPS = new String[]{NbBundle.getMessage(LogicalHandlerWizard.class, (String)"LBL_SpecifyLogicalHandlerInfo")};

    public static LogicalHandlerWizard create() {
        return new LogicalHandlerWizard();
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        this.project = Templates.getProject((WizardDescriptor)this.wiz);
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroups.length == 0) {
            SourceGroup[] genericSourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("generic");
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)Templates.createSimpleTargetChooser((Project)this.project, (SourceGroup[])genericSourceGroups, (WizardDescriptor.Panel)new BottomPanel()), sourceGroups, false);
        } else {
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)JavaTemplates.createPackageChooser((Project)this.project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)new BottomPanel(), (boolean)true));
        }
        JComponent c = (JComponent)this.firstPanel.getComponent();
        Utils.changeLabelInComponent(c, NbBundle.getMessage(LogicalHandlerWizard.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"), NbBundle.getMessage(LogicalHandlerWizard.class, (String)"LBL_LogicalHandler_Name"));
        c.putClientProperty("WizardPanel_contentData", HANDLER_STEPS);
        c.putClientProperty("WizardPanel_contentSelectedIndex", 0);
        c.getAccessibleContext().setAccessibleDescription(HANDLER_STEPS[0]);
        this.wizardPanels = new WizardDescriptor.Panel[]{this.firstPanel};
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public Set instantiate() throws IOException {
        HandlerCreator creator = CreatorProvider.getHandlerCreator(this.project, this.wiz);
        if (creator != null) {
            creator.createLogicalHandler();
            Object[] params = new Object[5];
            String creatorClassName = creator.getClass().getName();
            params[0] = creatorClassName.contains("jaxrpc") ? "JAX-RPC" : "JAX-WS";
            params[1] = this.project.getClass().getName();
            J2eeModule j2eeModule = JaxWsUtils.getJ2eeModule(this.project);
            params[2] = j2eeModule == null ? "J2SE" : j2eeModule.getModuleVersion() + "(" + JaxWsUtils.getModuleType(this.project) + ")";
            params[3] = "LOGICAL HANDLER";
            LogUtils.logWsWizard((Object[])params);
        }
        return Collections.EMPTY_SET;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardPanels[this.currentPanel];
    }

    public boolean hasNext() {
        return this.currentPanel < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public String name() {
        return NbBundle.getMessage(LogicalHandlerWizard.class, (String)"LBL_Create_LogicalHandler_Title");
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentPanel;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentPanel;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected int getCurrentPanelIndex() {
        return this.currentPanel;
    }

    private class BottomPanel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        private BottomPanel() {
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public void readSettings(WizardDescriptor settings) {
        }

        public Component getComponent() {
            return new JPanel();
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isValid() {
            ProjectInfo creator = new ProjectInfo(LogicalHandlerWizard.this.project);
            int projectType = creator.getProjectType();
            if (projectType == 0) {
                return MessageHandlerWizard.isValidInJavaProject(LogicalHandlerWizard.this.project, LogicalHandlerWizard.this.wiz);
            }
            if (ProjectUtil.isJavaEE5orHigher((Project)LogicalHandlerWizard.this.project) && (projectType == 1 || projectType == 3 || projectType == 2)) {
                return true;
            }
            WSStackUtils wsStackUtils = new WSStackUtils(LogicalHandlerWizard.this.project);
            if (!(ProjectUtil.isJavaEE5orHigher((Project)LogicalHandlerWizard.this.project) || projectType != 1 || wsStackUtils.isJsr109Supported() || wsStackUtils.isJsr109OldSupported())) {
                if (!wsStackUtils.hasJAXWSLibrary()) {
                    LogicalHandlerWizard.this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(BottomPanel.class, (String)"LBL_LogicalHandlerWarning"));
                    return false;
                }
                return true;
            }
            LogicalHandlerWizard.this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(BottomPanel.class, (String)"LBL_LogicalHandlerWarning"));
            return false;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(LogicalHandlerWizard.class);
        }
    }
}

