/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import java.util.Collection;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.php.RefactoringTask;
import org.netbeans.modules.refactoring.php.RefactoringUtils;
import org.netbeans.modules.refactoring.php.delete.PhpDeleteRefactoringUI;
import org.netbeans.modules.refactoring.php.delete.SafeDeleteSupport;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.PHPRenameFileRefactoringUI;
import org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        FileObject fo;
        FileObject fileObject = fo = this.isFromEditor(lookup) ? this.getFileObject(lookup) : null;
        return fo != null && RefactoringUtils.isRefactorable(fo) ? !RefactoringUtils.isOutsidePhp(lookup, fo) || !RefactoringUtils.isOutsidePHPDoc(lookup, fo) : false;
    }

    private FileObject getFileObject(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        Node n = nodes.size() == 1 ? (Node)nodes.iterator().next() : null;
        DataObject dob = n != null ? (DataObject)n.getLookup().lookup(DataObject.class) : null;
        return dob != null ? dob.getPrimaryFile() : null;
    }

    private boolean isFromEditor(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        return ec != null && ec.getOpenedPanes() != null;
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(ec)) {
            new RefactoringTask.TextComponentTask(ec){

                @Override
                protected RefactoringTask.RefactoringUIHolder createRefactoringUI(PHPParseResult info, int offset) {
                    RefactoringTask.RefactoringUIHolder result = RefactoringTask.RefactoringUIHolder.NONE;
                    WhereUsedSupport ctx = WhereUsedSupport.getInstance(info, offset);
                    if (ctx != null && ctx.getName() != null) {
                        result = new RefactoringUIHolderImpl(new WhereUsedQueryUI(ctx));
                    }
                    return result;
                }
            }.run();
        }
    }

    public boolean canRename(Lookup lookup) {
        boolean canRenameFile = this.canRenameFile(lookup);
        return canRenameFile ? canRenameFile : this.canRenameElement(lookup);
    }

    private boolean canRenameFile(Lookup lookup) {
        Node node;
        EditorCookie ec;
        boolean result = false;
        Collection nodes = lookup.lookupAll(Node.class);
        if (!(nodes.size() != 1 || (ec = (EditorCookie)(node = (Node)nodes.iterator().next()).getLookup().lookup(EditorCookie.class)) != null && RefactoringUtils.isFromEditor(ec))) {
            FileObject fo = RefactoringActionsProvider.getFileObjectFromNode(node);
            result = fo != null && "text/x-php5".equals(fo.getMIMEType());
        }
        return result;
    }

    private boolean canRenameElement(Lookup lookup) {
        return this.canFindUsages(lookup);
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(ec)) {
            this.renameElement(ec);
        } else {
            this.renameFile(lookup);
        }
    }

    private void renameElement(EditorCookie ec) {
        new RefactoringTask.TextComponentTask(ec){

            @Override
            protected RefactoringTask.RefactoringUIHolder createRefactoringUI(PHPParseResult info, int offset) {
                RefactoringTask.RefactoringUIHolder result = RefactoringTask.RefactoringUIHolder.NONE;
                WhereUsedSupport ctx = WhereUsedSupport.getInstance(info, offset);
                if (ctx != null && ctx.getName() != null) {
                    FileObject fileObject = ctx.getModelElement().getFileObject();
                    result = RefactoringUtils.isUsersFile(fileObject) ? new RefactoringUIHolderImpl(new PhpRenameRefactoringUI(ctx)) : RefactoringTask.RefactoringUIHolder.NOT_USERS_FILE;
                }
                return result;
            }
        }.run();
    }

    private void renameFile(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        assert (nodes.size() == 1);
        Node node = (Node)nodes.iterator().next();
        FileObject file = RefactoringActionsProvider.getFileObjectFromNode(node);
        UI.openRefactoringUI((RefactoringUI)new PHPRenameFileRefactoringUI(file));
    }

    public boolean canDelete(Lookup lookup) {
        FileObject fo = this.getFileObject(lookup);
        return fo != null && RefactoringUtils.isRefactorable(fo);
    }

    public void doDelete(Lookup lookup) {
        final boolean regularDelete = lookup.lookup(ExplorerContext.class) != null;
        Collection nodes = lookup.lookupAll(Node.class);
        assert (nodes.size() == 1);
        Node currentNode = (Node)nodes.iterator().next();
        new RefactoringTask.NodeToFileTask(currentNode){

            @Override
            protected RefactoringTask.RefactoringUIHolder createRefactoringUIHolder(PHPParseResult info) {
                RefactoringTask.RefactoringUIHolder result = RefactoringTask.RefactoringUIHolder.NONE;
                SafeDeleteSupport ctx = SafeDeleteSupport.getInstance(info);
                if (ctx != null) {
                    FileObject fileObject = ctx.getModel().getFileScope().getFileObject();
                    result = RefactoringUtils.isUsersFile(fileObject) ? new RefactoringUIHolderImpl(new PhpDeleteRefactoringUI(ctx, regularDelete)) : RefactoringTask.RefactoringUIHolder.NOT_USERS_FILE;
                }
                return result;
            }
        }.run();
    }

    static final class RefactoringUIHolderImpl
    implements RefactoringTask.RefactoringUIHolder {
        private final RefactoringUI refactoringUI;

        public RefactoringUIHolderImpl(RefactoringUI refactoringUI) {
            assert (refactoringUI != null);
            this.refactoringUI = refactoringUI;
        }

        @Override
        public void processUI(boolean parsingInProgress) {
            UI.openRefactoringUI((RefactoringUI)this.refactoringUI, (TopComponent)TopComponent.getRegistry().getActivated());
        }
    }
}

