/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceConsoleConnection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="fingerprint")
    private final String fingerprint;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="serviceHostKeyFingerprint")
    private final String serviceHostKeyFingerprint;
    @JsonProperty(value="vncConnectionString")
    private final String vncConnectionString;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "connectionString", "definedTags", "fingerprint", "freeformTags", "id", "instanceId", "lifecycleState", "serviceHostKeyFingerprint", "vncConnectionString"})
    public InstanceConsoleConnection(String compartmentId, String connectionString, Map<String, Map<String, Object>> definedTags, String fingerprint, Map<String, String> freeformTags, String id, String instanceId, LifecycleState lifecycleState, String serviceHostKeyFingerprint, String vncConnectionString) {
        this.compartmentId = compartmentId;
        this.connectionString = connectionString;
        this.definedTags = definedTags;
        this.fingerprint = fingerprint;
        this.freeformTags = freeformTags;
        this.id = id;
        this.instanceId = instanceId;
        this.lifecycleState = lifecycleState;
        this.serviceHostKeyFingerprint = serviceHostKeyFingerprint;
        this.vncConnectionString = vncConnectionString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getServiceHostKeyFingerprint() {
        return this.serviceHostKeyFingerprint;
    }

    public String getVncConnectionString() {
        return this.vncConnectionString;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceConsoleConnection(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", fingerprint=").append(String.valueOf(this.fingerprint));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", serviceHostKeyFingerprint=").append(String.valueOf(this.serviceHostKeyFingerprint));
        sb.append(", vncConnectionString=").append(String.valueOf(this.vncConnectionString));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConsoleConnection)) {
            return false;
        }
        InstanceConsoleConnection other = (InstanceConsoleConnection)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.serviceHostKeyFingerprint, other.serviceHostKeyFingerprint) && Objects.equals(this.vncConnectionString, other.vncConnectionString) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.fingerprint == null ? 43 : this.fingerprint.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.serviceHostKeyFingerprint == null ? 43 : this.serviceHostKeyFingerprint.hashCode());
        result = result * 59 + (this.vncConnectionString == null ? 43 : this.vncConnectionString.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="fingerprint")
        private String fingerprint;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="serviceHostKeyFingerprint")
        private String serviceHostKeyFingerprint;
        @JsonProperty(value="vncConnectionString")
        private String vncConnectionString;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            this.__explicitlySet__.add("fingerprint");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder serviceHostKeyFingerprint(String serviceHostKeyFingerprint) {
            this.serviceHostKeyFingerprint = serviceHostKeyFingerprint;
            this.__explicitlySet__.add("serviceHostKeyFingerprint");
            return this;
        }

        public Builder vncConnectionString(String vncConnectionString) {
            this.vncConnectionString = vncConnectionString;
            this.__explicitlySet__.add("vncConnectionString");
            return this;
        }

        public InstanceConsoleConnection build() {
            InstanceConsoleConnection model = new InstanceConsoleConnection(this.compartmentId, this.connectionString, this.definedTags, this.fingerprint, this.freeformTags, this.id, this.instanceId, this.lifecycleState, this.serviceHostKeyFingerprint, this.vncConnectionString);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceConsoleConnection model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("fingerprint")) {
                this.fingerprint(model.getFingerprint());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("serviceHostKeyFingerprint")) {
                this.serviceHostKeyFingerprint(model.getServiceHostKeyFingerprint());
            }
            if (model.wasPropertyExplicitlySet("vncConnectionString")) {
                this.vncConnectionString(model.getVncConnectionString());
            }
            return this;
        }
    }
}

