/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.DocumentationQuery;
import org.netbeans.modules.xml.schema.completion.ToolTipQuery;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.swing.plaf.LFCustoms;

public abstract class CompletionResultItem
implements CompletionItem {
    private static final Logger _logger = Logger.getLogger(CompletionResultItem.class.getName());
    private static final Color COLOR = LFCustoms.shiftColor((Color)new Color(64, 64, 255));
    public static final String ICON_ELEMENT = "element.png";
    public static final String ICON_ATTRIBUTE = "attribute.png";
    public static final String ICON_VALUE = "value.png";
    public static final String ICON_LOCATION = "org/netbeans/modules/xml/schema/completion/resources/";
    protected boolean shift = false;
    protected String typedChars;
    protected String itemText;
    protected Icon icon;
    protected CompletionPaintComponent component;
    protected AXIComponent axiComponent;
    protected int extraPaintGap = 16;
    protected TokenSequence tokenSequence;
    protected final CompletionContextImpl context;

    public CompletionResultItem(AXIComponent component, CompletionContext context) {
        this(component, context, null);
    }

    public CompletionResultItem(AXIComponent component, CompletionContext context, TokenSequence tokenSequence) {
        this.context = (CompletionContextImpl)context;
        this.axiComponent = component;
        this.setTokenSequence(tokenSequence);
        if (context != null) {
            this.typedChars = context.getTypedChars();
        }
    }

    Icon getIcon() {
        return this.icon;
    }

    public AXIComponent getAXIComponent() {
        return this.axiComponent;
    }

    public String getItemText() {
        return this.itemText;
    }

    public abstract String getDisplayText();

    public abstract String getReplacementText();

    public abstract int getCaretPosition();

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return LFCustoms.shiftColor((Color)COLOR);
    }

    public int getExtraPaintGap() {
        return this.extraPaintGap;
    }

    public void setExtraPaintGap(int extraPaintGap) {
        this.extraPaintGap = extraPaintGap;
    }

    public TokenSequence getTokenSequence() {
        return this.tokenSequence;
    }

    public void setTokenSequence(TokenSequence tokenSequence) {
        this.tokenSequence = tokenSequence;
    }

    protected int removeTextLength(JTextComponent component, int offset, int removeLength) {
        return removeLength;
    }

    protected int caretOffset() {
        return -1;
    }

    protected void prepare(JTextComponent component, String proposedText, int offset) {
    }

    protected void replaceText(final JTextComponent component, final String text, final int offset, final int len) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    int caretPos = component.getCaretPosition();
                    if (CompletionResultItem.this.context != null && CompletionResultItem.this.context.canReplace(text)) {
                        CompletionResultItem.this.prepare(component, text, offset);
                        int l2 = CompletionResultItem.this.removeTextLength(component, offset, len);
                        String insertingText = CompletionResultItem.this.getInsertingText(component, offset, text, l2);
                        if (l2 > 0) {
                            doc.remove(offset, l2);
                        }
                        doc.insertString(offset, insertingText, null);
                        caretPos = offset + CompletionResultItem.this.getCaretPosition();
                        caretPos -= text.length() - insertingText.length();
                    } else {
                        caretPos = offset + CompletionResultItem.this.getCaretPosition();
                    }
                    int docLength = doc.getLength();
                    if (docLength == 0) {
                        caretPos = 0;
                    } else if (caretPos > doc.getLength()) {
                        caretPos = doc.getLength();
                    }
                    component.setCaretPosition(caretPos);
                    String prefix = CompletionUtil.getPrefixFromTag(text);
                    if (prefix == null) {
                        return;
                    }
                    if (CompletionResultItem.this.context != null && !CompletionResultItem.this.context.isSpecialCompletion() && !CompletionResultItem.this.context.isPrefixBeingUsed(prefix)) {
                        String tns = CompletionResultItem.this.context.getTargetNamespaceByPrefix(prefix);
                        if (tns == null) {
                            tns = CompletionResultItem.this.context.getSuggestedNamespace().get(prefix);
                        }
                        if (tns != null) {
                            doc.insertString(CompletionUtil.getNamespaceInsertionOffset((Document)doc), " xmlns:" + prefix + "=\"" + tns + "\"", null);
                        }
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
                }
            }
        });
    }

    protected final TokenSequence createTokenSequence(JTextComponent component) {
        if (this.tokenSequence == null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)component.getDocument());
            this.tokenSequence = tokenHierarchy.tokenSequence();
        }
        return this.tokenSequence;
    }

    private String stripCommonPrefix(String prefix, String replacement, String original) {
        if (replacement.startsWith(prefix) && original.startsWith(prefix)) {
            return replacement.substring(prefix.length());
        }
        return replacement;
    }

    private void resetTokenSequence() {
        this.tokenSequence = null;
    }

    protected String getInsertingText(JTextComponent component, int textPos, String primaryText, int removeLen) {
        String tokenText;
        if (primaryText == null || primaryText.length() < 1) {
            return primaryText;
        }
        this.createTokenSequence(component);
        if (this.tokenSequence.move(textPos) == 0) {
            this.tokenSequence.movePrevious();
        } else {
            this.tokenSequence.moveNext();
        }
        Token token = this.tokenSequence.token();
        boolean isTextTag = CompletionUtil.isTextTag(token);
        if (!(isTextTag || CompletionUtil.isEndTagPrefix(token) || CompletionUtil.isTagFirstChar(token))) {
            return primaryText;
        }
        int tokenOffset = this.tokenSequence.offset();
        if (isTextTag) {
            boolean isCaretAfterTag;
            tokenText = token.text().toString();
            boolean bl = isCaretAfterTag = tokenText.startsWith("</") && textPos == tokenOffset + "</".length() || tokenText.startsWith("<") && textPos == tokenOffset + "<".length();
            if (!isCaretAfterTag) {
                return primaryText;
            }
        }
        tokenText = token.text().toString();
        if (removeLen > 0) {
            primaryText = this.stripCommonPrefix("</", primaryText, tokenText);
            primaryText = this.stripCommonPrefix("<", primaryText, tokenText);
        }
        if (primaryText.endsWith(">")) {
            boolean endPresent = false;
            block6: while (!endPresent && this.tokenSequence.moveNext()) {
                Token t = this.tokenSequence.token();
                switch ((XMLTokenId)t.id()) {
                    case WS: 
                    case ARGUMENT: 
                    case VALUE: 
                    case OPERATOR: {
                        continue block6;
                    }
                    case TAG: {
                        String tt = t.text().toString();
                        if (!tt.equals(">") && !tt.equals("/>")) break;
                        endPresent = true;
                        continue block6;
                    }
                }
                break;
            }
            if (endPresent) {
                primaryText = primaryText.substring(0, primaryText.length() - 1);
            }
        }
        if (tokenOffset > -1 && tokenOffset < textPos) {
            textPos = tokenOffset;
        }
        boolean isDifferentTextFound = false;
        int i = 0;
        while (i < primaryText.length()) {
            try {
                String strDoc = component.getText(textPos, 1);
                String strText = primaryText.substring(i, i + 1);
                boolean bl = isDifferentTextFound = !strDoc.equals(strText);
                if (isDifferentTextFound) {
                    break;
                }
            }
            catch (BadLocationException e) {
                _logger.log(Level.WARNING, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
                isDifferentTextFound = true;
            }
            ++i;
            ++textPos;
        }
        String text = isDifferentTextFound ? primaryText.substring(Math.max(0, i - removeLen)) : "";
        return text;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new DocumentationQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(this));
    }

    public void defaultAction(JTextComponent component) {
        int substOffset;
        String selectedText = component.getSelectedText();
        int charsToRemove = selectedText != null ? selectedText.length() : (this.typedChars == null ? 0 : this.typedChars.length());
        int n = substOffset = selectedText != null ? component.getSelectionStart() : component.getCaretPosition() - charsToRemove;
        if (!this.shift) {
            Completion.get().hideAll();
        }
        if (this.getReplacementText().equals(this.typedChars)) {
            return;
        }
        this.replaceText(component, this.getReplacementText(), substOffset, charsToRemove);
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public abstract CompletionPaintComponent getPaintComponent();

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        CompletionPaintComponent renderComponent = this.getPaintComponent();
        return renderComponent.getPreferredSize().width;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionPaintComponent renderComponent = this.getPaintComponent();
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        renderComponent.setSelected(selected);
        renderComponent.paintComponent(g);
    }
}

