/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SSECustomerKeyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="keySha256")
    private final String keySha256;

    @Deprecated
    @ConstructorProperties(value={"algorithm", "key", "keySha256"})
    public SSECustomerKeyDetails(Algorithm algorithm, String key, String keySha256) {
        this.algorithm = algorithm;
        this.key = key;
        this.keySha256 = keySha256;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeySha256() {
        return this.keySha256;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SSECustomerKeyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("algorithm=").append(String.valueOf((Object)this.algorithm));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", keySha256=").append(String.valueOf(this.keySha256));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSECustomerKeyDetails)) {
            return false;
        }
        SSECustomerKeyDetails other = (SSECustomerKeyDetails)((Object)o);
        return Objects.equals((Object)this.algorithm, (Object)other.algorithm) && Objects.equals(this.key, other.key) && Objects.equals(this.keySha256, other.keySha256) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.keySha256 == null ? 43 : this.keySha256.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Algorithm implements BmcEnum
    {
        Aes256("AES256");

        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Algorithm: " + key);
        }

        static {
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="keySha256")
        private String keySha256;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder keySha256(String keySha256) {
            this.keySha256 = keySha256;
            this.__explicitlySet__.add("keySha256");
            return this;
        }

        public SSECustomerKeyDetails build() {
            SSECustomerKeyDetails model = new SSECustomerKeyDetails(this.algorithm, this.key, this.keySha256);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SSECustomerKeyDetails model) {
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("keySha256")) {
                this.keySha256(model.getKeySha256());
            }
            return this;
        }
    }
}

