/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.spi;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.Utilities;
import org.openide.util.Lookup;

public abstract class ProjectHudsonProvider {
    public static ProjectHudsonProvider getDefault() {
        return new ProjectHudsonProvider(){

            @Override
            public Association findAssociation(Project p) {
                for (ProjectHudsonProvider php : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    Association a = php.findAssociation(p);
                    if (a == null) continue;
                    return a;
                }
                return null;
            }

            @Override
            public boolean recordAssociation(Project p, Association a) {
                for (ProjectHudsonProvider php : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    if (!php.recordAssociation(p, a)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract Association findAssociation(Project var1);

    public Project findAssociatedProject(Association assoc) {
        Project p;
        HashMap<Association, Project> assocs = new HashMap<Association, Project>();
        for (Project p2 : OpenProjects.getDefault().getOpenProjects()) {
            Association found = this.findAssociation(p2);
            if (assoc.equals(found)) {
                return p2;
            }
            if (!assocs.containsKey(assoc)) {
                assocs.put(found, p2);
                continue;
            }
            assocs.put(found, null);
        }
        if (assoc.getJobName() != null && (p = (Project)assocs.get(Association.fromString(assoc.getServerUrl()))) != null) {
            return p;
        }
        return null;
    }

    public abstract boolean recordAssociation(Project var1, Association var2);

    public static final class Association {
        private static final Pattern URL_PATTERN = Pattern.compile("(https?://.+?/)(?:view/([^/]+)/)?((?:job/(?:[^/]+)/)*)");
        private final String jobURL;
        private final String[] jobPath;
        private final String viewName;

        public Association(String serverURL, String jobName) throws IllegalArgumentException {
            URI.create(serverURL);
            if (!serverURL.endsWith("/")) {
                throw new IllegalArgumentException(serverURL + " must end in a slash");
            }
            if (!(jobName == null || jobName.length() != 0 && jobName.trim().equals(jobName))) {
                throw new IllegalArgumentException("Must provide a nonempty or null job name: " + jobName);
            }
            if (jobName != null && jobName.indexOf(47) != -1) {
                throw new IllegalArgumentException("No slashes permitted in job name: " + jobName);
            }
            this.jobURL = Association.getStandardJobUrl(serverURL, jobName);
            this.jobPath = new String[]{serverURL, jobName};
            this.viewName = null;
        }

        private static String getStandardJobUrl(String serverURL, String jobName) {
            return jobName != null ? serverURL + "job/" + Utilities.uriEncode((String)jobName) + "/" : serverURL;
        }

        public Association(String jobURL) throws IllegalArgumentException {
            URI.create(jobURL);
            if (!jobURL.endsWith("/")) {
                throw new IllegalArgumentException(jobURL + " must end in a slash");
            }
            this.jobURL = jobURL;
            Matcher m = URL_PATTERN.matcher(jobURL);
            if (!m.matches()) {
                throw new IllegalArgumentException("Cannot extract job path: " + jobURL);
            }
            String rawViewName = m.group(2);
            this.viewName = rawViewName == null || rawViewName.isEmpty() ? null : Utilities.uriDecode((String)rawViewName);
            String rawJobPath = m.group(3);
            this.jobPath = Association.extractJobPath(m.group(1), rawJobPath);
        }

        private static String[] extractJobPath(String rootURL, String rawPath) throws IllegalArgumentException {
            if (rawPath == null || rawPath.isEmpty()) {
                return new String[]{rootURL};
            }
            String[] elements = rawPath.split("/");
            assert (elements.length > 0 && elements.length % 2 == 0);
            String[] result = new String[elements.length / 2 + 1];
            result[0] = rootURL;
            for (int i = 0; i < elements.length; ++i) {
                String element = elements[i];
                if (i % 2 == 0) {
                    assert ("job".equals(element));
                    continue;
                }
                String decoded = Utilities.uriDecode((String)element);
                if (decoded.trim().isEmpty()) {
                    throw new IllegalArgumentException("Empty job name: " + rawPath);
                }
                result[i / 2 + 1] = decoded;
            }
            return result;
        }

        public static Association forJob(HudsonJob job) {
            return new Association(job.getUrl());
        }

        public String getServerUrl() {
            return this.jobPath[0];
        }

        public String getJobName() {
            if (this.jobPath.length == 2) {
                return this.jobPath[1];
            }
            if (this.jobPath.length > 2) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < this.jobPath.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append("/");
                    }
                    sb.append(this.jobPath[i]);
                }
                return sb.toString();
            }
            return null;
        }

        public String getViewName() {
            return this.viewName;
        }

        String[] getJobPath() {
            return Arrays.copyOf(this.jobPath, this.jobPath.length);
        }

        @CheckForNull
        public HudsonJob getJob() {
            if (this.jobPath == null || this.jobPath.length < 2) {
                return null;
            }
            HudsonInstance instance = HudsonManager.getInstance((String)this.jobPath[0]);
            if (instance == null) {
                return null;
            }
            if (this.jobPath.length == 2) {
                return this.findJobByName(instance.getJobs(), this.jobPath[1]);
            }
            HudsonFolder lastFolder = null;
            for (int i = 1; i < this.jobPath.length; ++i) {
                String name = this.jobPath[i];
                if (i == 1) {
                    lastFolder = this.findFolderByName(instance.getFolders(), name);
                    continue;
                }
                if (i < this.jobPath.length - 1 && lastFolder != null) {
                    lastFolder = this.findFolderByName(lastFolder.getFolders(), name);
                    continue;
                }
                if (lastFolder == null) continue;
                return this.findJobByName(lastFolder.getJobs(), name);
            }
            return null;
        }

        private HudsonFolder findFolderByName(Collection<HudsonFolder> folders, String name) {
            for (HudsonFolder folder : folders) {
                if (!name.equals(folder.getName())) continue;
                return folder;
            }
            return null;
        }

        private HudsonJob findJobByName(Collection<HudsonJob> jobs, String name) {
            for (HudsonJob job : jobs) {
                if (!name.equals(job.getName())) continue;
                return job;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Association)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.jobURL;
        }

        public static Association fromString(String s) {
            try {
                return new Association(s);
            }
            catch (IllegalArgumentException x) {
                Logger.getLogger(ProjectHudsonProvider.class.getName()).log(Level.WARNING, "Bad URL: {0}", s);
                return null;
            }
        }
    }
}

