/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.config.DatabaseOrmCompatibilityVersion;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@ConfigMapping(prefix="quarkus.hibernate-orm")
@ConfigRoot
public interface HibernateOrmConfig {
    @WithDefault(value="true")
    public boolean enabled();

    @ConfigDocSection
    public HibernateOrmConfigDatabase database();

    @WithParentName
    @WithUnnamedKey(value="<default>")
    @WithDefaults
    @ConfigDocMapKey(value="persistence-unit-name")
    public @WithUnnamedKey(value="<default>") Map<String, HibernateOrmConfigPersistenceUnit> persistenceUnits();

    default public HibernateOrmConfigPersistenceUnit defaultPersistenceUnit() {
        return this.persistenceUnits().get("<default>");
    }

    default public Map<String, HibernateOrmConfigPersistenceUnit> namedPersistenceUnits() {
        TreeMap<String, HibernateOrmConfigPersistenceUnit> map = new TreeMap<String, HibernateOrmConfigPersistenceUnit>();
        map.putAll(this.persistenceUnits());
        map.remove("<default>");
        return map;
    }

    public HibernateOrmConfigPersistenceXml persistenceXml();

    @ConfigDocSection
    public HibernateOrmConfigLog log();

    public Optional<Boolean> statistics();

    public Optional<Boolean> logSessionMetrics();

    public HibernateOrmConfigMetric metrics();

    default public boolean isAnyNonPersistenceXmlPropertySet() {
        return this.defaultPersistenceUnit().isAnyPropertySet() || !this.namedPersistenceUnits().isEmpty() || this.log().isAnyPropertySet() || this.statistics().isPresent() || this.logSessionMetrics().isPresent() || this.metrics().isAnyPropertySet();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigLog {
        @Deprecated
        @WithDefault(value="false")
        public boolean bindParam();

        @WithDefault(value="false")
        public boolean bindParameters();

        default public boolean isAnyPropertySet() {
            return this.bindParam() || this.bindParameters();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigMetric {
        @WithDefault(value="false")
        public boolean enabled();

        default public boolean isAnyPropertySet() {
            return this.enabled();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigDatabase {
        @WithName(value="orm-compatibility.version")
        @WithDefault(value="latest")
        @WithConverter(value=DatabaseOrmCompatibilityVersion.Converter.class)
        public DatabaseOrmCompatibilityVersion ormCompatibilityVersion();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceXml {
        @WithDefault(value="false")
        public boolean ignore();
    }
}

