/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.ldap.conf.EncryptionMethod;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPSSLProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(LDAPConnectionService.class);

    private LdapNetworkConnection createLDAPConnection(String host, int port, EncryptionMethod encryptionMethod, LDAPSSLProtocol sslProtocol, int timeout) throws GuacamoleException {
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(host);
        config.setLdapPort(port);
        config.setTimeout((long)timeout);
        switch (encryptionMethod) {
            case NONE: {
                logger.debug("Connection to LDAP server without encryption.");
                break;
            }
            case SSL: {
                logger.debug("Connecting to LDAP server using SSL/TLS.");
                config.setUseSsl(true);
                config.setSslProtocol(sslProtocol.toString());
                break;
            }
            case STARTTLS: {
                logger.debug("Connecting to LDAP server using STARTTLS.");
                config.setUseTls(true);
                config.setSslProtocol(sslProtocol.toString());
                break;
            }
            default: {
                throw new GuacamoleUnsupportedException("Unimplemented encryption method: " + (Object)((Object)encryptionMethod));
            }
        }
        return new LdapNetworkConnection(config);
    }

    private LdapNetworkConnection createLDAPConnection(String host, int port, EncryptionMethod encryptionMethod, int timeout) throws GuacamoleException {
        return this.createLDAPConnection(host, port, encryptionMethod, LDAPSSLProtocol.TLSv1_3, timeout);
    }

    private LdapNetworkConnection createLDAPConnection(LDAPConfiguration config) throws GuacamoleException {
        return this.createLDAPConnection(config.getServerHostname(), config.getServerPort(), config.getEncryptionMethod(), config.getSslProtocol(), config.getNetworkTimeout());
    }

    private LdapNetworkConnection createLDAPConnection(LDAPConfiguration config, String url) throws GuacamoleException {
        LdapUrl ldapUrl;
        try {
            ldapUrl = new LdapUrl(url);
        }
        catch (LdapException e) {
            logger.debug("Cannot connect to LDAP URL \"{}\": URL is invalid.", (Object)url, (Object)e);
            throw new GuacamoleServerException("Invalid LDAP URL.", (Throwable)e);
        }
        String host = ldapUrl.getHost();
        if (host == null || host.isEmpty()) {
            logger.debug("Cannot connect to LDAP URL \"{}\": no hostname is present.", (Object)url);
            throw new GuacamoleServerException("LDAP URL contains no hostname.");
        }
        EncryptionMethod encryptionMethod = EncryptionMethod.NONE;
        if ("ldaps://".equals(ldapUrl.getScheme())) {
            encryptionMethod = EncryptionMethod.SSL;
        } else if (config.getEncryptionMethod() == EncryptionMethod.STARTTLS) {
            logger.debug("Using STARTTLS for LDAP URL \"{}\" as the main LDAP connection described in guacamole.properties is configured to use STARTTLS.", (Object)url);
            encryptionMethod = EncryptionMethod.STARTTLS;
        }
        int port = ldapUrl.getPort();
        if (port < 1) {
            port = encryptionMethod.DEFAULT_PORT;
        }
        return this.createLDAPConnection(host, port, encryptionMethod, config.getSslProtocol(), config.getNetworkTimeout());
    }

    private LdapNetworkConnection bindAs(LdapNetworkConnection ldapConnection, String bindUser, String password) {
        LdapConnectionConfig config = ldapConnection.getConfig();
        config.setName(bindUser);
        config.setCredentials(password);
        try {
            ldapConnection.bind();
        }
        catch (LdapAuthenticationException e) {
            ldapConnection.close();
            logger.debug("Bind attempt with LDAP server as user \"{}\" failed.", (Object)bindUser, (Object)e);
            return null;
        }
        catch (LdapException e) {
            ldapConnection.close();
            logger.error("Binding with the LDAP server at \"{}\" as user \"{}\" failed: {}", new Object[]{config.getLdapHost(), bindUser, e.getMessage()});
            logger.debug("Unable to bind to LDAP server.", (Throwable)e);
            return null;
        }
        return ldapConnection;
    }

    private LdapNetworkConnection bindAs(LdapNetworkConnection ldapConnection, LdapNetworkConnection useCredentialsFrom) {
        Dn userDN;
        LdapConnectionConfig ldapConfig = useCredentialsFrom.getConfig();
        String username = ldapConfig.getName();
        String password = ldapConfig.getCredentials();
        try {
            userDN = new Dn(new String[]{username});
        }
        catch (LdapInvalidDnException e) {
            logger.error("Credentials of existing connection cannot be used. The username used (\"{}\") is not a valid DN.", (Object)username);
            logger.debug("Cannot bind using invalid DN.", (Throwable)e);
            ldapConnection.close();
            return null;
        }
        return this.bindAs(ldapConnection, userDN.getName(), password);
    }

    public LdapNetworkConnection bindAs(LDAPConfiguration config, String bindUser, String password) throws GuacamoleException {
        return this.bindAs(this.createLDAPConnection(config), bindUser, password);
    }

    public LdapNetworkConnection bindAs(LDAPConfiguration config, String url, LdapNetworkConnection useCredentialsFrom) throws GuacamoleException {
        return this.bindAs(this.createLDAPConnection(config, url), useCredentialsFrom);
    }

    public SearchRequest getSearchRequest(LDAPConfiguration config, Dn baseDn, ExprNode filter) throws GuacamoleException {
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setDerefAliases(config.getDereferenceAliases());
        searchRequest.setScope(SearchScope.SUBTREE);
        searchRequest.setFilter(filter);
        searchRequest.setSizeLimit((long)config.getMaxResults());
        searchRequest.setTimeLimit(config.getOperationTimeout());
        searchRequest.setTypesOnly(false);
        if (config.getFollowReferrals()) {
            searchRequest.followReferrals();
        }
        return searchRequest;
    }
}

