/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportEducationPanel
extends ReportPanel {
    public ReportEducationPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportEducationAction");
        this.reportPanel.setLayout(new MigLayout("wrap 2, fill", "[]20[fill, growprio 200]"));
        Player player = this.getMyPlayer();
        List<Colony> colonies = player.getColonyList();
        for (Colony colony : colonies) {
            for (Building building : colony.getBuildings()) {
                if (!building.canTeach()) continue;
                this.reportPanel.add((Component)this.createColonyButton(colony), "newline, split 2, flowy");
                BuildingPanel bp = new BuildingPanel(freeColClient, building);
                bp.initialize();
                this.reportPanel.add(bp);
                JPanel teacherPanel = this.getPanel("report.education.teachers");
                List<Unit> teachers = CollectionUtils.transform(colony.getUnits(), u -> building.canAdd((Locatable)u), Function.identity(), Unit.increasingSkillComparator);
                for (Unit u2 : teachers) {
                    teacherPanel.add(new UnitLabel(freeColClient, u2, true, true));
                }
                this.reportPanel.add((Component)teacherPanel, "split 2, flowy, grow");
                JPanel studentPanel = this.getPanel("report.education.students");
                for (Unit unit : colony.getUnitList()) {
                    Unit teacher = CollectionUtils.find(teachers, u -> unit.canBeStudent((Unit)u));
                    if (teacher == null) continue;
                    UnitLabel ul = new UnitLabel(freeColClient, unit, true, true);
                    studentPanel.add(ul);
                    Utility.localizeToolTip((JComponent)ul, StringTemplate.template("report.education.tooltip").addNamed("%skill%", unit.getTeachingType(teacher)));
                }
                this.reportPanel.add((Component)studentPanel, "grow");
            }
        }
    }

    private JPanel getPanel(String key) {
        JPanel result = new JPanel(new FlowLayout(3));
        result.setOpaque(false);
        result.setBorder(Utility.localizedBorder(key, Color.GRAY));
        return result;
    }
}

