untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ+rRwru8/NPqjRlv6J9DvMMN7QJETg4Utc4F0Aft8w29WDyz0vxM1iIcb8g4x3L6dKahAPQEJe8EoWb/u9lUEgU=

OpenBSD 6.0 errata 025, May 22, 2017:

The kernel could leak memory when processing ICMP packets with IP
options.  Note that pf(4) blocks such packets by default.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 025_icmp_opts.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/netinet/ip_icmp.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_icmp.c,v
retrieving revision 1.151
diff -u -p -r1.151 ip_icmp.c
--- sys/netinet/ip_icmp.c	9 Dec 2015 09:27:40 -0000	1.151
+++ sys/netinet/ip_icmp.c	22 May 2017 15:48:23 -0000
@@ -592,8 +592,10 @@ reflect:
 
 		icmpstat.icps_reflect++;
 		icmpstat.icps_outhist[icp->icmp_type]++;
-		if (!icmp_reflect(m, &opts, NULL))
+		if (!icmp_reflect(m, &opts, NULL)) {
 			icmp_send(m, opts);
+			m_free(opts);
+		}
 		return;
 
 	case ICMP_REDIRECT:
