untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ6yNUUNBraPrO/BUmtdK55+gqzrBaDp8fcGFTmDoV2EG/HMPRaE1ofDfTB0twnpHQWobBz9dxtYK1yiEfkVbEQs=

OpenBSD 6.0 errata 7, Sep 22, 2016:

Revert change that cleans up the EVP cipher context in EVP_EncryptFinal() and
EVP_DecryptFinal(). Some software relies on the previous behaviour.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 007_libcrypto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/crypto/evp/evp_enc.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/crypto/evp/Attic/evp_enc.c,v
retrieving revision 1.31
retrieving revision 1.31.2.1
diff -u -p -r1.31 -r1.31.2.1
--- lib/libssl/src/crypto/evp/evp_enc.c	30 May 2016 13:42:54 -0000	1.31
+++ lib/libssl/src/crypto/evp/evp_enc.c	22 Sep 2016 04:50:19 -0000	1.31.2.1
@@ -371,7 +371,6 @@ EVP_EncryptFinal(EVP_CIPHER_CTX *ctx, un
 	int ret;
 
 	ret = EVP_EncryptFinal_ex(ctx, out, outl);
-	(void) EVP_CIPHER_CTX_cleanup(ctx);
 	return ret;
 }
 
@@ -485,7 +484,6 @@ EVP_DecryptFinal(EVP_CIPHER_CTX *ctx, un
 	int ret;
 
 	ret = EVP_DecryptFinal_ex(ctx, out, outl);
-	(void) EVP_CIPHER_CTX_cleanup(ctx);
 	return ret;
 }
 
