#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 26 "parse.y"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/ip_ipsp.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <endian.h>
#include <err.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "bgpd.h"
#include "mrt.h"
#include "session.h"
#include "rde.h"
#include "log.h"

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t	 		 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};
int		 symset(const char *, const char *, int);
char		*symget(const char *);

static struct bgpd_config	*conf;
static struct network_head	*netconf;
static struct peer_head		*new_peers, *cur_peers;
static struct peer		*curpeer;
static struct peer		*curgroup;
static struct l3vpn		*curvpn;
static struct prefixset		*curpset, *curoset;
static struct prefixset_tree	*curpsitree;
static struct filter_head	*filter_l;
static struct filter_head	*peerfilter_l;
static struct filter_head	*groupfilter_l;
static struct filter_rule	*curpeer_filter[2];
static struct filter_rule	*curgroup_filter[2];

struct filter_rib_l {
	struct filter_rib_l	*next;
	char			 name[PEER_DESCR_LEN];
};

struct filter_peers_l {
	struct filter_peers_l	*next;
	struct filter_peers	 p;
};

struct filter_prefix_l {
	struct filter_prefix_l	*next;
	struct filter_prefix	 p;
};

struct filter_prefixlen {
	enum comp_ops		op;
	int			len_min;
	int			len_max;
};

struct filter_as_l {
	struct filter_as_l	*next;
	struct filter_as	 a;
};

struct filter_match_l {
	struct filter_match	 m;
	struct filter_prefix_l	*prefix_l;
	struct filter_as_l	*as_l;
	struct filter_prefixset	*prefixset;
} fmopts;

struct peer	*alloc_peer(void);
struct peer	*new_peer(void);
struct peer	*new_group(void);
int		 add_mrtconfig(enum mrt_type, char *, int, struct peer *,
		    char *);
int		 add_rib(char *, u_int, u_int16_t);
struct rde_rib	*find_rib(char *);
int		 get_id(struct peer *);
int		 merge_prefixspec(struct filter_prefix *,
		    struct filter_prefixlen *);
int		 expand_rule(struct filter_rule *, struct filter_rib_l *,
		    struct filter_peers_l *, struct filter_match_l *,
		    struct filter_set_head *);
int		 str2key(char *, char *, size_t);
int		 neighbor_consistent(struct peer *);
int		 merge_filterset(struct filter_set_head *, struct filter_set *);
void		 optimize_filters(struct filter_head *);
struct filter_rule	*get_rule(enum action_types);

int		 parsecommunity(struct filter_community *, int, char *);
int		 parseextcommunity(struct filter_community *, char *,
		    char *);
static int	 new_as_set(char *);
static void	 add_as_set(u_int32_t);
static void	 done_as_set(void);
static struct prefixset	*new_prefix_set(char *, int);
static void	 add_roa_set(struct prefixset_item *, u_int32_t, u_int8_t);

typedef struct {
	union {
		long long		 number;
		char			*string;
		struct bgpd_addr	 addr;
		u_int8_t		 u8;
		struct filter_rib_l	*filter_rib;
		struct filter_peers_l	*filter_peers;
		struct filter_match_l	 filter_match;
		struct filter_prefixset	*filter_prefixset;
		struct filter_prefix_l	*filter_prefix;
		struct filter_as_l	*filter_as;
		struct filter_set	*filter_set;
		struct filter_set_head	*filter_set_head;
		struct {
			struct bgpd_addr	prefix;
			u_int8_t		len;
		}			prefix;
		struct filter_prefixlen	prefixlen;
		struct prefixset_item	*prefixset_item;
		struct {
			u_int8_t		enc_alg;
			char			enc_key[IPSEC_ENC_KEY_LEN];
			u_int8_t		enc_key_len;
		}			encspec;
	} v;
	int lineno;
} YYSTYPE;

#line 182 "parse.c"
#define AS 257
#define ROUTERID 258
#define HOLDTIME 259
#define YMIN 260
#define LISTEN 261
#define ON 262
#define FIBUPDATE 263
#define FIBPRIORITY 264
#define RTABLE 265
#define NONE 266
#define UNICAST 267
#define VPN 268
#define RD 269
#define EXPORT 270
#define EXPORTTRGT 271
#define IMPORTTRGT 272
#define DEFAULTROUTE 273
#define RDE 274
#define RIB 275
#define EVALUATE 276
#define IGNORE 277
#define COMPARE 278
#define GROUP 279
#define NEIGHBOR 280
#define NETWORK 281
#define EBGP 282
#define IBGP 283
#define LOCALAS 284
#define REMOTEAS 285
#define DESCR 286
#define LOCALADDR 287
#define MULTIHOP 288
#define PASSIVE 289
#define MAXPREFIX 290
#define RESTART 291
#define ANNOUNCE 292
#define CAPABILITIES 293
#define REFRESH 294
#define AS4BYTE 295
#define CONNECTRETRY 296
#define DEMOTE 297
#define ENFORCE 298
#define NEIGHBORAS 299
#define ASOVERRIDE 300
#define REFLECTOR 301
#define DEPEND 302
#define DOWN 303
#define DUMP 304
#define IN 305
#define OUT 306
#define SOCKET 307
#define RESTRICTED 308
#define LOG 309
#define ROUTECOLL 310
#define TRANSPARENT 311
#define TCP 312
#define MD5SIG 313
#define PASSWORD 314
#define KEY 315
#define TTLSECURITY 316
#define ALLOW 317
#define DENY 318
#define MATCH 319
#define QUICK 320
#define FROM 321
#define TO 322
#define ANY 323
#define CONNECTED 324
#define STATIC 325
#define COMMUNITY 326
#define EXTCOMMUNITY 327
#define LARGECOMMUNITY 328
#define DELETE 329
#define PREFIX 330
#define PREFIXLEN 331
#define PREFIXSET 332
#define ROASET 333
#define ORIGINSET 334
#define OVS 335
#define ASSET 336
#define SOURCEAS 337
#define TRANSITAS 338
#define PEERAS 339
#define MAXASLEN 340
#define MAXASSEQ 341
#define SET 342
#define LOCALPREF 343
#define MED 344
#define METRIC 345
#define NEXTHOP 346
#define REJECT 347
#define BLACKHOLE 348
#define NOMODIFY 349
#define SELF 350
#define PREPEND_SELF 351
#define PREPEND_PEER 352
#define PFTABLE 353
#define WEIGHT 354
#define RTLABEL 355
#define ORIGIN 356
#define PRIORITY 357
#define ERROR 358
#define INCLUDE 359
#define IPSEC 360
#define ESP 361
#define AH 362
#define SPI 363
#define IKE 364
#define IPV4 365
#define IPV6 366
#define QUALIFY 367
#define VIA 368
#define NE 369
#define LE 370
#define GE 371
#define XRANGE 372
#define LONGER 373
#define MAXLEN 374
#define STRING 375
#define NUMBER 376
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    1,    2,    2,    3,    3,   15,
   15,   11,   53,   54,   66,   55,   55,   65,   65,   69,
   56,   56,   68,   68,   19,   71,   57,   57,   72,   58,
   58,   70,   70,   59,   59,   59,   59,   59,   59,   59,
   59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
   59,   59,   59,   59,   59,   59,   59,   59,   59,   74,
   73,   73,   73,   73,   73,   12,   12,   13,   13,   16,
   17,   17,   18,   18,    4,    4,   75,   60,   76,   76,
   76,   76,   77,   77,   77,   77,   77,   78,   80,   61,
   81,   62,   82,   82,   82,   82,   82,   79,   79,   79,
   84,   84,   84,   84,   83,   83,   83,   83,   83,   83,
   83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
   83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
   83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
   83,    8,    8,    6,    6,    7,    7,    7,   10,   10,
    5,    5,   52,   52,   63,   20,   20,   20,   21,   21,
   22,   22,   25,   25,   25,   26,   26,   27,   30,   30,
   29,   29,   28,   28,   28,   28,   28,   28,   46,   46,
   46,   46,   47,   47,   47,   45,   45,   44,   36,   36,
   38,   38,   37,   37,   37,   39,   39,   39,   35,   35,
   34,   34,   34,   34,   33,   85,   33,   31,   31,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   40,   40,   40,   40,   40,   51,   51,   51,   51,
   42,   42,   42,   43,   43,   24,   24,   23,   23,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   41,    9,   14,   64,   64,   67,
   67,   67,   67,   48,   48,   48,   48,   48,   48,   49,
   49,   50,   50,
};
const short yylen[] =
	{                                         2,
    0,    2,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    1,    1,    1,    1,    1,    2,
    1,    1,    3,    2,    0,    8,    5,    1,    3,    0,
    8,    5,    1,    3,    2,    0,    7,    4,    0,    8,
    5,    3,    5,    2,    3,    2,    2,    3,    3,    2,
    2,    2,    3,    5,    5,    7,    2,    2,    1,    4,
    6,    1,    3,    3,    4,    4,    2,    2,    3,    5,
    3,    4,    5,    5,    4,    1,    1,    1,    0,    1,
    3,    3,    1,    1,    0,    1,    0,    8,    0,    2,
    3,    3,    2,    3,    3,    2,    1,    0,    0,    5,
    0,    6,    0,    2,    3,    3,    3,    4,    3,    0,
    0,    2,    3,    3,    2,    2,    3,    2,    2,    2,
    1,    1,    2,    2,    2,    3,    3,    3,    3,    3,
    3,    2,    2,    3,    3,    2,    3,    4,    4,    3,
    8,    2,    2,    6,    1,    1,    2,    3,    2,    2,
    2,    0,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    0,    2,    7,    1,    1,    1,    0,    1,
    1,    1,    0,    2,    6,    1,    3,    1,    1,    5,
    1,    3,    1,    1,    2,    2,    1,    1,    2,    2,
    2,    4,    1,    3,    4,    1,    3,    2,    1,    3,
    1,    3,    2,    4,    3,    1,    3,    4,    1,    3,
    1,    1,    2,    3,    0,    0,    2,    1,    2,    1,
    1,    2,    2,    2,    3,    3,    2,    2,    3,    2,
    2,    0,    1,    2,    3,    4,    1,    1,    1,    1,
    0,    2,    6,    3,    1,    1,    1,    0,    1,    2,
    3,    3,    2,    3,    3,    2,    3,    3,    2,    3,
    3,    2,    2,    2,    2,    2,    2,    2,    1,    2,
    2,    3,    4,    4,    2,    1,    1,    0,    2,    0,
    1,    2,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  166,
  167,  168,    0,    0,    0,    0,    0,    0,    0,    2,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   59,   62,    0,   14,   16,   15,   17,    0,
   80,   46,    0,   47,    0,   22,   51,   50,   67,    0,
    0,    0,    0,   21,    0,    0,  154,  155,    0,    0,
    0,    0,   68,    0,    0,    0,   58,   52,   57,    0,
    0,    0,    0,    0,   24,    0,  170,    0,    3,    4,
    5,    6,    7,    8,    9,   10,   11,   12,   13,    0,
   45,   48,   49,    0,    0,    0,   63,   64,   20,    0,
    0,    0,    0,  160,  159,    0,    0,    0,    0,   71,
    0,   76,   77,    0,    0,   78,   69,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   83,   84,   99,
   87,    0,    0,   65,  103,   72,   81,   82,    0,    0,
   75,  269,  246,    0,  247,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  242,    0,   86,
   60,    0,    0,  279,   38,    0,    0,    0,   66,  178,
    0,  174,  171,  172,    0,    0,    0,    0,   54,    0,
   73,   74,  249,    0,  250,    0,    0,  253,    0,    0,
  256,    0,    0,  264,  263,  265,  266,  262,  267,  268,
  270,  259,    0,    0,  271,  276,  275,    0,    0,    0,
   70,   32,    0,    0,    0,    0,   41,    0,   27,    0,
    0,    0,    0,  187,  188,  183,    0,  184,  179,    0,
    0,  100,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  121,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  104,
  102,    0,  145,    0,    0,    0,  251,  252,  254,  255,
  257,  258,  260,  261,  245,    0,  272,   61,   33,    0,
    0,  233,    0,   35,    0,    0,    0,    0,    0,    0,
   18,   19,   28,    0,    0,  176,  185,  186,    0,    0,
    0,  111,    0,    0,   56,  107,    0,  125,  132,  133,
  124,    0,  115,    0,  119,  120,    0,    0,    0,    0,
    0,    0,  149,    0,    0,  136,  147,    0,  123,    0,
  151,  150,    0,  142,    0,  143,  161,  162,    0,  106,
  105,  274,  273,    0,    0,    0,    0,  285,  286,  288,
    0,  284,  287,  289,    0,  234,   42,    0,    0,   37,
    0,    0,    0,    0,    0,    0,  181,    0,  165,  237,
    0,    0,    0,    0,    0,  238,  239,  240,    0,    0,
    0,    0,    0,    0,    0,    0,  218,  221,  199,  220,
    0,    0,  109,    0,    0,    0,    0,    0,   90,   88,
   97,    0,  126,  117,    0,  137,  130,  128,  129,  131,
  156,  157,  158,  127,  135,  134,  148,    0,    0,    0,
  140,    0,  243,  244,   31,   34,  293,  292,    0,  235,
  283,    0,   40,   26,   29,  175,  177,    0,    0,    0,
    0,    0,    0,  191,    0,  230,  277,  231,  222,  223,
  228,  227,  189,  190,  201,    0,  224,  219,  212,    0,
  291,  290,    0,    0,  203,    0,    0,  112,  108,    0,
   92,   96,   93,    0,    0,   91,  153,    0,    0,    0,
    0,  236,   43,  180,  182,  226,  225,    0,  196,    0,
    0,  198,  229,    0,  200,    0,  205,    0,  209,    0,
    0,    0,  213,  114,  113,   94,   95,    0,    0,    0,
    0,  192,  282,  202,    0,    0,  204,  214,  144,    0,
    0,  197,    0,  210,    0,  195,  208,    0,  141,  164,
};
const short yydgoto[] =
	{                                       1,
  302,   50,  474,  171,  349,   71,  424,  416,  217,  118,
   57,  125,  127,  458,   65,  238,  224,  140,  225,   31,
   88,  185,  194,  167,  136,  305,  182,  239,  378,  240,
  396,  397,  310,  509,  510,  398,  399,  466,  511,  294,
  285,  120,  286,  499,  500,  400,  501,  365,  476,  439,
  401,  539,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,  130,  304,  230,  299,  290,  223,  226,
  176,  228,   43,  273,  187,  314,  412,   45,  242,  186,
  110,  190,  274,  402,  311,
};
const short yysindex[] =
	{                                      0,
  187,   87, -236, -275, -228, -152, -250, -248, -244, -238,
 -214, -225,   -2, -224, -177, -220, -172, -250, -250,    0,
    0,    0, -168,   86, -164, -161, -149, -141,  188,    0,
  -67,  246,  255,  259,  286,  291,  294,  298,  300,  305,
  311,  321,    0,    0,   55,    0,    0,    0,    0,  -11,
    0,    0,   -6,    0, -275,    0,    0,    0,    0,  114,
  -16,  101,  -53,    0,    8,   17,    0,    0,  355,  357,
 -120,   70,    0,   35, -242,  105,    0,    0,    0,  299,
  404,  303,  304,   53,    0, -225,    0,  153,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -132,
    0,    0,    0,   61, -221,   62,    0,    0,    0,  315,
   70,   64,   65,    0,    0,   72,   66,   70,  415,    0,
   78,    0,    0,   73,   79,    0,    0,  404,  404,  331,
  404,  404,   82,    8, -117,  -75,  355,    0,    0,    0,
    0,   84,  182,    0,    0,    0,    0,    0,   70,   70,
    0,    0,    0,  133,    0,  -34,  -26,  -25, -109,   93,
   98,   88,  -22,   92,  100,  404,  133,    0,  102,    0,
    0,   73,  345,    0,    0, -115,  351,  353,    0,    0,
  404,    0,    0,    0, -108,  359,  361,  223,    0,  339,
    0,    0,    0, -269,    0,  113,  116,    0,  117,  119,
    0,  124,  125,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  131,  135,    0,    0,    0,  778,  115,   73,
    0,    0, -115, -251,  175,   91,    0, -115,    0,  -82,
  138, -236,  139,    0,    0,    0,  404,    0,    0,    0,
  421,    0,    0, -250,  505, -217, -147,  141, -236, -236,
 -225, -275,  146,    0,  148,  -63,  142, -175, -250, -275,
  263,  151,  152,  156, -250,  232, -250,  721,  -62,    0,
    0,  537,    0,  539,  176,  177,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   91,    0,    0,    0,   91,
   -9,    0,  174,    0,  -82,  404,  543,  429, -115,   91,
    0,    0,    0,   91,   91,    0,    0,    0, -189,   70,
  676,    0,  430,   26,    0,    0,  180,    0,    0,    0,
    0,  -11,    0,    8,    0,    0,  266, -250, -250, -250,
 -250,    5,    0, -250, -250,    0,    0,  183,    0,   14,
    0,    0,    9,    0,  404,    0,    0,    0, -185,    0,
    0,    0,    0,  434,  778,  435, -115,    0,    0,    0,
  -35,    0,    0,    0,  185,    0,    0,    0,  404,    0,
  226,  439,  440,  -82,  441,  138,    0,   91,    0,    0,
 -261, -101,  195,  199,  201,    0,    0,    0,  205,  212,
 -222, -251, -251, -195,  203,  676,    0,    0,    0,    0,
   96,  374,    0,  579, -250,  215,  217,  218,    0,    0,
    0,  584,    0,    0,  220,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -225, -225,  778,
    0,  234,    0,    0,    0,    0,    0,    0,  224,    0,
    0,  -82,    0,    0,    0,    0,    0,  476, -189,  227,
  228,  -97, -251,    0, -251,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   38,    0,    0,    0,  229,
    0,    0,   54,  -35,    0,  -82,  595,    0,    0,  596,
    0,    0,    0,  233,  237,    0,    0,    8,    8,   91,
  231,    0,    0,    0,    0,    0,    0, -115,    0,   94,
  488,    0,    0,  404,    0, -195,    0,  112,    0,   94,
  490,  -82,    0,    0,    0,    0,    0,  491,  242,   39,
 -115,    0,    0,    0,   68,  112,    0,    0,    0,  243,
  -97,    0,   54,    0,  244,    0,    0,  247,    0,    0,};
const short yyrindex[] =
	{                                      0,
  340,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -204,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  611,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  509,    0,    0,    0,    0,    0,
    0,  624,    0,    0,    0,  628,    0,    0,    0,    0,
  -95,    0,    0,    0,    0,    0,    0,   85,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  635,    0,    0,    0,    0,    0,
  624,    0,    0,    0,    0,    0,    0,  624,    0,    0,
    0,    0,    0,  636,    0,    0,    0,  -95,  474,  -49,
  -95,  -95,    0,  637,    0,    0,   37,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  624,  624,
    0,    0,    0, -259,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  792,  260,    0,    0,    0,
    0,   45,   33,    0,    0,    0,   40,   42,    0,    0,
  278,    0,    0,    0,    0,  644,    0,  646,    0,  340,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  636,
    0,    0,    0,    2,    0,  -92,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -187,    0,    0,  202,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   67,
    0,   69,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  743,    0,    0,    0,  -92,
    0,    0,    0,    0,    0,  625,  508,    0,    0,  -92,
    0,    0,    0,  -92,  -98,    0,    0,    0,    0,  624,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   71,    0,   74,    0,    0,   75,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  792,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  707,  591,    0,
    0,    0,    0,    0,    0,    0,    0,  -66,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  245,  245,    0,    0,   15,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   59,    0,  245,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -192,    0,    0,    0,    0,
    0,    0,    0,    6,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   81,   95,  743,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -88,
    0,    0,    0,  -47,    0,    0,    0,    0,    0,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   44,
    0,    0,    0,    0,  134,    0,    0,    0,    0,    0,
  532,    0,  540,    0,   97,    0,    0,    0,    0,    0,};
const short yygindex[] =
	{                                      0,
   36,  -24, -206, -112,    0,  411,    0,    0,    0,    0,
  -17,  319,    0,    0,  -73,   -1,  -13,    0, -188,    0,
    0,    0,  502, -255,    0,    0, -193, -264,    0,    0,
    0,  274,    0, -370,  165,    0, -319,    0,  149, -191,
  -79,  -77,  249, -354,  186,    0,  157,    0,    0,  213,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  499,    0,    0, -124,    0,    0,  519,    0,    0,  464,
    0,    0,  379,  693,    0,    0,    0,    0,    0,    0,
    0,    0, -212,    0,    0,
};
#define YYTABLESIZE 1148
const short yytable[] =
	{                                      72,
   78,   79,   52,  173,  174,  181,  177,  178,  196,  438,
  197,  232,  134,  278,  237,  211,  199,  202,  200,  203,
  213,  452,  214,  303,  217,  498,  278,  454,  313,  278,
  475,   53,  278,  146,  289,  409,  193,  306,   49,  168,
  151,  218,  317,  142,  377,  232,   80,  504,  504,  211,
  363,  362,  364,  103,   85,  395,  231,  461,  278,  221,
   61,  380,  122,  123,  280,  275,  211,  232,  232,  278,
  169,  191,  192,  450,  465,  248,  146,  504,  122,  291,
  116,  297,  297,  118,  152,  101,  139,  143,  367,  233,
  138,  278,  234,  235,  278,  278,   46,   74,  138,   51,
  296,  298,  232,  504,  139,  276,  163,  288,  334,   55,
  371,  297,  309,  451,  472,  248,  169,  169,  319,  122,
  123,  292,  293,  335,   56,  320,  232,   58,  211,   62,
  211,   59,  124,  236,  297,  278,   60,  297,   47,   48,
  395,  386,  387,  388,  280,  280,  280,   54,  232,   64,
  410,   73,   51,   56,   76,  534,  472,  208,  318,   80,
   63,  354,  505,  531,  280,  356,  532,  445,  436,   85,
  233,  368,  472,  234,  235,  372,  508,  324,  431,  373,
  375,  232,  447,  232,  495,   51,  524,  278,  346,  480,
  280,  146,  533,  122,  280,  116,   30,   75,  118,  152,
  463,  464,   77,  114,  115,  138,   80,  307,   81,  278,
   82,  215,  280,   83,  236,  280,  280,   84,  473,  139,
  430,  163,  107,  108,  322,  323,  315,  328,  206,  329,
  330,  331,  379,   85,  116,  493,  117,  204,  205,  206,
  207,  336,  137,   70,  441,  183,  184,  342,   86,  344,
  325,  278,   87,  448,  232,   89,  280,  180,  337,   69,
   70,  502,  211,  503,   90,   51,   51,   49,   91,  513,
  421,  422,  423,   69,   70,  434,  280,   69,   70,  278,
  278,  404,  280,  280,   49,   49,  280,  280,  405,  278,
  278,  278,  301,   48,  406,   92,  407,  408,  347,  348,
   93,   67,   68,   94,  211,  528,   13,   95,  280,   96,
  417,  418,  419,  420,   97,  232,  425,  426,  122,  123,
   98,  278,  428,  429,  216,   36,   36,  278,  278,   66,
   99,  211,  211,  211,  100,  211,  437,  211,  232,  211,
  211,  195,  211,  211,  211,  211,  211,  211,  270,  198,
  201,  211,  469,  212,  488,  489,  217,  414,  105,  358,
  359,  360,   67,   68,   48,  518,  361,  232,  453,  102,
  211,  211,   69,   70,  211,  104,  232,  232,  106,  523,
  211,  211,  109,  478,  232,  232,  232,  482,  232,  462,
  232,  111,  232,  232,  469,  232,  232,  232,  232,  232,
  232,  112,  280,  113,  232,  173,  173,   30,   30,  121,
  469,  119,  126,  129,   39,   39,   25,   25,  280,  280,
  133,  128,  471,  232,  232,  131,  132,  135,  301,   48,
  312,  470,  280,  232,  232,  141,  144,  145,  453,  147,
  148,  150,    2,    3,    4,    5,  149,    6,  170,    7,
    8,    9,  169,  172,   10,  175,  179,  189,  216,  188,
   11,  193,  211,  271,  471,   12,  215,   13,  209,  222,
  301,   48,  280,  210,  216,  227,  220,  229,  280,  280,
  471,  241,   14,  243,  453,  244,  301,   48,  277,  287,
   15,  278,  279,   16,  280,   17,   18,   19,  479,  281,
  282,  232,  280,   20,   21,   22,  283,  453,  280,  280,
  284,  295,  180,  308,  316,  321,  333,  453,   23,   24,
   25,  326,   26,  327,  338,  339,  340,  216,  216,  216,
  341,  216,   27,  216,  278,  216,  216,  166,  216,  216,
  216,  216,  216,  215,  343,   28,  350,  216,  351,  366,
  352,  353,  369,  370,  403,  413,  415,  427,  433,  435,
  440,   29,  442,  443,  444,  446,  216,  216,  281,  455,
  232,  232,  232,  456,  232,  457,  232,  467,  232,  232,
  459,  232,  232,  232,  232,  232,  232,  460,  481,  483,
  232,  484,  485,  486,  245,  487,  491,  246,  278,  492,
  494,  496,  497,  507,  514,  515,  519,  516,  247,  232,
  232,  517,  522,  248,  527,  529,  530,  535,  538,   98,
   44,  540,  249,  250,  251,  252,  253,  254,  255,  477,
  256,  101,  246,  241,  248,  257,  258,   79,  259,  260,
  261,  262,  263,  247,   53,   85,   23,  264,  248,  265,
  266,  278,  278,  110,  267,   55,  194,  249,  250,  251,
  252,  253,  254,  255,  207,  256,  332,  432,  219,  468,
  257,  258,  525,  259,  260,  261,  262,  263,  490,  246,
  268,  537,  264,  520,  265,  266,  512,  536,  272,  267,
  247,  300,  411,   44,    0,  248,    0,    0,  269,    0,
    0,    0,    0,    0,  249,  250,  251,  252,  253,  254,
  255,    0,  256,    0,  152,  268,    0,  257,  258,    0,
  259,  260,  261,  262,  263,    0,    0,    0,    0,  264,
  278,  265,  266,  269,    0,    0,  267,    0,    0,    0,
  153,  154,  155,    0,    0,    0,    0,    0,    0,  278,
    0,    0,  278,    0,    0,  278,  278,  156,  157,  158,
  159,    0,  268,    0,  281,  160,  161,  162,  163,  164,
  165,    0,  278,  278,    0,    0,    0,    0,    0,    0,
  269,    0,    0,    0,    0,    0,  281,    0,    0,  281,
  281,    0,    0,    0,    0,    0,  278,    0,  394,  278,
  278,  278,    0,    0,  355,    0,  281,  281,  357,    0,
  278,  278,  278,    0,    0,    0,  278,  278,  278,  278,
    0,    0,  374,  376,  278,  278,  278,  278,  278,  278,
  281,  279,    0,  281,  281,  281,    0,    0,    0,    0,
    0,    0,  278,  345,  281,  281,  281,  278,  278,  278,
  281,  281,  281,  281,    0,    0,    0,    0,  281,  281,
  281,  281,  281,  281,    0,    0,    0,  278,    0,  278,
    0,    0,  278,  278,    0,    0,  281,    0,    0,    0,
    0,  278,  281,  281,    0,    0,    0,    0,    0,  278,
  278,    0,    0,    0,    0,    0,  449,    0,    0,    0,
    0,    0,    0,  278,    0,    0,  278,  278,    0,    0,
    0,    0,    0,  278,    0,    0,  278,  278,  278,    0,
    0,    0,    0,    0,  278,    0,    0,  278,  278,  278,
    0,    0,  380,  278,  278,  278,  278,    0,    0,    0,
    0,  278,  278,  278,  278,  278,  278,  278,    0,    0,
  278,  278,  278,    0,    0,    0,    0,    0,    0,  278,
    0,    0,    0,  282,    0,  278,  278,  278,  278,  278,
  278,    0,    0,    0,    0,  278,  278,  278,  278,  278,
  278,    0,    0,    0,  506,  282,    0,    0,  282,  282,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  278,
  278,  153,  381,  155,    0,  382,  282,  383,  355,  384,
  385,    0,  386,  387,  388,  389,  390,    0,  521,    0,
  152,  391,    0,    0,    0,    0,    0,    0,  526,  282,
    0,    0,  282,  282,  282,    0,    0,    0,  521,    0,
  392,  393,  280,  526,    0,    0,  153,  154,  155,  282,
  282,  282,  282,    0,    0,    0,    0,  282,  282,  282,
  282,  282,  282,  156,  157,  158,  159,    0,  280,  280,
  280,  160,  161,  162,  163,  164,  165,  152,    0,    0,
    0,  282,  282,    0,    0,  280,  280,  280,  280,    0,
    0,  278,    0,  280,  280,  280,  280,  280,  280,    0,
    0,    0,    0,  153,  154,  155,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  278,  278,  278,
  156,  157,  158,  159,    0,    0,    0,    0,  160,  161,
  162,  163,  164,  165,  278,  278,  278,  278,    0,    0,
    0,    0,  278,  278,  278,  278,  278,  278,
};
const short yycheck[] =
	{                                      13,
   18,   19,    4,  128,  129,  123,  131,  132,   43,   45,
   45,   10,   86,   61,  123,   10,   43,   43,   45,   45,
   43,  123,   45,  230,   10,  123,  125,  382,  241,  125,
  401,  260,  125,  111,  223,   10,  125,  231,    3,  119,
  118,  166,  260,  265,  309,   44,   10,   10,   10,   44,
   60,   61,   62,   55,   10,  311,  181,  280,  125,  172,
  275,  257,  305,  306,  257,  335,   61,  257,   10,  257,
  275,  149,  150,  335,  394,  335,   10,   10,   10,  331,
   10,   44,   44,   10,   10,   50,  100,  105,  295,  279,
   10,  279,  282,  283,  282,  283,   10,  275,  100,  375,
   10,  226,   44,   10,   10,  375,   10,  220,  284,  262,
  299,   44,  237,  375,   61,  375,  321,  322,  266,  305,
  306,  373,  374,  299,  375,  273,  125,  376,  123,  344,
  125,  376,  375,  323,   44,  323,  375,   44,  375,  376,
  396,  337,  338,  339,  337,  338,  339,  376,  257,  375,
  125,  376,  375,  375,  375,  526,   61,  159,  376,  123,
  375,  286,  125,  125,   61,  290,  521,  374,  357,  125,
  279,  296,   61,  282,  283,  300,  123,  251,  364,  304,
  305,  123,  376,  125,  449,  375,  506,  375,  268,  402,
  257,  125,  125,  125,   61,  125,   10,  375,  125,  125,
  392,  393,  375,  324,  325,  125,  375,  232,  123,  257,
  375,   10,  279,  375,  323,  282,  283,  367,  123,  125,
  345,  125,  276,  277,  249,  250,  244,  291,  125,  293,
  294,  295,  310,  375,  355,  442,  357,  347,  348,  349,
  350,  259,  375,  376,  369,  321,  322,  265,   61,  267,
  252,  299,  320,  378,   10,   10,  323,  375,  260,  375,
  376,  453,  257,  455,   10,  375,  375,  232,   10,  476,
  266,  267,  268,  375,  376,  355,  375,  375,  376,  375,
  376,  256,  375,  376,  249,  250,  375,  376,  263,  337,
  338,  339,  375,  376,  269,   10,  271,  272,  361,  362,
   10,  365,  366,   10,  299,  512,  281,   10,  375,   10,
  328,  329,  330,  331,   10,  257,  334,  335,  305,  306,
   10,  369,  314,  315,  123,  375,  376,  375,  376,  332,
   10,  326,  327,  328,  280,  330,  372,  332,  337,  334,
  335,  376,  337,  338,  339,  340,  341,  342,   10,  376,
  376,  346,  299,  376,  428,  429,  342,  322,  375,  369,
  370,  371,  365,  366,  376,  490,  376,  123,  382,  376,
  365,  366,  375,  376,  369,  262,  375,  376,  278,  504,
  375,  376,  375,   10,  326,  327,  328,  405,  330,  391,
  332,  375,  334,  335,  299,  337,  338,  339,  340,  341,
  342,   47,  299,   47,  346,  321,  322,  375,  376,  375,
  299,  342,  308,   10,  375,  376,  375,  376,  375,  376,
  368,  123,  369,  365,  366,  123,  123,  275,  375,  376,
   10,  336,  299,  375,  376,  375,  375,  123,  452,  376,
  376,  376,  256,  257,  258,  259,  375,  261,  376,  263,
  264,  265,  375,  375,  268,  125,  375,  276,  257,  376,
  274,  329,  375,  125,  369,  279,  375,  281,  376,  125,
  375,  376,  369,  376,  375,  125,  375,  125,  375,  376,
  369,  123,  296,  123,  498,  263,  375,  376,  376,  375,
  304,  376,  376,  307,  376,  309,  310,  311,  125,  376,
  376,  257,  369,  317,  318,  319,  376,  521,  375,  376,
  376,  337,  375,  375,   10,  375,  375,  531,  332,  333,
  334,  376,  336,  376,  262,  375,  375,  326,  327,  328,
  375,  330,  346,  332,   61,  334,  335,  123,  337,  338,
  339,  340,  341,  342,  313,  359,   10,  346,   10,  376,
  375,  375,   10,  125,  125,  376,  291,  375,  125,  125,
  376,  375,  337,  125,  125,  125,  365,  366,   61,  375,
  326,  327,  328,  375,  330,  375,  332,  375,  334,  335,
  376,  337,  338,  339,  340,  341,  342,  376,   10,  375,
  346,  375,  375,   10,  256,  376,  363,  259,  125,  376,
  125,  375,  375,  375,   10,   10,  376,  375,  270,  365,
  366,  375,  125,  275,  125,  125,  375,  375,  375,  280,
   10,  375,  284,  285,  286,  287,  288,  289,  290,  256,
  292,  123,  259,   10,  375,  297,  298,   10,  300,  301,
  302,  303,  304,  270,   10,   10,   10,  309,  275,  311,
  312,   61,  375,   10,  316,   10,  125,  284,  285,  286,
  287,  288,  289,  290,  125,  292,  256,  349,  167,  396,
  297,  298,  508,  300,  301,  302,  303,  304,  430,  259,
  342,  533,  309,  498,  311,  312,  474,  531,  190,  316,
  270,  228,  314,    1,   -1,  275,   -1,   -1,  360,   -1,
   -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289,
  290,   -1,  292,   -1,  300,  342,   -1,  297,  298,   -1,
  300,  301,  302,  303,  304,   -1,   -1,   -1,   -1,  309,
  257,  311,  312,  360,   -1,   -1,  316,   -1,   -1,   -1,
  326,  327,  328,   -1,   -1,   -1,   -1,   -1,   -1,  125,
   -1,   -1,  279,   -1,   -1,  282,  283,  343,  344,  345,
  346,   -1,  342,   -1,  257,  351,  352,  353,  354,  355,
  356,   -1,  299,  300,   -1,   -1,   -1,   -1,   -1,   -1,
  360,   -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,  282,
  283,   -1,   -1,   -1,   -1,   -1,  323,   -1,  123,  326,
  327,  328,   -1,   -1,  286,   -1,  299,  300,  290,   -1,
  337,  338,  339,   -1,   -1,   -1,  343,  344,  345,  346,
   -1,   -1,  304,  305,  351,  352,  353,  354,  355,  356,
  323,  125,   -1,  326,  327,  328,   -1,   -1,   -1,   -1,
   -1,   -1,  369,  123,  337,  338,  339,  257,  375,  376,
  343,  344,  345,  346,   -1,   -1,   -1,   -1,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,  125,   -1,  279,
   -1,   -1,  282,  283,   -1,   -1,  369,   -1,   -1,   -1,
   -1,  257,  375,  376,   -1,   -1,   -1,   -1,   -1,  299,
  300,   -1,   -1,   -1,   -1,   -1,  378,   -1,   -1,   -1,
   -1,   -1,   -1,  279,   -1,   -1,  282,  283,   -1,   -1,
   -1,   -1,   -1,  323,   -1,   -1,  326,  327,  328,   -1,
   -1,   -1,   -1,   -1,  300,   -1,   -1,  337,  338,  339,
   -1,   -1,  257,  343,  344,  345,  346,   -1,   -1,   -1,
   -1,  351,  352,  353,  354,  355,  356,  323,   -1,   -1,
  326,  327,  328,   -1,   -1,   -1,   -1,   -1,   -1,  369,
   -1,   -1,   -1,  257,   -1,  375,  376,  343,  344,  345,
  346,   -1,   -1,   -1,   -1,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,  466,  279,   -1,   -1,  282,  283,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,
  376,  326,  327,  328,   -1,  330,  300,  332,  490,  334,
  335,   -1,  337,  338,  339,  340,  341,   -1,  500,   -1,
  300,  346,   -1,   -1,   -1,   -1,   -1,   -1,  510,  323,
   -1,   -1,  326,  327,  328,   -1,   -1,   -1,  520,   -1,
  365,  366,  300,  525,   -1,   -1,  326,  327,  328,  343,
  344,  345,  346,   -1,   -1,   -1,   -1,  351,  352,  353,
  354,  355,  356,  343,  344,  345,  346,   -1,  326,  327,
  328,  351,  352,  353,  354,  355,  356,  300,   -1,   -1,
   -1,  375,  376,   -1,   -1,  343,  344,  345,  346,   -1,
   -1,  300,   -1,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  326,  327,  328,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327,  328,
  343,  344,  345,  346,   -1,   -1,   -1,   -1,  351,  352,
  353,  354,  355,  356,  343,  344,  345,  346,   -1,   -1,
   -1,   -1,  351,  352,  353,  354,  355,  356,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 376
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,"'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,"'<'",
"'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,"AS","ROUTERID","HOLDTIME","YMIN","LISTEN","ON","FIBUPDATE",
"FIBPRIORITY","RTABLE","NONE","UNICAST","VPN","RD","EXPORT","EXPORTTRGT",
"IMPORTTRGT","DEFAULTROUTE","RDE","RIB","EVALUATE","IGNORE","COMPARE","GROUP",
"NEIGHBOR","NETWORK","EBGP","IBGP","LOCALAS","REMOTEAS","DESCR","LOCALADDR",
"MULTIHOP","PASSIVE","MAXPREFIX","RESTART","ANNOUNCE","CAPABILITIES","REFRESH",
"AS4BYTE","CONNECTRETRY","DEMOTE","ENFORCE","NEIGHBORAS","ASOVERRIDE",
"REFLECTOR","DEPEND","DOWN","DUMP","IN","OUT","SOCKET","RESTRICTED","LOG",
"ROUTECOLL","TRANSPARENT","TCP","MD5SIG","PASSWORD","KEY","TTLSECURITY","ALLOW",
"DENY","MATCH","QUICK","FROM","TO","ANY","CONNECTED","STATIC","COMMUNITY",
"EXTCOMMUNITY","LARGECOMMUNITY","DELETE","PREFIX","PREFIXLEN","PREFIXSET",
"ROASET","ORIGINSET","OVS","ASSET","SOURCEAS","TRANSITAS","PEERAS","MAXASLEN",
"MAXASSEQ","SET","LOCALPREF","MED","METRIC","NEXTHOP","REJECT","BLACKHOLE",
"NOMODIFY","SELF","PREPEND_SELF","PREPEND_PEER","PFTABLE","WEIGHT","RTLABEL",
"ORIGIN","PRIORITY","ERROR","INCLUDE","IPSEC","ESP","AH","SPI","IKE","IPV4",
"IPV6","QUALIFY","VIA","NE","LE","GE","XRANGE","LONGER","MAXLEN","STRING",
"NUMBER",
};
const char * const yyrule[] =
	{"$accept : grammar",
"grammar :",
"grammar : grammar '\\n'",
"grammar : grammar varset '\\n'",
"grammar : grammar include '\\n'",
"grammar : grammar as_set '\\n'",
"grammar : grammar prefixset '\\n'",
"grammar : grammar roa_set '\\n'",
"grammar : grammar origin_set '\\n'",
"grammar : grammar conf_main '\\n'",
"grammar : grammar l3vpn '\\n'",
"grammar : grammar neighbor '\\n'",
"grammar : grammar group '\\n'",
"grammar : grammar filterrule '\\n'",
"grammar : grammar error '\\n'",
"asnumber : NUMBER",
"as4number : STRING",
"as4number : asnumber",
"as4number_any : STRING",
"as4number_any : asnumber",
"string : string STRING",
"string : STRING",
"yesno : STRING",
"varset : STRING '=' string",
"include : INCLUDE STRING",
"$$1 :",
"as_set : ASSET STRING '{' optnl $$1 as_set_l optnl '}'",
"as_set : ASSET STRING '{' optnl '}'",
"as_set_l : as4number_any",
"as_set_l : as_set_l comma as4number_any",
"$$2 :",
"prefixset : PREFIXSET STRING '{' optnl $$2 prefixset_l optnl '}'",
"prefixset : PREFIXSET STRING '{' optnl '}'",
"prefixset_l : prefixset_item",
"prefixset_l : prefixset_l comma prefixset_item",
"prefixset_item : prefix prefixlenop",
"$$3 :",
"roa_set : ROASET '{' optnl $$3 roa_set_l optnl '}'",
"roa_set : ROASET '{' optnl '}'",
"$$4 :",
"origin_set : ORIGINSET STRING '{' optnl $$4 roa_set_l optnl '}'",
"origin_set : ORIGINSET STRING '{' optnl '}'",
"roa_set_l : prefixset_item SOURCEAS as4number_any",
"roa_set_l : roa_set_l comma prefixset_item SOURCEAS as4number_any",
"conf_main : AS as4number",
"conf_main : AS as4number asnumber",
"conf_main : ROUTERID address",
"conf_main : HOLDTIME NUMBER",
"conf_main : HOLDTIME YMIN NUMBER",
"conf_main : LISTEN ON address",
"conf_main : FIBPRIORITY NUMBER",
"conf_main : FIBUPDATE yesno",
"conf_main : ROUTECOLL yesno",
"conf_main : RDE RIB STRING",
"conf_main : RDE RIB STRING yesno EVALUATE",
"conf_main : RDE RIB STRING RTABLE NUMBER",
"conf_main : RDE RIB STRING RTABLE NUMBER FIBUPDATE yesno",
"conf_main : TRANSPARENT yesno",
"conf_main : LOG STRING",
"conf_main : network",
"conf_main : DUMP STRING STRING optnumber",
"conf_main : DUMP RIB STRING STRING STRING optnumber",
"conf_main : mrtdump",
"conf_main : RDE STRING EVALUATE",
"conf_main : RDE STRING IGNORE",
"conf_main : RDE MED COMPARE STRING",
"conf_main : NEXTHOP QUALIFY VIA STRING",
"conf_main : RTABLE NUMBER",
"conf_main : CONNECTRETRY NUMBER",
"conf_main : SOCKET STRING restricted",
"mrtdump : DUMP STRING inout STRING optnumber",
"network : NETWORK prefix filter_set",
"network : NETWORK PREFIXSET STRING filter_set",
"network : NETWORK family RTLABEL STRING filter_set",
"network : NETWORK family PRIORITY NUMBER filter_set",
"network : NETWORK family nettype filter_set",
"inout : IN",
"inout : OUT",
"restricted : RESTRICTED",
"restricted :",
"address : STRING",
"prefix : STRING '/' NUMBER",
"prefix : NUMBER '/' NUMBER",
"addrspec : address",
"addrspec : prefix",
"optnumber :",
"optnumber : NUMBER",
"$$5 :",
"l3vpn : VPN STRING ON STRING $$5 '{' l3vpnopts_l '}'",
"l3vpnopts_l :",
"l3vpnopts_l : l3vpnopts_l '\\n'",
"l3vpnopts_l : l3vpnopts_l l3vpnopts '\\n'",
"l3vpnopts_l : l3vpnopts_l error '\\n'",
"l3vpnopts : RD STRING",
"l3vpnopts : EXPORTTRGT STRING STRING",
"l3vpnopts : IMPORTTRGT STRING STRING",
"l3vpnopts : FIBUPDATE yesno",
"l3vpnopts : network",
"$$6 :",
"$$7 :",
"neighbor : $$6 NEIGHBOR addrspec $$7 peeropts_h",
"$$8 :",
"group : GROUP string $$8 '{' groupopts_l '}'",
"groupopts_l :",
"groupopts_l : groupopts_l '\\n'",
"groupopts_l : groupopts_l peeropts '\\n'",
"groupopts_l : groupopts_l neighbor '\\n'",
"groupopts_l : groupopts_l error '\\n'",
"peeropts_h : '{' '\\n' peeropts_l '}'",
"peeropts_h : '{' peeropts '}'",
"peeropts_h :",
"peeropts_l :",
"peeropts_l : peeropts_l '\\n'",
"peeropts_l : peeropts_l peeropts '\\n'",
"peeropts_l : peeropts_l error '\\n'",
"peeropts : REMOTEAS as4number",
"peeropts : LOCALAS as4number",
"peeropts : LOCALAS as4number asnumber",
"peeropts : DESCR string",
"peeropts : LOCALADDR address",
"peeropts : MULTIHOP NUMBER",
"peeropts : PASSIVE",
"peeropts : DOWN",
"peeropts : DOWN STRING",
"peeropts : RIB STRING",
"peeropts : HOLDTIME NUMBER",
"peeropts : HOLDTIME YMIN NUMBER",
"peeropts : ANNOUNCE family safi",
"peeropts : ANNOUNCE CAPABILITIES yesno",
"peeropts : ANNOUNCE REFRESH yesno",
"peeropts : ANNOUNCE RESTART yesno",
"peeropts : ANNOUNCE AS4BYTE yesno",
"peeropts : EXPORT NONE",
"peeropts : EXPORT DEFAULTROUTE",
"peeropts : ENFORCE NEIGHBORAS yesno",
"peeropts : ENFORCE LOCALAS yesno",
"peeropts : ASOVERRIDE yesno",
"peeropts : MAXPREFIX NUMBER restart",
"peeropts : TCP MD5SIG PASSWORD string",
"peeropts : TCP MD5SIG KEY string",
"peeropts : IPSEC espah IKE",
"peeropts : IPSEC espah inout SPI NUMBER STRING STRING encspec",
"peeropts : TTLSECURITY yesno",
"peeropts : SET filter_set_opt",
"peeropts : SET '{' optnl filter_set_l optnl '}'",
"peeropts : mrtdump",
"peeropts : REFLECTOR",
"peeropts : REFLECTOR address",
"peeropts : DEPEND ON STRING",
"peeropts : DEMOTE STRING",
"peeropts : TRANSPARENT yesno",
"peeropts : LOG STRING",
"restart :",
"restart : RESTART NUMBER",
"family : IPV4",
"family : IPV6",
"safi : NONE",
"safi : UNICAST",
"safi : VPN",
"nettype : STATIC",
"nettype : CONNECTED",
"espah : ESP",
"espah : AH",
"encspec :",
"encspec : STRING STRING",
"filterrule : action quick filter_rib_h direction filter_peer_h filter_match_h filter_set",
"action : ALLOW",
"action : DENY",
"action : MATCH",
"quick :",
"quick : QUICK",
"direction : FROM",
"direction : TO",
"filter_rib_h :",
"filter_rib_h : RIB filter_rib",
"filter_rib_h : RIB '{' optnl filter_rib_l optnl '}'",
"filter_rib_l : filter_rib",
"filter_rib_l : filter_rib_l comma filter_rib",
"filter_rib : STRING",
"filter_peer_h : filter_peer",
"filter_peer_h : '{' optnl filter_peer_l optnl '}'",
"filter_peer_l : filter_peer",
"filter_peer_l : filter_peer_l comma filter_peer",
"filter_peer : ANY",
"filter_peer : address",
"filter_peer : AS as4number",
"filter_peer : GROUP STRING",
"filter_peer : EBGP",
"filter_peer : IBGP",
"filter_prefix_h : IPV4 prefixlenop",
"filter_prefix_h : IPV6 prefixlenop",
"filter_prefix_h : PREFIX filter_prefix",
"filter_prefix_h : PREFIX '{' filter_prefix_m '}'",
"filter_prefix_m : filter_prefix_l",
"filter_prefix_m : '{' filter_prefix_l '}'",
"filter_prefix_m : '{' filter_prefix_l '}' filter_prefix_m",
"filter_prefix_l : filter_prefix",
"filter_prefix_l : filter_prefix_l comma filter_prefix",
"filter_prefix : prefix prefixlenop",
"filter_as_h : filter_as_t",
"filter_as_h : '{' filter_as_t_l '}'",
"filter_as_t_l : filter_as_t",
"filter_as_t_l : filter_as_t_l comma filter_as_t",
"filter_as_t : filter_as_type filter_as",
"filter_as_t : filter_as_type '{' filter_as_l_h '}'",
"filter_as_t : filter_as_type ASSET STRING",
"filter_as_l_h : filter_as_l",
"filter_as_l_h : '{' filter_as_l '}'",
"filter_as_l_h : '{' filter_as_l '}' filter_as_l_h",
"filter_as_l : filter_as",
"filter_as_l : filter_as_l comma filter_as",
"filter_as : as4number_any",
"filter_as : NEIGHBORAS",
"filter_as : equalityop as4number_any",
"filter_as : as4number_any binaryop as4number_any",
"filter_match_h :",
"$$9 :",
"filter_match_h : $$9 filter_match",
"filter_match : filter_elm",
"filter_match : filter_match filter_elm",
"filter_elm : filter_prefix_h",
"filter_elm : filter_as_h",
"filter_elm : MAXASLEN NUMBER",
"filter_elm : MAXASSEQ NUMBER",
"filter_elm : community STRING",
"filter_elm : EXTCOMMUNITY STRING STRING",
"filter_elm : EXTCOMMUNITY OVS STRING",
"filter_elm : NEXTHOP address",
"filter_elm : NEXTHOP NEIGHBOR",
"filter_elm : PREFIXSET STRING prefixlenop",
"filter_elm : ORIGINSET STRING",
"filter_elm : OVS validity",
"prefixlenop :",
"prefixlenop : LONGER",
"prefixlenop : MAXLEN NUMBER",
"prefixlenop : PREFIXLEN unaryop NUMBER",
"prefixlenop : PREFIXLEN NUMBER binaryop NUMBER",
"filter_as_type : AS",
"filter_as_type : SOURCEAS",
"filter_as_type : TRANSITAS",
"filter_as_type : PEERAS",
"filter_set :",
"filter_set : SET filter_set_opt",
"filter_set : SET '{' optnl filter_set_l optnl '}'",
"filter_set_l : filter_set_l comma filter_set_opt",
"filter_set_l : filter_set_opt",
"community : COMMUNITY",
"community : LARGECOMMUNITY",
"delete :",
"delete : DELETE",
"filter_set_opt : LOCALPREF NUMBER",
"filter_set_opt : LOCALPREF '+' NUMBER",
"filter_set_opt : LOCALPREF '-' NUMBER",
"filter_set_opt : MED NUMBER",
"filter_set_opt : MED '+' NUMBER",
"filter_set_opt : MED '-' NUMBER",
"filter_set_opt : METRIC NUMBER",
"filter_set_opt : METRIC '+' NUMBER",
"filter_set_opt : METRIC '-' NUMBER",
"filter_set_opt : WEIGHT NUMBER",
"filter_set_opt : WEIGHT '+' NUMBER",
"filter_set_opt : WEIGHT '-' NUMBER",
"filter_set_opt : NEXTHOP address",
"filter_set_opt : NEXTHOP BLACKHOLE",
"filter_set_opt : NEXTHOP REJECT",
"filter_set_opt : NEXTHOP NOMODIFY",
"filter_set_opt : NEXTHOP SELF",
"filter_set_opt : PREPEND_SELF NUMBER",
"filter_set_opt : PREPEND_PEER NUMBER",
"filter_set_opt : ASOVERRIDE",
"filter_set_opt : PFTABLE STRING",
"filter_set_opt : RTLABEL STRING",
"filter_set_opt : community delete STRING",
"filter_set_opt : EXTCOMMUNITY delete STRING STRING",
"filter_set_opt : EXTCOMMUNITY delete OVS STRING",
"filter_set_opt : ORIGIN origincode",
"origincode : STRING",
"validity : STRING",
"optnl :",
"optnl : '\\n' optnl",
"comma :",
"comma : ','",
"comma : '\\n' optnl",
"comma : ',' '\\n' optnl",
"unaryop : '='",
"unaryop : NE",
"unaryop : LE",
"unaryop : '<'",
"unaryop : GE",
"unaryop : '>'",
"equalityop : '='",
"equalityop : NE",
"binaryop : '-'",
"binaryop : XRANGE",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 2742 "parse.y"

struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "AS",			AS},
		{ "IPv4",		IPV4},
		{ "IPv6",		IPV6},
		{ "ah",			AH},
		{ "allow",		ALLOW},
		{ "announce",		ANNOUNCE},
		{ "any",		ANY},
		{ "as-4byte",		AS4BYTE },
		{ "as-override",	ASOVERRIDE},
		{ "as-set",		ASSET },
		{ "blackhole",		BLACKHOLE},
		{ "capabilities",	CAPABILITIES},
		{ "community",		COMMUNITY},
		{ "compare",		COMPARE},
		{ "connect-retry",	CONNECTRETRY},
		{ "connected",		CONNECTED},
		{ "default-route",	DEFAULTROUTE},
		{ "delete",		DELETE},
		{ "demote",		DEMOTE},
		{ "deny",		DENY},
		{ "depend",		DEPEND},
		{ "descr",		DESCR},
		{ "down",		DOWN},
		{ "dump",		DUMP},
		{ "ebgp",		EBGP},
		{ "enforce",		ENFORCE},
		{ "esp",		ESP},
		{ "evaluate",		EVALUATE},
		{ "export",		EXPORT},
		{ "export-target",	EXPORTTRGT},
		{ "ext-community",	EXTCOMMUNITY},
		{ "fib-priority",	FIBPRIORITY},
		{ "fib-update",		FIBUPDATE},
		{ "from",		FROM},
		{ "group",		GROUP},
		{ "holdtime",		HOLDTIME},
		{ "ibgp",		IBGP},
		{ "ignore",		IGNORE},
		{ "ike",		IKE},
		{ "import-target",	IMPORTTRGT},
		{ "in",			IN},
		{ "include",		INCLUDE},
		{ "inet",		IPV4},
		{ "inet6",		IPV6},
		{ "ipsec",		IPSEC},
		{ "key",		KEY},
		{ "large-community",	LARGECOMMUNITY},
		{ "listen",		LISTEN},
		{ "local-address",	LOCALADDR},
		{ "local-as",		LOCALAS},
		{ "localpref",		LOCALPREF},
		{ "log",		LOG},
		{ "match",		MATCH},
		{ "max-as-len",		MAXASLEN},
		{ "max-as-seq",		MAXASSEQ},
		{ "max-prefix",		MAXPREFIX},
		{ "maxlen",		MAXLEN},
		{ "md5sig",		MD5SIG},
		{ "med",		MED},
		{ "metric",		METRIC},
		{ "min",		YMIN},
		{ "multihop",		MULTIHOP},
		{ "neighbor",		NEIGHBOR},
		{ "neighbor-as",	NEIGHBORAS},
		{ "network",		NETWORK},
		{ "nexthop",		NEXTHOP},
		{ "no-modify",		NOMODIFY},
		{ "none",		NONE},
		{ "on",			ON},
		{ "or-longer",		LONGER},
		{ "origin",		ORIGIN},
		{ "origin-set",		ORIGINSET},
		{ "out",		OUT},
		{ "ovs",		OVS},
		{ "passive",		PASSIVE},
		{ "password",		PASSWORD},
		{ "peer-as",		PEERAS},
		{ "pftable",		PFTABLE},
		{ "prefix",		PREFIX},
		{ "prefix-set",		PREFIXSET},
		{ "prefixlen",		PREFIXLEN},
		{ "prepend-neighbor",	PREPEND_PEER},
		{ "prepend-self",	PREPEND_SELF},
		{ "priority",		PRIORITY},
		{ "qualify",		QUALIFY},
		{ "quick",		QUICK},
		{ "rd",			RD},
		{ "rde",		RDE},
		{ "refresh",		REFRESH },
		{ "reject",		REJECT},
		{ "remote-as",		REMOTEAS},
		{ "restart",		RESTART},
		{ "restricted",		RESTRICTED},
		{ "rib",		RIB},
		{ "roa-set",		ROASET },
		{ "route-collector",	ROUTECOLL},
		{ "route-reflector",	REFLECTOR},
		{ "router-id",		ROUTERID},
		{ "rtable",		RTABLE},
		{ "rtlabel",		RTLABEL},
		{ "self",		SELF},
		{ "set",		SET},
		{ "socket",		SOCKET },
		{ "source-as",		SOURCEAS},
		{ "spi",		SPI},
		{ "static",		STATIC},
		{ "tcp",		TCP},
		{ "to",			TO},
		{ "transit-as",		TRANSITAS},
		{ "transparent-as",	TRANSPARENT},
		{ "ttl-security",	TTLSECURITY},
		{ "unicast",		UNICAST},
		{ "via",		VIA},
		{ "vpn",		VPN},
		{ "weight",		WEIGHT}
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return (EOF);
			return (quotec);
		}
		return (c);
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return ('\n');
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return (EOF);
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	u_char	 buf[8096];
	u_char	*p, *val;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return (findeol());
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc(*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error: unterminated quote");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return (STRING);
	case '!':
		next = lgetc(0);
		if (next == '=')
			return (NE);
		lungetc(next);
		break;
	case '<':
		next = lgetc(0);
		if (next == '=')
			return (LE);
		lungetc(next);
		break;
	case '>':
		next = lgetc(0);
		if (next == '<')
			return (XRANGE);
		else if (next == '=')
			return (GE);
		lungetc(next);
		break;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && x != '<' && x != '>' && \
	x != '!' && x != '=' && x != '/' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_' || c == '*') {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			if ((yylval.v.string = strdup(buf)) == NULL)
				fatal("yylex: strdup");
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat	st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	if ((nfile = calloc(1, sizeof(struct file))) == NULL) {
		log_warn("%s", __func__);
		return (NULL);
	}
	if ((nfile->name = strdup(name)) == NULL) {
		log_warn("%s", __func__);
		free(nfile);
		return (NULL);
	}
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("%s: %s", __func__, nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = malloc(nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("%s", __func__);
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return (file ? 0 : EOF);
}

static void
init_config(struct bgpd_config *c)
{
	u_int rdomid;

	c->min_holdtime = MIN_HOLDTIME;
	c->holdtime = INTERVAL_HOLD;
	c->connectretry = INTERVAL_CONNECTRETRY;
	c->bgpid = get_bgpid();
	c->fib_priority = RTP_BGP;
	c->default_tableid = getrtable();
	ktable_exists(c->default_tableid, &rdomid);
	if (rdomid != c->default_tableid)
		fatalx("current routing table %u is not a routing domain",
		    c->default_tableid);

	if (asprintf(&c->csock, "%s.%d", SOCKET_NAME, c->default_tableid) == -1)
		fatal(NULL);
}

struct bgpd_config *
parse_config(char *filename, struct peer_head *ph)
{
	struct sym		*sym, *next;
	struct rde_rib		*rr;
	struct network	       	*n;
	int			 errors = 0;

	conf = new_config();
	init_config(conf);

	if ((filter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((peerfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((groupfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	TAILQ_INIT(filter_l);
	TAILQ_INIT(peerfilter_l);
	TAILQ_INIT(groupfilter_l);

	curpeer = NULL;
	curgroup = NULL;

	cur_peers = ph;
	new_peers = &conf->peers;
	netconf = &conf->networks;

	add_rib("Adj-RIB-In", conf->default_tableid,
	    F_RIB_NOFIB | F_RIB_NOEVALUATE);
	add_rib("Adj-RIB-Out", conf->default_tableid,
	    F_RIB_NOFIB | F_RIB_NOEVALUATE);
	add_rib("Loc-RIB", conf->default_tableid, F_RIB_LOCAL);

	if ((file = pushfile(filename, 1)) == NULL)
		goto errors;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* check that we dont try to announce our own routes */
	TAILQ_FOREACH(n, netconf, entry)
	    if (n->net.priority == conf->fib_priority) {
		    errors++;
		    logit(LOG_CRIT, "network priority %d == fib-priority "
			"%d is not allowed.",
			n->net.priority, conf->fib_priority);
	    }
	
	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((cmd_opts & BGPD_OPT_VERBOSE2) && !sym->used)
			fprintf(stderr, "warning: macro \"%s\" not "
			    "used\n", sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (!conf->as) {
		log_warnx("configuration error: AS not given");
		errors++;
	}

	/* clear the globals */
	curpeer = NULL;
	curgroup = NULL;
	cur_peers = NULL;
	new_peers = NULL;
	netconf = NULL;

	if (errors) {
errors:
		while ((rr = SIMPLEQ_FIRST(&ribnames)) != NULL) {
			SIMPLEQ_REMOVE_HEAD(&ribnames, entry);
			free(rr);
		}

		filterlist_free(filter_l);
		filterlist_free(peerfilter_l);
		filterlist_free(groupfilter_l);

		free_config(conf);
		return (NULL);
	} else {
		/*
		 * Concatenate filter list and static group and peer filtersets
		 * together. Static group sets come first then peer sets
		 * last normal filter rules.
		 */
		TAILQ_CONCAT(conf->filters, groupfilter_l, entry);
		TAILQ_CONCAT(conf->filters, peerfilter_l, entry);
		TAILQ_CONCAT(conf->filters, filter_l, entry);

		optimize_filters(conf->filters);

		free(filter_l);
		free(peerfilter_l);
		free(groupfilter_l);

		return (conf);
	}
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	if ((sym = calloc(1, sizeof(*sym))) == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;

	if ((val = strrchr(s, '=')) == NULL)
		return (-1);
	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);
	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

static int
getcommunity(char *s, int large, u_int32_t *val, u_int8_t *flag)
{
	long long	 max = USHRT_MAX;
	const char	*errstr;

	*flag = 0;
	*val = 0;
	if (strcmp(s, "*") == 0) {
		*flag = COMMUNITY_ANY;
		return 0;
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		return 0;
	} else if (strcmp(s, "local-as") == 0) {
		*flag =  COMMUNITY_LOCAL_AS;
		return 0;
	}
	if (large)
		max = UINT_MAX;
	*val = strtonum(s, 0, max, &errstr);
	if (errstr) {
		yyerror("Community %s is %s (max: %lld)", s, errstr, max);
		return -1;
	}
	return 0;
}

static void
setcommunity(struct filter_community *c, u_int32_t as, u_int32_t data,
    u_int8_t asflag, u_int8_t dataflag)
{
	memset(c, 0, sizeof(*c));
	c->type = COMMUNITY_TYPE_BASIC;
	c->dflag1 = asflag;
	c->dflag2 = dataflag;
	c->c.b.data1 = as;
	c->c.b.data2 = data;
}

static int
parselargecommunity(struct filter_community *c, char *s)
{
	char *p, *q;

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if ((q = strchr(p, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*q++ = 0;

	if (getcommunity(s, 1, &c->c.l.data1, &c->dflag1) == -1 ||
	    getcommunity(p, 1, &c->c.l.data2, &c->dflag2) == -1 ||
	    getcommunity(q, 1, &c->c.l.data3, &c->dflag3) == -1)
		return (-1);
	c->type = COMMUNITY_TYPE_LARGE;
	return (0);
}

int
parsecommunity(struct filter_community *c, int type, char *s)
{
	char *p;
	u_int32_t as, data;
	u_int8_t asflag, dataflag;

	if (type == COMMUNITY_TYPE_LARGE)
		return parselargecommunity(c, s);

	/* Well-known communities */
	if (strcasecmp(s, "GRACEFUL_SHUTDOWN") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_GRACEFUL_SHUTDOWN, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPORT, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_ADVERTISE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_ADVERTISE, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT_SUBCONFED") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPSUBCONFED, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_PEER") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_PEER, 0, 0);
		return (0);
	} else if (strcasecmp(s, "BLACKHOLE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_BLACKHOLE, 0, 0);
		return (0);
	}

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if (getcommunity(s, 0, &as, &asflag) == -1 ||
	    getcommunity(p, 0, &data, &dataflag) == -1)
		return (-1);
	setcommunity(c, as, data, asflag, dataflag);
	return (0);
}

static int
parsesubtype(char *name, int *type, int *subtype)
{
	const struct ext_comm_pairs *cp;
	int found = 0;

	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (strcmp(name, cp->subname) == 0) {
			if (found == 0) {
				*type = cp->type;
				*subtype = cp->subtype;
			}
			found++;
		}
	}
	if (found > 1)
		*type = -1;
	return (found);
}

static int
parseextvalue(int type, char *s, u_int32_t *v, u_int8_t *flag)
{
	const char 	*errstr;
	char		*p;
	struct in_addr	 ip;
	u_int32_t	 uvalh, uval;

	if (type != -1) {
		/* nothing */
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if ((p = strchr(s, '.')) == NULL) {
		/* AS_PLAIN number (4 or 2 byte) */
		strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr == NULL)
			type = EXT_COMMUNITY_TRANS_TWO_AS;
		else
			type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strchr(p + 1, '.') == NULL) {
		/* AS_DOT number (4-byte) */
		type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else {
		/* more than one dot -> IP address */
		type = EXT_COMMUNITY_TRANS_IPV4;
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
		uval = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		*v = uval;
		break;
	case EXT_COMMUNITY_TRANS_FOUR_AS:
		if ((p = strchr(s, '.')) == NULL) {
			uval = strtonum(s, 0, UINT_MAX, &errstr);
			if (errstr) {
				yyerror("Bad ext-community %s is %s", s,
				    errstr);
				return (-1);
			}
			*v = uval;
			break;
		}
		*p++ = '\0';
		uvalh = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		uval = strtonum(p, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", p, errstr);
			return (-1);
		}
		*v = uval | (uvalh << 16);
		break;
	case EXT_COMMUNITY_TRANS_IPV4:
		if (inet_aton(s, &ip) == 0) {
			yyerror("Bad ext-community %s not parseable", s);
			return (-1);
		}
		*v = ntohl(ip.s_addr);
		break;
	default:
		fatalx("%s: unexpected type %d", __func__, type);
	}
	return (type);
}

int
parseextcommunity(struct filter_community *c, char *t, char *s)
{
	const struct ext_comm_pairs *cp;
	u_int64_t	 ullval;
	u_int32_t	 uval, uval2;
	char		*p, *ep;
	int		 type = 0, subtype = 0;

	if (strcmp(t, "*") == 0 && strcmp(s, "*") == 0) {
		c->type = COMMUNITY_TYPE_EXT;
		c->dflag3 = COMMUNITY_ANY;
		return (0);
	}
	if (parsesubtype(t, &type, &subtype) == 0) {
		yyerror("Bad ext-community unknown type");
		return (-1);
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
	case EXT_COMMUNITY_TRANS_FOUR_AS:
	case EXT_COMMUNITY_TRANS_IPV4:
	case -1:
		if (strcmp(s, "*") == 0) {
			c->dflag1 = COMMUNITY_ANY;
			break;
		}
		if ((p = strchr(s, ':')) == NULL) {
			yyerror("Bad ext-community %s", s);
			return (-1);
		}
		*p++ = '\0';
		if ((type = parseextvalue(type, s, &uval, &c->dflag1)) == -1)
			return (-1);
		switch (type) {
		case EXT_COMMUNITY_TRANS_TWO_AS:
			if (getcommunity(p, 1, &uval2, &c->dflag2) == -1)
				return (-1);
			break;
		case EXT_COMMUNITY_TRANS_IPV4:
		case EXT_COMMUNITY_TRANS_FOUR_AS:
			if (getcommunity(p, 0, &uval2, &c->dflag2) == -1)
				return (-1);
			break;
		default:
			fatalx("parseextcommunity: unexpected result");
		}
		c->c.e.data1 = uval;
		c->c.e.data2 = uval2;
		break;
	case EXT_COMMUNITY_TRANS_OPAQUE:
	case EXT_COMMUNITY_TRANS_EVPN:
		if (strcmp(s, "*") == 0) {
			c->dflag1 = COMMUNITY_ANY;
			break;
		}
		errno = 0;
		ullval = strtoull(s, &ep, 0);
		if (s[0] == '\0' || *ep != '\0') {
			yyerror("Bad ext-community bad value");
			return (-1);
		}
		if (errno == ERANGE && ullval > EXT_COMMUNITY_OPAQUE_MAX) {
			yyerror("Bad ext-community value too big");
			return (-1);
		}
		c->c.e.data2 = ullval;
		break;
	case EXT_COMMUNITY_NON_TRANS_OPAQUE:
		if (subtype == EXT_COMMUNITY_SUBTYPE_OVS) {
			if (strcmp(s, "valid") == 0) {
				c->c.e.data2 = EXT_COMMUNITY_OVS_VALID;
				break;
			} else if (strcmp(s, "invalid") == 0) {
				c->c.e.data2 = EXT_COMMUNITY_OVS_INVALID;
				break;
			} else if (strcmp(s, "not-found") == 0) {
				c->c.e.data2 = EXT_COMMUNITY_OVS_NOTFOUND;
				break;
			} else if (strcmp(s, "*") == 0) {
				c->dflag1 = COMMUNITY_ANY;
				break;
			}
		}
		yyerror("Bad ext-community %s", s);
		return (-1);
	}
	c->c.e.type = type;
	c->c.e.subtype = subtype;

	/* special handling of ext-community rt * since type is not known */
	if (c->dflag1 == COMMUNITY_ANY && c->c.e.type == -1) {
		c->type = COMMUNITY_TYPE_EXT;
		return (0);
	}
		
	/* verify type/subtype combo */
	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (cp->type == type && cp->subtype == subtype) {
			c->type = COMMUNITY_TYPE_EXT;
			return (0);
		}
	}

	yyerror("Bad ext-community bad format for type");
	return (-1);
}

struct peer *
alloc_peer(void)
{
	struct peer	*p;
	u_int8_t	 i;

	if ((p = calloc(1, sizeof(struct peer))) == NULL)
		fatal("new_peer");

	/* some sane defaults */
	p->state = STATE_NONE;
	p->conf.distance = 1;
	p->conf.export_type = EXPORT_UNSET;
	p->conf.announce_capa = 1;
	for (i = 0; i < AID_MAX; i++)
		p->conf.capabilities.mp[i] = 0;
	p->conf.capabilities.refresh = 1;
	p->conf.capabilities.grestart.restart = 1;
	p->conf.capabilities.as4byte = 1;
	p->conf.local_as = conf->as;
	p->conf.local_short_as = conf->short_as;

	if (conf->flags & BGPD_FLAG_DECISION_TRANS_AS)
		p->conf.flags |= PEERFLAG_TRANS_AS;

	return (p);
}

struct peer *
new_peer(void)
{
	struct peer		*p;

	p = alloc_peer();

	if (curgroup != NULL) {
		memcpy(p, curgroup, sizeof(struct peer));
		if (strlcpy(p->conf.group, curgroup->conf.group,
		    sizeof(p->conf.group)) >= sizeof(p->conf.group))
			fatalx("new_peer group strlcpy");
		if (strlcpy(p->conf.descr, curgroup->conf.descr,
		    sizeof(p->conf.descr)) >= sizeof(p->conf.descr))
			fatalx("new_peer descr strlcpy");
		p->conf.groupid = curgroup->conf.id;
		p->conf.local_as = curgroup->conf.local_as;
		p->conf.local_short_as = curgroup->conf.local_short_as;
	}
	return (p);
}

struct peer *
new_group(void)
{
	return (alloc_peer());
}

int
add_mrtconfig(enum mrt_type type, char *name, int timeout, struct peer *p,
    char *rib)
{
	struct mrt	*m, *n;

	LIST_FOREACH(m, conf->mrt, entry) {
		if ((rib && strcmp(rib, m->rib)) ||
		    (!rib && *m->rib))
			continue;
		if (p == NULL) {
			if (m->peer_id != 0 || m->group_id != 0)
				continue;
		} else {
			if (m->peer_id != p->conf.id ||
			    m->group_id != p->conf.groupid)
				continue;
		}
		if (m->type == type) {
			yyerror("only one mrtdump per type allowed.");
			return (-1);
		}
	}

	if ((n = calloc(1, sizeof(struct mrt_config))) == NULL)
		fatal("add_mrtconfig");

	n->type = type;
	if (strlcpy(MRT2MC(n)->name, name, sizeof(MRT2MC(n)->name)) >=
	    sizeof(MRT2MC(n)->name)) {
		yyerror("filename \"%s\" too long: max %zu",
		    name, sizeof(MRT2MC(n)->name) - 1);
		free(n);
		return (-1);
	}
	MRT2MC(n)->ReopenTimerInterval = timeout;
	if (p != NULL) {
		if (curgroup == p) {
			n->peer_id = 0;
			n->group_id = p->conf.id;
		} else {
			n->peer_id = p->conf.id;
			n->group_id = 0;
		}
	}
	if (rib) {
		if (!find_rib(rib)) {
			yyerror("rib \"%s\" does not exist.", rib);
			free(n);
			return (-1);
		}
		if (strlcpy(n->rib, rib, sizeof(n->rib)) >=
		    sizeof(n->rib)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(n->rib) - 1);
			free(n);
			return (-1);
		}
	}

	LIST_INSERT_HEAD(conf->mrt, n, entry);

	return (0);
}

int
add_rib(char *name, u_int rtableid, u_int16_t flags)
{
	struct rde_rib	*rr;
	u_int		 rdom, default_rdom;

	if ((rr = find_rib(name)) == NULL) {
		if ((rr = calloc(1, sizeof(*rr))) == NULL) {
			log_warn("add_rib");
			return (-1);
		}
	}
	if (strlcpy(rr->name, name, sizeof(rr->name)) >= sizeof(rr->name)) {
		yyerror("rib name \"%s\" too long: max %zu",
		   name, sizeof(rr->name) - 1);
		free(rr);
		return (-1);
	}
	rr->flags |= flags;
	if ((rr->flags & F_RIB_HASNOFIB) == 0) {
		if (ktable_exists(rtableid, &rdom) != 1) {
			yyerror("rtable id %u does not exist", rtableid);
			free(rr);
			return (-1);
		}
		if (ktable_exists(conf->default_tableid, &default_rdom) != 1)
			fatal("default rtable %u does not exist",
			    conf->default_tableid);
		if (rdom != default_rdom) {
			log_warnx("rtable %u does not belong to rdomain %u",
			    rtableid, default_rdom);
			free(rr);
			return (-1);
		}
	}
	rr->rtableid = rtableid;
	SIMPLEQ_INSERT_TAIL(&ribnames, rr, entry);
	return (0);
}

struct rde_rib *
find_rib(char *name)
{
	struct rde_rib	*rr;

	SIMPLEQ_FOREACH(rr, &ribnames, entry) {
		if (!strcmp(rr->name, name))
			return (rr);
	}
	return (NULL);
}

struct prefixset *
find_prefixset(char *name, struct prefixset_head *p)
{
	struct prefixset *ps;

	SIMPLEQ_FOREACH(ps, p, entry) {
		if (!strcmp(ps->name, name))
			return (ps);
	}
	return (NULL);
}

int
get_id(struct peer *newpeer)
{
	static u_int32_t id = 1;
	struct peer	*p = NULL;

	/* check if the peer already existed before */
	if (newpeer->conf.remote_addr.aid) {
		/* neighbor */
		if (cur_peers)
			TAILQ_FOREACH(p, cur_peers, entry)
				if (memcmp(&p->conf.remote_addr,
				    &newpeer->conf.remote_addr,
				    sizeof(p->conf.remote_addr)) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.id;
			return (0);
		}
	} else {
		/* group */
		if (cur_peers)
			TAILQ_FOREACH(p, cur_peers, entry)
				if (strcmp(p->conf.group,
				    newpeer->conf.group) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.groupid;
			return (0);
		}
	}

	/* else new one */
	if (id < UINT_MAX / 2) {
		newpeer->conf.id = id++;
		return (0);
	}

	return (-1);
}

int
merge_prefixspec(struct filter_prefix *p, struct filter_prefixlen *pl)
{
	u_int8_t max_len = 0;

	switch (p->addr.aid) {
	case AID_INET:
	case AID_VPN_IPv4:
		max_len = 32;
		break;
	case AID_INET6:
	case AID_VPN_IPv6:
		max_len = 128;
		break;
	}

	if (pl->op == OP_NONE) {
		p->len_min = p->len_max = p->len;
		return (0);
	}

	if (pl->len_min == -1)
		pl->len_min = p->len;
	if (pl->len_max == -1)
		pl->len_max = max_len;

	if (pl->len_max > max_len) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_max, max_len);
		return (-1);
	}
	if (pl->len_min > pl->len_max) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_min, pl->len_max);
		return (-1);
	}
	if (pl->len_min < p->len) {
		yyerror("prefixlen %d smaller than prefix, limit %d",
		    pl->len_min, p->len);
		return (-1);
	}

	p->op = pl->op;
	p->len_min = pl->len_min;
	p->len_max = pl->len_max;
	return (0);
}

int
expand_rule(struct filter_rule *rule, struct filter_rib_l *rib,
    struct filter_peers_l *peer, struct filter_match_l *match,
    struct filter_set_head *set)
{
	struct filter_rule	*r;
	struct filter_rib_l	*rb, *rbnext;
	struct filter_peers_l	*p, *pnext;
	struct filter_prefix_l	*prefix, *prefix_next;
	struct filter_as_l	*a, *anext;
	struct filter_set	*s;

	rb = rib;
	do {
		p = peer;
		do {
			a = match->as_l;
			do {
				prefix = match->prefix_l;
				do {
					if ((r = calloc(1,
					    sizeof(struct filter_rule))) ==
						 NULL) {
						log_warn("expand_rule");
						return (-1);
					}

					memcpy(r, rule, sizeof(struct filter_rule));
					memcpy(&r->match, match,
					    sizeof(struct filter_match));
					TAILQ_INIT(&r->set);
					copy_filterset(set, &r->set);

					if (rb != NULL)
						strlcpy(r->rib, rb->name,
						     sizeof(r->rib));

					if (p != NULL)
						memcpy(&r->peer, &p->p,
						    sizeof(struct filter_peers));

					if (prefix != NULL)
						memcpy(&r->match.prefix, &prefix->p,
						    sizeof(r->match.prefix));

					if (a != NULL)
						memcpy(&r->match.as, &a->a,
						    sizeof(struct filter_as));

					TAILQ_INSERT_TAIL(filter_l, r, entry);

					if (prefix != NULL)
						prefix = prefix->next;
				} while (prefix != NULL);

				if (a != NULL)
					a = a->next;
			} while (a != NULL);

			if (p != NULL)
				p = p->next;
		} while (p != NULL);

		if (rb != NULL)
			rb = rb->next;
	} while (rb != NULL);

	for (rb = rib; rb != NULL; rb = rbnext) {
		rbnext = rb->next;
		free(rb);
	}

	for (p = peer; p != NULL; p = pnext) {
		pnext = p->next;
		free(p);
	}

	for (a = match->as_l; a != NULL; a = anext) {
		anext = a->next;
		free(a);
	}

	for (prefix = match->prefix_l; prefix != NULL; prefix = prefix_next) {
		prefix_next = prefix->next;
		free(prefix);
	}

	if (set != NULL) {
		while ((s = TAILQ_FIRST(set)) != NULL) {
			TAILQ_REMOVE(set, s, entry);
			free(s);
		}
		free(set);
	}

	return (0);
}

int
str2key(char *s, char *dest, size_t max_len)
{
	unsigned	i;
	char		t[3];

	if (strlen(s) / 2 > max_len) {
		yyerror("key too long");
		return (-1);
	}

	if (strlen(s) % 2) {
		yyerror("key must be of even length");
		return (-1);
	}

	for (i = 0; i < strlen(s) / 2; i++) {
		t[0] = s[2*i];
		t[1] = s[2*i + 1];
		t[2] = 0;
		if (!isxdigit(t[0]) || !isxdigit(t[1])) {
			yyerror("key must be specified in hex");
			return (-1);
		}
		dest[i] = strtoul(t, NULL, 16);
	}

	return (0);
}

int
neighbor_consistent(struct peer *p)
{
	/* local-address and peer's address: same address family */
	if (p->conf.local_addr.aid &&
	    p->conf.local_addr.aid != p->conf.remote_addr.aid) {
		yyerror("local-address and neighbor address "
		    "must be of the same address family");
		return (-1);
	}

	/* with any form of ipsec local-address is required */
	if ((p->conf.auth.method == AUTH_IPSEC_IKE_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_IKE_AH ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    !p->conf.local_addr.aid) {
		yyerror("neighbors with any form of IPsec configured "
		    "need local-address to be specified");
		return (-1);
	}

	/* with static keying we need both directions */
	if ((p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    (!p->conf.auth.spi_in || !p->conf.auth.spi_out)) {
		yyerror("with manual keyed IPsec, SPIs and keys "
		    "for both directions are required");
		return (-1);
	}

	if (!conf->as) {
		yyerror("AS needs to be given before neighbor definitions");
		return (-1);
	}

	/* set default values if they where undefined */
	p->conf.ebgp = (p->conf.remote_as != conf->as);
	if (p->conf.enforce_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_as = p->conf.ebgp ?
		    ENFORCE_AS_ON : ENFORCE_AS_OFF;
	if (p->conf.enforce_local_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_local_as = ENFORCE_AS_ON;

	if (p->conf.remote_as == 0 && p->conf.enforce_as != ENFORCE_AS_OFF) {
		yyerror("peer AS may not be zero");
		return (-1);
	}

	/* EBGP neighbors are not allowed in route reflector clusters */
	if (p->conf.reflector_client && p->conf.ebgp) {
		yyerror("EBGP neighbors are not allowed in route "
		    "reflector clusters");
		return (-1);
	}

	return (0);
}

static void
filterset_add(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		if (s->type < t->type) {
			TAILQ_INSERT_BEFORE(t, s, entry);
			return;
		}
		if (s->type == t->type) {
			switch (s->type) {
			case ACTION_SET_COMMUNITY:
			case ACTION_DEL_COMMUNITY:
				if (memcmp(&s->action.community,
				    &t->action.community,
				    sizeof(s->action.community)) < 0) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (memcmp(&s->action.community,
				    &t->action.community,
				    sizeof(s->action.community)) == 0)
					break;
				continue;
			case ACTION_SET_NEXTHOP:
				/* only last nexthop per AF matters */
				if (s->action.nexthop.aid <
				    t->action.nexthop.aid) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (s->action.nexthop.aid ==
				    t->action.nexthop.aid) {
					t->action.nexthop = s->action.nexthop;
					break;
				}
				continue;
			case ACTION_SET_NEXTHOP_BLACKHOLE:
			case ACTION_SET_NEXTHOP_REJECT:
			case ACTION_SET_NEXTHOP_NOMODIFY:
			case ACTION_SET_NEXTHOP_SELF:
				/* set it only once */
				break;
			case ACTION_SET_LOCALPREF:
			case ACTION_SET_MED:
			case ACTION_SET_WEIGHT:
				/* only last set matters */
				t->action.metric = s->action.metric;
				break;
			case ACTION_SET_RELATIVE_LOCALPREF:
			case ACTION_SET_RELATIVE_MED:
			case ACTION_SET_RELATIVE_WEIGHT:
				/* sum all relative numbers */
				t->action.relative += s->action.relative;
				break;
			case ACTION_SET_ORIGIN:
				/* only last set matters */
				t->action.origin = s->action.origin;
				break;
			case ACTION_PFTABLE:
				/* only last set matters */
				strlcpy(t->action.pftable, s->action.pftable,
				    sizeof(t->action.pftable));
				break;
			case ACTION_RTLABEL:
				/* only last set matters */
				strlcpy(t->action.rtlabel, s->action.rtlabel,
				    sizeof(t->action.rtlabel));
				break;
			default:
				break;
			}
			free(s);
			return;
		}
	}

	TAILQ_INSERT_TAIL(sh, s, entry);
}

int
merge_filterset(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		/*
		 * need to cycle across the full list because even
		 * if types are not equal filterset_cmp() may return 0.
		 */
		if (filterset_cmp(s, t) == 0) {
			if (s->type == ACTION_SET_COMMUNITY)
				yyerror("community is already set");
			else if (s->type == ACTION_DEL_COMMUNITY)
				yyerror("community will already be deleted");
			else
				yyerror("redefining set parameter %s",
				    filterset_name(s->type));
			return (-1);
		}
	}

	filterset_add(sh, s);
	return (0);
}

static int
filter_equal(struct filter_rule *fa, struct filter_rule *fb)
{
	if (fa == NULL || fb == NULL)
		return 0;
	if (fa->action != fb->action || fa->quick != fb->quick ||
	    fa->dir != fb->dir)
		return 0;
	if (memcmp(&fa->peer, &fb->peer, sizeof(fa->peer)))
		return 0;
	if (memcmp(&fa->match, &fb->match, sizeof(fa->match)))
		return 0;

	return 1;
}

/* do a basic optimization by folding equal rules together */
void
optimize_filters(struct filter_head *fh)
{
	struct filter_rule *r, *nr;

	TAILQ_FOREACH_SAFE(r, fh, entry, nr) {
		while (filter_equal(r, nr)) {
			struct filter_set	*t;

			while((t = TAILQ_FIRST(&nr->set)) != NULL) {
				TAILQ_REMOVE(&nr->set, t, entry);
				filterset_add(&r->set, t);
			}

			TAILQ_REMOVE(fh, nr, entry);
			free(nr);
			nr = TAILQ_NEXT(r, entry);
		}
	}
}

struct filter_rule *
get_rule(enum action_types type)
{
	struct filter_rule	*r;
	int			 out;

	switch (type) {
	case ACTION_SET_PREPEND_SELF:
	case ACTION_SET_NEXTHOP_NOMODIFY:
	case ACTION_SET_NEXTHOP_SELF:
		out = 1;
		break;
	default:
		out = 0;
		break;
	}
	r = (curpeer == curgroup) ? curgroup_filter[out] : curpeer_filter[out];
	if (r == NULL) {
		if ((r = calloc(1, sizeof(struct filter_rule))) == NULL)
			fatal(NULL);
		r->quick = 0;
		r->dir = out ? DIR_OUT : DIR_IN;
		r->action = ACTION_NONE;
		TAILQ_INIT(&r->set);
		if (curpeer == curgroup) {
			/* group */
			r->peer.groupid = curgroup->conf.id;
			curgroup_filter[out] = r;
		} else {
			/* peer */
			r->peer.peerid = curpeer->conf.id;
			curpeer_filter[out] = r;
		}
	}
	return (r);
}

struct set_table *curset;
static int
new_as_set(char *name)
{
	struct as_set *aset;

	if (as_sets_lookup(conf->as_sets, name) != NULL) {
		yyerror("as-set \"%s\" already exists", name);
		return -1;
	}

	aset = as_sets_new(conf->as_sets, name, 0, sizeof(u_int32_t));
	if (aset == NULL)
		fatal(NULL);

	curset = aset->set;
	return 0;
}

static void
add_as_set(u_int32_t as)
{
	if (curset == NULL)
		fatalx("%s: bad mojo jojo", __func__);

	if (set_add(curset, &as, 1) != 0)
		fatal(NULL);
}

static void
done_as_set(void)
{
	curset = NULL;
}

static struct prefixset *
new_prefix_set(char *name, int is_roa)
{
	const char *type = "prefix-set";
	struct prefixset_head *sets = &conf->prefixsets;
	struct prefixset *pset;

	if (is_roa) {
		type = "roa-set";
		sets = &conf->originsets;
	}

	if (find_prefixset(name, sets) != NULL)  {
		yyerror("%s \"%s\" already exists", type, name);
		return NULL;
	}
	if ((pset = calloc(1, sizeof(*pset))) == NULL)
		fatal("prefixset");
	if (strlcpy(pset->name, name, sizeof(pset->name)) >=
	    sizeof(pset->name)) {
		yyerror("%s \"%s\" too long: max %zu", type,
		    name, sizeof(pset->name) - 1);
		free(pset);
		return NULL;
	}
	RB_INIT(&pset->psitems);
	return pset;
}

static void
add_roa_set(struct prefixset_item *npsi, u_int32_t as, u_int8_t max)
{
	struct prefixset_item	*psi;
	struct roa_set rs;

	/* no prefixlen option in this tree */
	npsi->p.op = OP_NONE;
	npsi->p.len_max = npsi->p.len_min = npsi->p.len;
	psi = RB_INSERT(prefixset_tree, curpsitree, npsi);
	if (psi == NULL)
		psi = npsi;

	if (psi->set == NULL)
		if ((psi->set = set_new(1, sizeof(rs))) == NULL)
			fatal("set_new");
	rs.as = as;
	rs.maxlen = max;
	if (set_add(psi->set, &rs, 1) != 0)
		fatal("as_set_new");
}
#line 2907 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss); /* overflow check above */
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs); /* overflow check above */
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 14:
#line 259 "parse.y"
{ file->errors++; }
break;
case 15:
#line 262 "parse.y"
{
			/*
			 * According to iana 65535 and 4294967295 are reserved
			 * but enforcing this is not duty of the parser.
			 */
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("AS too big: max %u", UINT_MAX);
				YYERROR;
			}
		}
break;
case 16:
#line 273 "parse.y"
{
			const char	*errstr;
			char		*dot;
			u_int32_t	 uvalh = 0, uval;

			if ((dot = strchr(yyvsp[0].v.string,'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum(yyvsp[0].v.string, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", yyvsp[0].v.string, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				free(yyvsp[0].v.string);
			} else {
				yyerror("AS %s is bad", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (uvalh == 0 && (uval == AS_TRANS || uval == 0)) {
				yyerror("AS %u is reserved and may not be used",
				    uval);
				YYERROR;
			}
			yyval.v.number = uval | (uvalh << 16);
		}
break;
case 17:
#line 305 "parse.y"
{
			if (yyvsp[0].v.number == AS_TRANS || yyvsp[0].v.number == 0) {
				yyerror("AS %u is reserved and may not be used",
				    (u_int32_t)yyvsp[0].v.number);
				YYERROR;
			}
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 18:
#line 315 "parse.y"
{
			const char	*errstr;
			char		*dot;
			u_int32_t	 uvalh = 0, uval;

			if ((dot = strchr(yyvsp[0].v.string,'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum(yyvsp[0].v.string, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", yyvsp[0].v.string, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				free(yyvsp[0].v.string);
			} else {
				yyerror("AS %s is bad", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			yyval.v.number = uval | (uvalh << 16);
		}
break;
case 19:
#line 342 "parse.y"
{
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 20:
#line 347 "parse.y"
{
			if (asprintf(&yyval.v.string, "%s %s", yyvsp[-1].v.string, yyvsp[0].v.string) == -1)
				fatal("string: asprintf");
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 22:
#line 356 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "yes"))
				yyval.v.number = 1;
			else if (!strcmp(yyvsp[0].v.string, "no"))
				yyval.v.number = 0;
			else {
				yyerror("syntax error, "
				    "either yes or no expected");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 23:
#line 371 "parse.y"
{
			char *s = yyvsp[-2].v.string;
			if (cmd_opts & BGPD_OPT_VERBOSE)
				printf("%s = \"%s\"\n", yyvsp[-2].v.string, yyvsp[0].v.string);
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespace");
					free(yyvsp[-2].v.string);
					free(yyvsp[0].v.string);
					YYERROR;
				}
			}
			if (symset(yyvsp[-2].v.string, yyvsp[0].v.string, 0) == -1)
				fatal("cannot store variable");
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 24:
#line 391 "parse.y"
{
			struct file	*nfile;

			if ((nfile = pushfile(yyvsp[0].v.string, 1)) == NULL) {
				yyerror("failed to include file %s", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			file = nfile;
			lungetc('\n');
		}
break;
case 25:
#line 406 "parse.y"
{
			if (new_as_set(yyvsp[-2].v.string) != 0) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 26:
#line 412 "parse.y"
{
			done_as_set();
		}
break;
case 27:
#line 415 "parse.y"
{
			if (new_as_set(yyvsp[-3].v.string) != 0) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
		}
break;
case 28:
#line 423 "parse.y"
{ add_as_set(yyvsp[0].v.number); }
break;
case 29:
#line 424 "parse.y"
{ add_as_set(yyvsp[0].v.number); }
break;
case 30:
#line 426 "parse.y"
{
			if ((curpset = new_prefix_set(yyvsp[-2].v.string, 0)) == NULL) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 31:
#line 432 "parse.y"
{
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
break;
case 32:
#line 436 "parse.y"
{
			if ((curpset = new_prefix_set(yyvsp[-3].v.string, 0)) == NULL) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
break;
case 33:
#line 446 "parse.y"
{
			struct prefixset_item	*psi;
			if (yyvsp[0].v.prefixset_item->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, yyvsp[0].v.prefixset_item);
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&yyvsp[0].v.prefixset_item->p.addr), yyvsp[0].v.prefixset_item->p.len);
				free(yyvsp[0].v.prefixset_item);
			}
		}
break;
case 34:
#line 460 "parse.y"
{
			struct prefixset_item	*psi;
			if (yyvsp[0].v.prefixset_item->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, yyvsp[0].v.prefixset_item);
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&yyvsp[0].v.prefixset_item->p.addr), yyvsp[0].v.prefixset_item->p.len);
				free(yyvsp[0].v.prefixset_item);
			}
		}
break;
case 35:
#line 476 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op != OP_NONE && yyvsp[0].v.prefixlen.op != OP_RANGE) {
				yyerror("unsupported prefixlen operation in "
				    "prefix-set");
				YYERROR;
			}
			if ((yyval.v.prefixset_item = calloc(1, sizeof(*yyval.v.prefixset_item))) == NULL)
				fatal(NULL);
			memcpy(&yyval.v.prefixset_item->p.addr, &yyvsp[-1].v.prefix.prefix, sizeof(yyval.v.prefixset_item->p.addr));
			yyval.v.prefixset_item->p.len = yyvsp[-1].v.prefix.len;
			if (merge_prefixspec(&yyval.v.prefixset_item->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.prefixset_item);
				YYERROR;
			}
		}
break;
case 36:
#line 493 "parse.y"
{
			curpsitree = &conf->roa;
		}
break;
case 37:
#line 495 "parse.y"
{
			curpsitree = NULL;
		}
break;
case 39:
#line 501 "parse.y"
{
			if ((curoset = new_prefix_set(yyvsp[-2].v.string, 1)) == NULL) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			curpsitree = &curoset->psitems;
			free(yyvsp[-2].v.string);
		}
break;
case 40:
#line 508 "parse.y"
{
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curpsitree = NULL;
		}
break;
case 41:
#line 513 "parse.y"
{
			if ((curoset = new_prefix_set(yyvsp[-3].v.string, 1)) == NULL) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curpsitree = NULL;
		}
break;
case 42:
#line 525 "parse.y"
{
			if (yyvsp[-2].v.prefixset_item->p.len_min != yyvsp[-2].v.prefixset_item->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free(yyvsp[-2].v.prefixset_item);
				YYERROR;
			}
			add_roa_set(yyvsp[-2].v.prefixset_item, yyvsp[0].v.number, yyvsp[-2].v.prefixset_item->p.len_max);
		}
break;
case 43:
#line 534 "parse.y"
{
			if (yyvsp[-2].v.prefixset_item->p.len_min != yyvsp[-2].v.prefixset_item->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free(yyvsp[-2].v.prefixset_item);
				YYERROR;
			}
			add_roa_set(yyvsp[-2].v.prefixset_item, yyvsp[0].v.number, yyvsp[-2].v.prefixset_item->p.len_max);
		}
break;
case 44:
#line 545 "parse.y"
{
			conf->as = yyvsp[0].v.number;
			if (yyvsp[0].v.number > USHRT_MAX)
				conf->short_as = AS_TRANS;
			else
				conf->short_as = yyvsp[0].v.number;
		}
break;
case 45:
#line 552 "parse.y"
{
			conf->as = yyvsp[-1].v.number;
			conf->short_as = yyvsp[0].v.number;
		}
break;
case 46:
#line 556 "parse.y"
{
			if (yyvsp[0].v.addr.aid != AID_INET) {
				yyerror("router-id must be an IPv4 address");
				YYERROR;
			}
			conf->bgpid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 47:
#line 563 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->holdtime = yyvsp[0].v.number;
		}
break;
case 48:
#line 571 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->min_holdtime = yyvsp[0].v.number;
		}
break;
case 49:
#line 579 "parse.y"
{
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			sa = addr2sa(&yyvsp[0].v.addr, BGP_PORT, &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
break;
case 50:
#line 592 "parse.y"
{
			if (yyvsp[0].v.number <= RTP_NONE || yyvsp[0].v.number > RTP_MAX) {
				yyerror("invalid fib-priority");
				YYERROR;
			}
			conf->fib_priority = yyvsp[0].v.number;
		}
break;
case 51:
#line 599 "parse.y"
{
			struct rde_rib *rr;
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE can not find the main RIB!");

			if (yyvsp[0].v.number == 0)
				rr->flags |= F_RIB_NOFIBSYNC;
			else
				rr->flags &= ~F_RIB_NOFIBSYNC;
		}
break;
case 52:
#line 610 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				conf->flags |= BGPD_FLAG_NO_EVALUATE;
			else
				conf->flags &= ~BGPD_FLAG_NO_EVALUATE;
		}
break;
case 53:
#line 616 "parse.y"
{
			if (add_rib(yyvsp[0].v.string, conf->default_tableid, F_RIB_NOFIB)) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 54:
#line 623 "parse.y"
{
			if (yyvsp[-1].v.number) {
				free(yyvsp[-2].v.string);
				yyerror("bad rde rib definition");
				YYERROR;
			}
			if (add_rib(yyvsp[-2].v.string, conf->default_tableid,
			    F_RIB_NOFIB | F_RIB_NOEVALUATE)) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 55:
#line 636 "parse.y"
{
			if (yyvsp[0].v.number > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", yyvsp[0].v.number,
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (add_rib(yyvsp[-2].v.string, yyvsp[0].v.number, 0)) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 56:
#line 648 "parse.y"
{
			int	flags = 0;
			if (yyvsp[-2].v.number > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", yyvsp[-2].v.number,
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (yyvsp[0].v.number == 0)
				flags = F_RIB_NOFIBSYNC;
			if (add_rib(yyvsp[-4].v.string, yyvsp[-2].v.number, flags)) {
				free(yyvsp[-4].v.string);
				YYERROR;
			}
			free(yyvsp[-4].v.string);
		}
break;
case 57:
#line 663 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				conf->flags |= BGPD_FLAG_DECISION_TRANS_AS;
			else
				conf->flags &= ~BGPD_FLAG_DECISION_TRANS_AS;
		}
break;
case 58:
#line 669 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "updates"))
				conf->log |= BGPD_LOG_UPDATES;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 60:
#line 679 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-2].v.string, "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp(yyvsp[-2].v.string, "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp(yyvsp[-2].v.string, "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, NULL, NULL) == -1) {
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 61:
#line 707 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-3].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-2].v.string, "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp(yyvsp[-2].v.string, "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp(yyvsp[-2].v.string, "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free(yyvsp[-3].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, NULL, yyvsp[-3].v.string) == -1) {
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			free(yyvsp[-1].v.string);
		}
break;
case 63:
#line 740 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags |= BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 64:
#line 750 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags &= ~BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 65:
#line 760 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "always"))
				conf->flags |= BGPD_FLAG_DECISION_MED_ALWAYS;
			else if (!strcmp(yyvsp[0].v.string, "strict"))
				conf->flags &= ~BGPD_FLAG_DECISION_MED_ALWAYS;
			else {
				yyerror("rde med compare: "
				    "unknown setting \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 66:
#line 773 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "bgp"))
				conf->flags |= BGPD_FLAG_NEXTHOP_BGP;
			else if (!strcmp(yyvsp[0].v.string, "default"))
				conf->flags |= BGPD_FLAG_NEXTHOP_DEFAULT;
			else {
				yyerror("nexthop depend on: "
				    "unknown setting \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 67:
#line 786 "parse.y"
{
			struct rde_rib *rr;
			if (yyvsp[0].v.number > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", yyvsp[0].v.number,
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (ktable_exists(yyvsp[0].v.number, NULL) != 1) {
				yyerror("rtable id %lld does not exist", yyvsp[0].v.number);
				YYERROR;
			}
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE can not find the main RIB!");
			rr->rtableid = yyvsp[0].v.number;
		}
break;
case 68:
#line 802 "parse.y"
{
			if (yyvsp[0].v.number > USHRT_MAX || yyvsp[0].v.number < 1) {
				yyerror("invalid connect-retry");
				YYERROR;
			}
			conf->connectretry = yyvsp[0].v.number;
		}
break;
case 69:
#line 809 "parse.y"
{
			if (strlen(yyvsp[-1].v.string) >=
			    sizeof(((struct sockaddr_un *)0)->sun_path)) {
				yyerror("socket path too long");
				YYERROR;
			}
			if (yyvsp[0].v.number) {
				free(conf->rcsock);
				conf->rcsock = yyvsp[-1].v.string;
			} else {
				free(conf->csock);
				conf->csock = yyvsp[-1].v.string;
			}
		}
break;
case 70:
#line 825 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-3].v.string, "all"))
				action = yyvsp[-2].v.number ? MRT_ALL_IN : MRT_ALL_OUT;
			else if (!strcmp(yyvsp[-3].v.string, "updates"))
				action = yyvsp[-2].v.number ? MRT_UPDATE_IN : MRT_UPDATE_OUT;
			else {
				yyerror("unknown mrt msg dump type");
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, curpeer, NULL) ==
			    -1) {
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			free(yyvsp[-1].v.string);
		}
break;
case 71:
#line 855 "parse.y"
{
			struct network	*n, *m;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			memcpy(&n->net.prefix, &yyvsp[-1].v.prefix.prefix,
			    sizeof(n->net.prefix));
			n->net.prefixlen = yyvsp[-1].v.prefix.len;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);
			TAILQ_FOREACH(m, netconf, entry) {
				if (n->net.type == m->net.type &&
				    n->net.prefixlen == m->net.prefixlen &&
				    prefix_compare(&n->net.prefix,
				    &m->net.prefix, n->net.prefixlen) == 0)
					yyerror("duplicate prefix "
					    "in network statement");
			}

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 72:
#line 876 "parse.y"
{
			struct prefixset *ps;
			struct network	*n;
			if ((ps = find_prefixset(yyvsp[-1].v.string, &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			if (ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s has prefixlen operators "
				    "and cannot be used in network statements.",
				    ps->name);
				free(yyvsp[-1].v.string);
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			strlcpy(n->net.psname, ps->name, sizeof(n->net.psname));
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			n->net.type = NETWORK_PREFIXSET;
			TAILQ_INSERT_TAIL(netconf, n, entry);
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 73:
#line 905 "parse.y"
{
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-3].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = NETWORK_RTLABEL;
			n->net.rtlabel = rtlabel_name2id(yyvsp[-1].v.string);
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 74:
#line 924 "parse.y"
{
			struct network	*n;
			if (yyvsp[-1].v.number < RTP_LOCAL && yyvsp[-1].v.number > RTP_MAX) {
				yyerror("priority %lld > max %d or < min %d", yyvsp[-1].v.number,
				    RTP_MAX, RTP_LOCAL);
				YYERROR;
			}

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-3].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = NETWORK_PRIORITY;
			n->net.priority = yyvsp[-1].v.number;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 75:
#line 948 "parse.y"
{
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-2].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = yyvsp[-1].v.number ? NETWORK_STATIC : NETWORK_CONNECTED;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 76:
#line 968 "parse.y"
{ yyval.v.number = 1; }
break;
case 77:
#line 969 "parse.y"
{ yyval.v.number = 0; }
break;
case 78:
#line 972 "parse.y"
{ yyval.v.number = 1; }
break;
case 79:
#line 973 "parse.y"
{ yyval.v.number = 0; }
break;
case 80:
#line 976 "parse.y"
{
			u_int8_t	len;

			if (!host(yyvsp[0].v.string, &yyval.v.addr, &len)) {
				yyerror("could not parse address spec \"%s\"",
				    yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			if ((yyval.v.addr.aid == AID_INET && len != 32) ||
			    (yyval.v.addr.aid == AID_INET6 && len != 128)) {
				/* unreachable */
				yyerror("got prefixlen %u, expected %u",
				    len, yyval.v.addr.aid == AID_INET ? 32 : 128);
				YYERROR;
			}
		}
break;
case 81:
#line 997 "parse.y"
{
			char	*s;
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad prefixlen %lld", yyvsp[0].v.number);
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			if (asprintf(&s, "%s/%lld", yyvsp[-2].v.string, yyvsp[0].v.number) == -1)
				fatal(NULL);
			free(yyvsp[-2].v.string);

			if (!host(s, &yyval.v.prefix.prefix, &yyval.v.prefix.len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
break;
case 82:
#line 1015 "parse.y"
{
			char	*s;

			/* does not match IPv6 */
			if (yyvsp[-2].v.number < 0 || yyvsp[-2].v.number > 255 || yyvsp[0].v.number < 0 || yyvsp[0].v.number > 32) {
				yyerror("bad prefix %lld/%lld", yyvsp[-2].v.number, yyvsp[0].v.number);
				YYERROR;
			}
			if (asprintf(&s, "%lld/%lld", yyvsp[-2].v.number, yyvsp[0].v.number) == -1)
				fatal(NULL);

			if (!host(s, &yyval.v.prefix.prefix, &yyval.v.prefix.len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
break;
case 83:
#line 1035 "parse.y"
{
			memcpy(&yyval.v.prefix.prefix, &yyvsp[0].v.addr, sizeof(struct bgpd_addr));
			if (yyval.v.prefix.prefix.aid == AID_INET)
				yyval.v.prefix.len = 32;
			else
				yyval.v.prefix.len = 128;
		}
break;
case 85:
#line 1045 "parse.y"
{ yyval.v.number = 0; }
break;
case 87:
#line 1049 "parse.y"
{
			u_int rdomain, label;

			if (get_mpe_config(yyvsp[0].v.string, &rdomain, &label) == -1) {
				if ((cmd_opts & BGPD_OPT_NOACTION) == 0) {
					yyerror("troubles getting config of %s",
					    yyvsp[0].v.string);
					free(yyvsp[0].v.string);
					free(yyvsp[-2].v.string);
					YYERROR;
				}
			}

			if (!(curvpn = calloc(1, sizeof(struct l3vpn))))
				fatal(NULL);
			strlcpy(curvpn->ifmpe, yyvsp[0].v.string, IFNAMSIZ);

			if (strlcpy(curvpn->descr, yyvsp[-2].v.string,
			    sizeof(curvpn->descr)) >=
			    sizeof(curvpn->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    yyvsp[-2].v.string, sizeof(curvpn->descr) - 1);
				free(yyvsp[-2].v.string);
				free(yyvsp[0].v.string);
				free(curvpn);
				curvpn = NULL;
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);

			TAILQ_INIT(&curvpn->import);
			TAILQ_INIT(&curvpn->export);
			TAILQ_INIT(&curvpn->net_l);
			curvpn->label = label;
			curvpn->rtableid = rdomain;
			netconf = &curvpn->net_l;
		}
break;
case 88:
#line 1086 "parse.y"
{
			/* insert into list */
			SIMPLEQ_INSERT_TAIL(&conf->l3vpns, curvpn, entry);
			curvpn = NULL;
			netconf = &conf->networks;
		}
break;
case 93:
#line 1100 "parse.y"
{
			struct filter_community	ext;
			u_int64_t		rd;

			memset(&ext, 0, sizeof(ext));
			if (parseextcommunity(&ext, "rt", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			/*
			 * RD is almost encode like an ext-community,
			 * but only almost so convert here.
			 */
			if (community_ext_conv(&ext, NULL, &rd, NULL)) {
				yyerror("bad encoding of rd");
				YYERROR;
			}
			rd = be64toh(rd) & 0xffffffffffffULL;
			switch (ext.c.e.type) {
			case EXT_COMMUNITY_TRANS_TWO_AS:
				rd |= (0ULL << 48);
				break;
			case EXT_COMMUNITY_TRANS_IPV4:
				rd |= (1ULL << 48);
				break;
			case EXT_COMMUNITY_TRANS_FOUR_AS:
				rd |= (2ULL << 48);
				break;
			default:
				yyerror("bad encoding of rd");
				YYERROR;
			}
			curvpn->rd = htobe64(rd);
		}
break;
case 94:
#line 1135 "parse.y"
{
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyvsp[-1].v.string);
				free(set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			free(yyvsp[-1].v.string);
			TAILQ_INSERT_TAIL(&curvpn->export, set, entry);
		}
break;
case 95:
#line 1153 "parse.y"
{
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyvsp[-1].v.string);
				free(set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			free(yyvsp[-1].v.string);
			TAILQ_INSERT_TAIL(&curvpn->import, set, entry);
		}
break;
case 96:
#line 1171 "parse.y"
{
			if (yyvsp[0].v.number == 0)
				curvpn->flags |= F_RIB_NOFIBSYNC;
			else
				curvpn->flags &= ~F_RIB_NOFIBSYNC;
		}
break;
case 98:
#line 1180 "parse.y"
{	curpeer = new_peer(); }
break;
case 99:
#line 1181 "parse.y"
{
			memcpy(&curpeer->conf.remote_addr, &yyvsp[0].v.prefix.prefix,
			    sizeof(curpeer->conf.remote_addr));
			curpeer->conf.remote_masklen = yyvsp[0].v.prefix.len;
			if ((yyvsp[0].v.prefix.prefix.aid == AID_INET && yyvsp[0].v.prefix.len != 32) ||
			    (yyvsp[0].v.prefix.prefix.aid == AID_INET6 && yyvsp[0].v.prefix.len != 128))
				curpeer->conf.template = 1;
			curpeer->conf.capabilities.mp[
			    curpeer->conf.remote_addr.aid] = 1;
			if (get_id(curpeer)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 100:
#line 1195 "parse.y"
{
			if (curpeer_filter[0] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[0], entry);
			if (curpeer_filter[1] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[1], entry);
			curpeer_filter[0] = NULL;
			curpeer_filter[1] = NULL;

			if (neighbor_consistent(curpeer) == -1)
				YYERROR;
			TAILQ_INSERT_TAIL(new_peers, curpeer, entry);
			curpeer = curgroup;
		}
break;
case 101:
#line 1212 "parse.y"
{
			curgroup = curpeer = new_group();
			if (strlcpy(curgroup->conf.group, yyvsp[0].v.string,
			    sizeof(curgroup->conf.group)) >=
			    sizeof(curgroup->conf.group)) {
				yyerror("group name \"%s\" too long: max %zu",
				    yyvsp[0].v.string, sizeof(curgroup->conf.group) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			if (get_id(curgroup)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 102:
#line 1227 "parse.y"
{
			if (curgroup_filter[0] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[0], entry);
			if (curgroup_filter[1] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[1], entry);
			curgroup_filter[0] = NULL;
			curgroup_filter[1] = NULL;

			free(curgroup);
			curgroup = NULL;
		}
break;
case 115:
#line 1260 "parse.y"
{
			curpeer->conf.remote_as = yyvsp[0].v.number;
		}
break;
case 116:
#line 1263 "parse.y"
{
			curpeer->conf.local_as = yyvsp[0].v.number;
			if (yyvsp[0].v.number > USHRT_MAX)
				curpeer->conf.local_short_as = AS_TRANS;
			else
				curpeer->conf.local_short_as = yyvsp[0].v.number;
		}
break;
case 117:
#line 1270 "parse.y"
{
			curpeer->conf.local_as = yyvsp[-1].v.number;
			curpeer->conf.local_short_as = yyvsp[0].v.number;
		}
break;
case 118:
#line 1274 "parse.y"
{
			if (strlcpy(curpeer->conf.descr, yyvsp[0].v.string,
			    sizeof(curpeer->conf.descr)) >=
			    sizeof(curpeer->conf.descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    yyvsp[0].v.string, sizeof(curpeer->conf.descr) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 119:
#line 1285 "parse.y"
{
			memcpy(&curpeer->conf.local_addr, &yyvsp[0].v.addr,
			    sizeof(curpeer->conf.local_addr));
		}
break;
case 120:
#line 1289 "parse.y"
{
			if (yyvsp[0].v.number < 2 || yyvsp[0].v.number > 255) {
				yyerror("invalid multihop distance %lld", yyvsp[0].v.number);
				YYERROR;
			}
			curpeer->conf.distance = yyvsp[0].v.number;
		}
break;
case 121:
#line 1296 "parse.y"
{
			curpeer->conf.passive = 1;
		}
break;
case 122:
#line 1299 "parse.y"
{
			curpeer->conf.down = 1;
		}
break;
case 123:
#line 1302 "parse.y"
{
			curpeer->conf.down = 1;
			if (strlcpy(curpeer->conf.shutcomm, yyvsp[0].v.string,
				sizeof(curpeer->conf.shutcomm)) >=
				sizeof(curpeer->conf.shutcomm)) {
				    yyerror("shutdown reason too long");
				    free(yyvsp[0].v.string);
				    YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 124:
#line 1313 "parse.y"
{
			if (!find_rib(yyvsp[0].v.string)) {
				yyerror("rib \"%s\" does not exist.", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(curpeer->conf.rib, yyvsp[0].v.string,
			    sizeof(curpeer->conf.rib)) >=
			    sizeof(curpeer->conf.rib)) {
				yyerror("rib name \"%s\" too long: max %zu",
				   yyvsp[0].v.string, sizeof(curpeer->conf.rib) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 125:
#line 1329 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.holdtime = yyvsp[0].v.number;
		}
break;
case 126:
#line 1337 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.min_holdtime = yyvsp[0].v.number;
		}
break;
case 127:
#line 1345 "parse.y"
{
			u_int8_t	aid, safi;
			u_int16_t	afi;

			if (yyvsp[0].v.number == SAFI_NONE) {
				for (aid = 0; aid < AID_MAX; aid++) {
					if (aid2afi(aid, &afi, &safi) == -1 ||
					    afi != yyvsp[-1].v.number)
						continue;
					curpeer->conf.capabilities.mp[aid] = 0;
				}	
			} else {
				if (afi2aid(yyvsp[-1].v.number, yyvsp[0].v.number, &aid) == -1) {
					yyerror("unknown AFI/SAFI pair");
					YYERROR;
				}
				curpeer->conf.capabilities.mp[aid] = 1;
			}
		}
break;
case 128:
#line 1364 "parse.y"
{
			curpeer->conf.announce_capa = yyvsp[0].v.number;
		}
break;
case 129:
#line 1367 "parse.y"
{
			curpeer->conf.capabilities.refresh = yyvsp[0].v.number;
		}
break;
case 130:
#line 1370 "parse.y"
{
			curpeer->conf.capabilities.grestart.restart = yyvsp[0].v.number;
		}
break;
case 131:
#line 1373 "parse.y"
{
			curpeer->conf.capabilities.as4byte = yyvsp[0].v.number;
		}
break;
case 132:
#line 1376 "parse.y"
{
			curpeer->conf.export_type = EXPORT_NONE;
		}
break;
case 133:
#line 1379 "parse.y"
{
			curpeer->conf.export_type = EXPORT_DEFAULT_ROUTE;
		}
break;
case 134:
#line 1382 "parse.y"
{
			if (yyvsp[0].v.number)
				curpeer->conf.enforce_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_as = ENFORCE_AS_OFF;
		}
break;
case 135:
#line 1388 "parse.y"
{
			if (yyvsp[0].v.number)
				curpeer->conf.enforce_local_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_local_as = ENFORCE_AS_OFF;
		}
break;
case 136:
#line 1394 "parse.y"
{
			if (yyvsp[0].v.number) {
				struct filter_rule	*r;
				struct filter_set	*s;

				if ((s = calloc(1, sizeof(struct filter_set)))
				    == NULL)
					fatal(NULL);
				s->type = ACTION_SET_AS_OVERRIDE;

				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
		}
break;
case 137:
#line 1409 "parse.y"
{
			if (yyvsp[-1].v.number < 0 || yyvsp[-1].v.number > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_prefix = yyvsp[-1].v.number;
			curpeer->conf.max_prefix_restart = yyvsp[0].v.number;
		}
break;
case 138:
#line 1417 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(curpeer->conf.auth.md5key, yyvsp[0].v.string,
			    sizeof(curpeer->conf.auth.md5key)) >=
			    sizeof(curpeer->conf.auth.md5key)) {
				yyerror("tcp md5sig password too long: max %zu",
				    sizeof(curpeer->conf.auth.md5key) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 139:
#line 1435 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, curpeer->conf.auth.md5key,
			    sizeof(curpeer->conf.auth.md5key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string) / 2;
			free(yyvsp[0].v.string);
		}
break;
case 140:
#line 1451 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				YYERROR;
			}
			if (yyvsp[-1].v.number)
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_ESP;
			else
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_AH;
		}
break;
case 141:
#line 1461 "parse.y"
{
			u_int32_t	auth_alg;
			u_int8_t	keylen;

			if (curpeer->conf.auth.method &&
			    (((curpeer->conf.auth.spi_in && yyvsp[-5].v.number == 1) ||
			    (curpeer->conf.auth.spi_out && yyvsp[-5].v.number == 0)) ||
			    (yyvsp[-6].v.number == 1 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_ESP) ||
			    (yyvsp[-6].v.number == 0 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_AH))) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (!strcmp(yyvsp[-2].v.string, "sha1")) {
				auth_alg = SADB_AALG_SHA1HMAC;
				keylen = 20;
			} else if (!strcmp(yyvsp[-2].v.string, "md5")) {
				auth_alg = SADB_AALG_MD5HMAC;
				keylen = 16;
			} else {
				yyerror("unknown auth algorithm \"%s\"", yyvsp[-2].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);

			if (strlen(yyvsp[-1].v.string) / 2 != keylen) {
				yyerror("auth key len: must be %u bytes, "
				    "is %zu bytes", keylen, strlen(yyvsp[-1].v.string) / 2);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (yyvsp[-6].v.number)
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_ESP;
			else {
				if (yyvsp[0].v.encspec.enc_alg) {
					yyerror("\"ipsec ah\" doesn't take "
					    "encryption keys");
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_AH;
			}

			if (yyvsp[-3].v.number <= SPI_RESERVED_MAX || yyvsp[-3].v.number > UINT_MAX) {
				yyerror("bad spi number %lld", yyvsp[-3].v.number);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (yyvsp[-5].v.number == 1) {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_in,
				    sizeof(curpeer->conf.auth.auth_key_in)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_in = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_in = auth_alg;
				curpeer->conf.auth.enc_alg_in = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_in,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_in));
				curpeer->conf.auth.enc_keylen_in =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_in = keylen;
			} else {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_out,
				    sizeof(curpeer->conf.auth.auth_key_out)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_out = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_out = auth_alg;
				curpeer->conf.auth.enc_alg_out = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_out,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_out));
				curpeer->conf.auth.enc_keylen_out =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_out = keylen;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 142:
#line 1554 "parse.y"
{
			curpeer->conf.ttlsec = yyvsp[0].v.number;
		}
break;
case 143:
#line 1557 "parse.y"
{
			struct filter_rule	*r;

			r = get_rule(yyvsp[0].v.filter_set->type);
			if (merge_filterset(&r->set, yyvsp[0].v.filter_set) == -1)
				YYERROR;
		}
break;
case 144:
#line 1564 "parse.y"
{
			struct filter_rule	*r;
			struct filter_set	*s;

			while ((s = TAILQ_FIRST(yyvsp[-2].v.filter_set_head)) != NULL) {
				TAILQ_REMOVE(yyvsp[-2].v.filter_set_head, s, entry);
				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
			free(yyvsp[-2].v.filter_set_head);
		}
break;
case 146:
#line 1577 "parse.y"
{
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != 0) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
		}
break;
case 147:
#line 1587 "parse.y"
{
			if (yyvsp[0].v.addr.aid != AID_INET) {
				yyerror("route reflector cluster-id must be "
				    "an IPv4 address");
				YYERROR;
			}
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != yyvsp[0].v.addr.v4.s_addr) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
			conf->clusterid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 148:
#line 1603 "parse.y"
{
			if (strlcpy(curpeer->conf.if_depend, yyvsp[0].v.string,
			    sizeof(curpeer->conf.if_depend)) >=
			    sizeof(curpeer->conf.if_depend)) {
				yyerror("interface name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string,
				    sizeof(curpeer->conf.if_depend) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 149:
#line 1615 "parse.y"
{
#ifdef HAVE_CARP
			if (strlcpy(curpeer->conf.demote_group, yyvsp[0].v.string,
			    sizeof(curpeer->conf.demote_group)) >=
			    sizeof(curpeer->conf.demote_group)) {
				yyerror("demote group name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string,
				    sizeof(curpeer->conf.demote_group) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			if (carp_demote_init(curpeer->conf.demote_group,
			    cmd_opts & BGPD_OPT_FORCE_DEMOTE) == -1) {
				yyerror("error initializing group \"%s\"",
				    curpeer->conf.demote_group);
				YYERROR;
			}
#else
			yyerror("carp demote not supported");
			free(yyvsp[0].v.string);
			YYERROR;
#endif
		}
break;
case 150:
#line 1639 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				curpeer->conf.flags |= PEERFLAG_TRANS_AS;
			else
				curpeer->conf.flags &= ~PEERFLAG_TRANS_AS;
		}
break;
case 151:
#line 1645 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "updates"))
				curpeer->conf.flags |= PEERFLAG_LOG_UPDATES;
			else if (!strcmp(yyvsp[0].v.string, "no"))
				curpeer->conf.flags &= ~PEERFLAG_LOG_UPDATES;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 152:
#line 1658 "parse.y"
{ yyval.v.number = 0; }
break;
case 153:
#line 1659 "parse.y"
{
			if (yyvsp[0].v.number < 1 || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("restart out of range. 1 to %u minutes",
				    USHRT_MAX);
				YYERROR;
			}
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 154:
#line 1669 "parse.y"
{ yyval.v.number = AFI_IPv4; }
break;
case 155:
#line 1670 "parse.y"
{ yyval.v.number = AFI_IPv6; }
break;
case 156:
#line 1673 "parse.y"
{ yyval.v.number = SAFI_NONE; }
break;
case 157:
#line 1674 "parse.y"
{ yyval.v.number = SAFI_UNICAST; }
break;
case 158:
#line 1675 "parse.y"
{ yyval.v.number = SAFI_MPLSVPN; }
break;
case 159:
#line 1678 "parse.y"
{ yyval.v.number = 1; }
break;
case 160:
#line 1679 "parse.y"
{ yyval.v.number = 0; }
break;
case 161:
#line 1682 "parse.y"
{ yyval.v.number = 1; }
break;
case 162:
#line 1683 "parse.y"
{ yyval.v.number = 0; }
break;
case 163:
#line 1686 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
		}
break;
case 164:
#line 1689 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
			if (!strcmp(yyvsp[-1].v.string, "3des") || !strcmp(yyvsp[-1].v.string, "3des-cbc")) {
				yyval.v.encspec.enc_alg = SADB_EALG_3DESCBC;
				yyval.v.encspec.enc_key_len = 21; /* XXX verify */
			} else if (!strcmp(yyvsp[-1].v.string, "aes") ||
			    !strcmp(yyvsp[-1].v.string, "aes-128-cbc")) {
				yyval.v.encspec.enc_alg = SADB_X_EALG_AES;
				yyval.v.encspec.enc_key_len = 16;
			} else {
				yyerror("unknown enc algorithm \"%s\"", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);

			if (strlen(yyvsp[0].v.string) / 2 != yyval.v.encspec.enc_key_len) {
				yyerror("enc key length wrong: should be %u "
				    "bytes, is %zu bytes",
				    yyval.v.encspec.enc_key_len * 2, strlen(yyvsp[0].v.string));
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, yyval.v.encspec.enc_key, sizeof(yyval.v.encspec.enc_key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 165:
#line 1724 "parse.y"
{
			struct filter_rule	 r;
			struct filter_rib_l	 *rb, *rbnext;

			bzero(&r, sizeof(r));
			r.action = yyvsp[-6].v.u8;
			r.quick = yyvsp[-5].v.u8;
			r.dir = yyvsp[-3].v.u8;
			if (yyvsp[-4].v.filter_rib) {
				if (r.dir != DIR_IN) {
					yyerror("rib only allowed on \"from\" "
					    "rules.");

					for (rb = yyvsp[-4].v.filter_rib; rb != NULL; rb = rbnext) {
						rbnext = rb->next;
						free(rb);
					}
					YYERROR;
				}
			}
			if (expand_rule(&r, yyvsp[-4].v.filter_rib, yyvsp[-2].v.filter_peers, &yyvsp[-1].v.filter_match, yyvsp[0].v.filter_set_head) == -1)
				YYERROR;
		}
break;
case 166:
#line 1749 "parse.y"
{ yyval.v.u8 = ACTION_ALLOW; }
break;
case 167:
#line 1750 "parse.y"
{ yyval.v.u8 = ACTION_DENY; }
break;
case 168:
#line 1751 "parse.y"
{ yyval.v.u8 = ACTION_NONE; }
break;
case 169:
#line 1754 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 170:
#line 1755 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 171:
#line 1758 "parse.y"
{ yyval.v.u8 = DIR_IN; }
break;
case 172:
#line 1759 "parse.y"
{ yyval.v.u8 = DIR_OUT; }
break;
case 173:
#line 1762 "parse.y"
{ yyval.v.filter_rib = NULL; }
break;
case 174:
#line 1763 "parse.y"
{ yyval.v.filter_rib = yyvsp[0].v.filter_rib; }
break;
case 175:
#line 1764 "parse.y"
{ yyval.v.filter_rib = yyvsp[-2].v.filter_rib; }
break;
case 176:
#line 1766 "parse.y"
{ yyval.v.filter_rib = yyvsp[0].v.filter_rib; }
break;
case 177:
#line 1767 "parse.y"
{
			yyvsp[0].v.filter_rib->next = yyvsp[-2].v.filter_rib;
			yyval.v.filter_rib = yyvsp[0].v.filter_rib;
		}
break;
case 178:
#line 1773 "parse.y"
{
			if (!find_rib(yyvsp[0].v.string)) {
				yyerror("rib \"%s\" does not exist.", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if ((yyval.v.filter_rib = calloc(1, sizeof(struct filter_rib_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_rib->next = NULL;
			if (strlcpy(yyval.v.filter_rib->name, yyvsp[0].v.string, sizeof(yyval.v.filter_rib->name)) >=
			    sizeof(yyval.v.filter_rib->name)) {
				yyerror("rib name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string, sizeof(yyval.v.filter_rib->name) - 1);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_rib);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 180:
#line 1796 "parse.y"
{ yyval.v.filter_peers = yyvsp[-2].v.filter_peers; }
break;
case 181:
#line 1799 "parse.y"
{ yyval.v.filter_peers = yyvsp[0].v.filter_peers; }
break;
case 182:
#line 1800 "parse.y"
{
			yyvsp[0].v.filter_peers->next = yyvsp[-2].v.filter_peers;
			yyval.v.filter_peers = yyvsp[0].v.filter_peers;
		}
break;
case 183:
#line 1806 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.peerid = yyval.v.filter_peers->p.groupid = 0;
			yyval.v.filter_peers->next = NULL;
		}
break;
case 184:
#line 1813 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.remote_as = yyval.v.filter_peers->p.groupid = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			TAILQ_FOREACH(p, new_peers, entry)
				if (!memcmp(&p->conf.remote_addr,
				    &yyvsp[0].v.addr, sizeof(p->conf.remote_addr))) {
					yyval.v.filter_peers->p.peerid = p->conf.id;
					break;
				}
			if (yyval.v.filter_peers->p.peerid == 0) {
				yyerror("no such peer: %s", log_addr(&yyvsp[0].v.addr));
				free(yyval.v.filter_peers);
				YYERROR;
			}
		}
break;
case 185:
#line 1833 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.groupid = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->p.remote_as = yyvsp[0].v.number;
		}
break;
case 186:
#line 1840 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.remote_as = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			TAILQ_FOREACH(p, new_peers, entry)
				if (!strcmp(p->conf.group, yyvsp[0].v.string)) {
					yyval.v.filter_peers->p.groupid = p->conf.groupid;
					break;
				}
			if (yyval.v.filter_peers->p.groupid == 0) {
				yyerror("no such group: \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_peers);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 187:
#line 1861 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.ebgp = 1;
		}
break;
case 188:
#line 1867 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.ibgp = 1;
		}
break;
case 189:
#line 1875 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op == OP_NONE) {
				yyvsp[0].v.prefixlen.op = OP_RANGE;
				yyvsp[0].v.prefixlen.len_min = 0;
				yyvsp[0].v.prefixlen.len_max = -1;
			}
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_prefix->p.addr.aid = AID_INET;
			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 190:
#line 1890 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op == OP_NONE) {
				yyvsp[0].v.prefixlen.op = OP_RANGE;
				yyvsp[0].v.prefixlen.len_min = 0;
				yyvsp[0].v.prefixlen.len_max = -1;
			}
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_prefix->p.addr.aid = AID_INET6;
			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 191:
#line 1905 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 192:
#line 1906 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 194:
#line 1910 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 195:
#line 1912 "parse.y"
{
			struct filter_prefix_l  *p;

			/* merge, both can be lists */
			for (p = yyvsp[-2].v.filter_prefix; p != NULL && p->next != NULL; p = p->next)
				;       /* nothing */
			if (p != NULL)
				p->next = yyvsp[0].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[-2].v.filter_prefix;
		}
break;
case 196:
#line 1923 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 197:
#line 1924 "parse.y"
{
			yyvsp[0].v.filter_prefix->next = yyvsp[-2].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[0].v.filter_prefix;
		}
break;
case 198:
#line 1930 "parse.y"
{
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			memcpy(&yyval.v.filter_prefix->p.addr, &yyvsp[-1].v.prefix.prefix,
			    sizeof(yyval.v.filter_prefix->p.addr));
			yyval.v.filter_prefix->p.len = yyvsp[-1].v.prefix.len;

			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 200:
#line 1946 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 202:
#line 1950 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 203:
#line 1962 "parse.y"
{
			yyval.v.filter_as = yyvsp[0].v.filter_as;
			yyval.v.filter_as->a.type = yyvsp[-1].v.u8;
		}
break;
case 204:
#line 1966 "parse.y"
{
			struct filter_as_l	*a;

			yyval.v.filter_as = yyvsp[-1].v.filter_as;
			for (a = yyval.v.filter_as; a != NULL; a = a->next)
				a->a.type = yyvsp[-3].v.u8;
		}
break;
case 205:
#line 1973 "parse.y"
{
			if (as_sets_lookup(conf->as_sets, yyvsp[0].v.string) == NULL) {
				yyerror("as-set \"%s\" not defined", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.type = yyvsp[-2].v.u8;
			yyval.v.filter_as->a.flags = AS_FLAG_AS_SET_NAME;
			if (strlcpy(yyval.v.filter_as->a.name, yyvsp[0].v.string, sizeof(yyval.v.filter_as->a.name)) >=
			    sizeof(yyval.v.filter_as->a.name)) {
				yyerror("as-set name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string, sizeof(yyval.v.filter_as->a.name) - 1);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_as);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 207:
#line 1997 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 208:
#line 1999 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 210:
#line 2012 "parse.y"
{
			yyvsp[0].v.filter_as->next = yyvsp[-2].v.filter_as;
			yyval.v.filter_as = yyvsp[0].v.filter_as;
		}
break;
case 211:
#line 2018 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.as_min = yyvsp[0].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
			yyval.v.filter_as->a.op = OP_EQ;
		}
break;
case 212:
#line 2026 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.flags = AS_FLAG_NEIGHBORAS;
		}
break;
case 213:
#line 2032 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.op = yyvsp[-1].v.u8;
			yyval.v.filter_as->a.as_min = yyvsp[0].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
		}
break;
case 214:
#line 2040 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			if (yyvsp[-2].v.number >= yyvsp[0].v.number) {
				yyerror("start AS is bigger than end");
				YYERROR;
			}
			yyval.v.filter_as->a.op = yyvsp[-1].v.u8;
			yyval.v.filter_as->a.as_min = yyvsp[-2].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
		}
break;
case 215:
#line 2054 "parse.y"
{
			bzero(&yyval.v.filter_match, sizeof(yyval.v.filter_match));
		}
break;
case 216:
#line 2057 "parse.y"
{
			bzero(&fmopts, sizeof(fmopts));
		}
break;
case 217:
#line 2060 "parse.y"
{
			memcpy(&yyval.v.filter_match, &fmopts, sizeof(yyval.v.filter_match));
		}
break;
case 220:
#line 2069 "parse.y"
{
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified");
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("\"prefix-set\" already specified, "
				    "cannot be used with \"prefix\" in the "
				    "same filter rule");
				YYERROR;
			}
			fmopts.prefix_l = yyvsp[0].v.filter_prefix;
		}
break;
case 221:
#line 2082 "parse.y"
{
			if (fmopts.as_l != NULL) {
				yyerror("AS filters already specified");
				YYERROR;
			}
			fmopts.as_l = yyvsp[0].v.filter_as;
		}
break;
case 222:
#line 2089 "parse.y"
{
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad max-as-len %lld", yyvsp[0].v.number);
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_MAX;
			fmopts.m.aslen.aslen = yyvsp[0].v.number;
		}
break;
case 223:
#line 2101 "parse.y"
{
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad max-as-seq %lld", yyvsp[0].v.number);
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_SEQ;
			fmopts.m.aslen.aslen = yyvsp[0].v.number;
		}
break;
case 224:
#line 2113 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].type ==
				    COMMUNITY_TYPE_NONE)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parsecommunity(&fmopts.m.community[i], yyvsp[-1].v.u8, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 225:
#line 2132 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].type ==
				    COMMUNITY_TYPE_NONE)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 226:
#line 2155 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].type ==
				    COMMUNITY_TYPE_NONE)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    "ovs", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 227:
#line 2175 "parse.y"
{
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.addr = yyvsp[0].v.addr;
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_ADDR;
		}
break;
case 228:
#line 2183 "parse.y"
{
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_NEIGHBOR;
		}
break;
case 229:
#line 2190 "parse.y"
{
			struct prefixset *ps;
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified, cannot "
				    "be used with \"prefix-set\" in the same "
				    "filter rule");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("prefix-set filter already specified");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if ((ps = find_prefixset(yyvsp[-1].v.string, &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (strlcpy(fmopts.m.prefixset.name, yyvsp[-1].v.string,
			    sizeof(fmopts.m.prefixset.name)) >=
			    sizeof(fmopts.m.prefixset.name)) {
				yyerror("prefix-set name too long");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!(yyvsp[0].v.prefixlen.op == OP_NONE ||
			    (yyvsp[0].v.prefixlen.op == OP_RANGE &&
			     yyvsp[0].v.prefixlen.len_min == -1 && yyvsp[0].v.prefixlen.len_max == -1))) {
				yyerror("prefix-sets can only use option "
				    "or-longer");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (yyvsp[0].v.prefixlen.op == OP_RANGE && ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s contains prefixlen "
				    "operators and cannot be used with an "
				    "or-longer filter", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (yyvsp[0].v.prefixlen.op == OP_RANGE && yyvsp[0].v.prefixlen.len_min == -1 &&
			    yyvsp[0].v.prefixlen.len_min == -1)
				fmopts.m.prefixset.flags |=
				    PREFIXSET_FLAG_LONGER;
			fmopts.m.prefixset.flags |= PREFIXSET_FLAG_FILTER;
			free(yyvsp[-1].v.string);
		}
break;
case 230:
#line 2239 "parse.y"
{
			if (fmopts.m.originset.name[0] != '\0') {
				yyerror("origin-set filter already specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (find_prefixset(yyvsp[0].v.string, &conf->originsets) == NULL) {
				yyerror("origin-set '%s' not defined", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(fmopts.m.originset.name, yyvsp[0].v.string,
			    sizeof(fmopts.m.originset.name)) >=
			    sizeof(fmopts.m.originset.name)) {
				yyerror("origin-set name too long");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 231:
#line 2259 "parse.y"
{
			if (fmopts.m.ovs.is_set) {
				yyerror("ovs filter already specified");
				YYERROR;
			}
			fmopts.m.ovs.validity = yyvsp[0].v.number;
			fmopts.m.ovs.is_set = 1;
		}
break;
case 232:
#line 2269 "parse.y"
{ bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen)); }
break;
case 233:
#line 2270 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			yyval.v.prefixlen.op = OP_RANGE;
			yyval.v.prefixlen.len_min = -1;
			yyval.v.prefixlen.len_max = -1;
		}
break;
case 234:
#line 2276 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}

			yyval.v.prefixlen.op = OP_RANGE;
			yyval.v.prefixlen.len_min = -1;
			yyval.v.prefixlen.len_max = yyvsp[0].v.number;
		}
break;
case 235:
#line 2287 "parse.y"
{
			int min, max;

			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}
			/*
			 * convert the unary operation into the equivalent
			 * range check
			 */
			yyval.v.prefixlen.op = OP_RANGE;

			switch (yyvsp[-1].v.u8) {
			case OP_NE:
				yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			case OP_EQ:
				min = max = yyvsp[0].v.number;
				break;
			case OP_LT:
				if (yyvsp[0].v.number == 0) {
					yyerror("prefixlen must be > 0");
					YYERROR;
				}
				yyvsp[0].v.number -= 1;
			case OP_LE:
				min = -1;
				max = yyvsp[0].v.number;
				break;
			case OP_GT:
				yyvsp[0].v.number += 1;
			case OP_GE:
				min = yyvsp[0].v.number;
				max = -1;
				break;
			default:
				yyerror("unknown prefixlen operation");
				YYERROR;
			}
			yyval.v.prefixlen.len_min = min;
			yyval.v.prefixlen.len_max = max;
		}
break;
case 236:
#line 2330 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[-2].v.number < 0 || yyvsp[-2].v.number > 128 || yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			if (yyvsp[-2].v.number > yyvsp[0].v.number) {
				yyerror("start prefixlen is bigger than end");
				YYERROR;
			}
			yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			yyval.v.prefixlen.len_min = yyvsp[-2].v.number;
			yyval.v.prefixlen.len_max = yyvsp[0].v.number;
		}
break;
case 237:
#line 2346 "parse.y"
{ yyval.v.u8 = AS_ALL; }
break;
case 238:
#line 2347 "parse.y"
{ yyval.v.u8 = AS_SOURCE; }
break;
case 239:
#line 2348 "parse.y"
{ yyval.v.u8 = AS_TRANSIT; }
break;
case 240:
#line 2349 "parse.y"
{ yyval.v.u8 = AS_PEER; }
break;
case 241:
#line 2352 "parse.y"
{ yyval.v.filter_set_head = NULL; }
break;
case 242:
#line 2353 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 243:
#line 2360 "parse.y"
{ yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head; }
break;
case 244:
#line 2363 "parse.y"
{
			yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head;
			if (merge_filterset(yyval.v.filter_set_head, yyvsp[0].v.filter_set) == 1)
				YYERROR;
		}
break;
case 245:
#line 2368 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 246:
#line 2377 "parse.y"
{ yyval.v.u8 = COMMUNITY_TYPE_BASIC; }
break;
case 247:
#line 2378 "parse.y"
{ yyval.v.u8 = COMMUNITY_TYPE_LARGE; }
break;
case 248:
#line 2381 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 249:
#line 2382 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 250:
#line 2385 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad localpref %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_LOCALPREF;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 251:
#line 2400 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad localpref +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 252:
#line 2410 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad localpref -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 253:
#line 2420 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad metric %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_MED;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 254:
#line 2435 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 255:
#line 2445 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 256:
#line 2455 "parse.y"
{	/* alias for MED */
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad metric %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_MED;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 257:
#line 2470 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 258:
#line 2480 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 259:
#line 2490 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad weight %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number > 0) {
				yyval.v.filter_set->type = ACTION_SET_WEIGHT;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 260:
#line 2505 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad weight +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 261:
#line 2515 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad weight -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 262:
#line 2525 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP;
			memcpy(&yyval.v.filter_set->action.nexthop, &yyvsp[0].v.addr,
			    sizeof(yyval.v.filter_set->action.nexthop));
		}
break;
case 263:
#line 2532 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_BLACKHOLE;
		}
break;
case 264:
#line 2537 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_REJECT;
		}
break;
case 265:
#line 2542 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_NOMODIFY;
		}
break;
case 266:
#line 2547 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_SELF;
		}
break;
case 267:
#line 2552 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_SELF;
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 268:
#line 2562 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_PEER;
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 269:
#line 2572 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_AS_OVERRIDE;
		}
break;
case 270:
#line 2577 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_PFTABLE;
			if (!(cmd_opts & BGPD_OPT_NOACTION) &&
			    pftable_exists(yyvsp[0].v.string) != 0) {
				yyerror("pftable name does not exist");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			if (strlcpy(yyval.v.filter_set->action.pftable, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.pftable)) >=
			    sizeof(yyval.v.filter_set->action.pftable)) {
				yyerror("pftable name too long");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			if (pftable_add(yyvsp[0].v.string) != 0) {
				yyerror("Couldn't register table");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 271:
#line 2604 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_RTLABEL;
			if (strlcpy(yyval.v.filter_set->action.rtlabel, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.rtlabel)) >=
			    sizeof(yyval.v.filter_set->action.rtlabel)) {
				yyerror("rtlabel name too long");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 272:
#line 2618 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-1].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parsecommunity(&yyval.v.filter_set->action.community, yyvsp[-2].v.u8, yyvsp[0].v.string) ==
			    -1) {
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			/* Don't allow setting of any match */
			if (!yyvsp[-1].v.u8 &&
			    (yyval.v.filter_set->action.community.dflag1 == COMMUNITY_ANY ||
			    yyval.v.filter_set->action.community.dflag2 == COMMUNITY_ANY ||
			    yyval.v.filter_set->action.community.dflag3 == COMMUNITY_ANY)) {
				yyerror("'*' is not allowed in set community");
				free(yyval.v.filter_set);
				YYERROR;
			}
		}
break;
case 273:
#line 2643 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-2].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&yyval.v.filter_set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 274:
#line 2661 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-2].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&yyval.v.filter_set->action.community,
			    "ovs", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 275:
#line 2677 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_ORIGIN;
			yyval.v.filter_set->action.origin = yyvsp[0].v.number;
		}
break;
case 276:
#line 2685 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "egp"))
				yyval.v.number = ORIGIN_EGP;
			else if (!strcmp(yyvsp[0].v.string, "igp"))
				yyval.v.number = ORIGIN_IGP;
			else if (!strcmp(yyvsp[0].v.string, "incomplete"))
				yyval.v.number = ORIGIN_INCOMPLETE;
			else {
				yyerror("unknown origin \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 277:
#line 2700 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "not-found"))
				yyval.v.number = ROA_NOTFOUND;
			else if (!strcmp(yyvsp[0].v.string, "invalid"))
				yyval.v.number = ROA_INVALID;
			else if (!strcmp(yyvsp[0].v.string, "valid"))
				yyval.v.number = ROA_VALID;
			else {
				yyerror("unknown validity \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 284:
#line 2725 "parse.y"
{ yyval.v.u8 = OP_EQ; }
break;
case 285:
#line 2726 "parse.y"
{ yyval.v.u8 = OP_NE; }
break;
case 286:
#line 2727 "parse.y"
{ yyval.v.u8 = OP_LE; }
break;
case 287:
#line 2728 "parse.y"
{ yyval.v.u8 = OP_LT; }
break;
case 288:
#line 2729 "parse.y"
{ yyval.v.u8 = OP_GE; }
break;
case 289:
#line 2730 "parse.y"
{ yyval.v.u8 = OP_GT; }
break;
case 290:
#line 2733 "parse.y"
{ yyval.v.u8 = OP_EQ; }
break;
case 291:
#line 2734 "parse.y"
{ yyval.v.u8 = OP_NE; }
break;
case 292:
#line 2737 "parse.y"
{ yyval.v.u8 = OP_RANGE; }
break;
case 293:
#line 2738 "parse.y"
{ yyval.v.u8 = OP_XRANGE; }
break;
#line 6127 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
