/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.engine.mvn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import lucee.loader.engine.mvn.MavenUpdateProvider;
import lucee.loader.util.Util;
import lucee.runtime.util.XMLUtilImpl;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RepoReader
extends DefaultHandler {
    private XMLReader xmlReader;
    private Stack<String> tree = new Stack();
    private StringBuilder content = new StringBuilder();
    private String repo;
    private String group;
    private String artifact;
    private Version version;
    private String key;
    private boolean insideSnapshotVersion;
    private Map<String, Object> snapshot;
    private Map<String, Map<String, Object>> snapshots = new HashMap<String, Map<String, Object>>();
    private String base;

    RepoReader(String repo, String group, String artifact, Version version) {
        this.repo = repo;
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.key = repo + ":" + group + ":" + artifact + ":" + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> read() throws IOException, GeneralSecurityException, SAXException {
        String g = this.group.replace('.', '/');
        String a = this.artifact.replace('.', '/');
        String v = this.version.toString();
        this.base = this.repo + (this.repo.endsWith("/") ? "" : "/") + g + "/" + a + "/" + v + "/";
        URL url = new URL(this.base + "maven-metadata.xml");
        HttpURLConnection conn = MavenUpdateProvider.get(url);
        if (conn != null) {
            int sc = conn.getResponseCode();
            if (sc < 200 || sc >= 300) {
                throw new IOException("unable to invoke [" + url + "], status code [" + sc + "]");
            }
        } else {
            throw new IOException("unable to invoke [" + this.repo + "], no response.");
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.init(new InputSource(r));
        }
        catch (Throwable throwable) {
            Util.closeEL(r);
            throw throwable;
        }
        Util.closeEL(r);
        return this.snapshots;
    }

    private void init(InputSource is) throws SAXException, IOException {
        this.xmlReader = new XMLUtilImpl().createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setErrorHandler(this);
        this.xmlReader.parse(is);
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.tree.add(qName);
        if ("snapshotVersion".equals(name)) {
            this.insideSnapshotVersion = true;
            this.snapshot = new HashMap<String, Object>();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String tmp;
        if (this.insideSnapshotVersion && !Util.isEmpty(tmp = this.content.toString(), true)) {
            this.snapshot.put(name, tmp.trim());
        }
        if ("snapshotVersion".equals(name)) {
            this.insideSnapshotVersion = false;
            String classifier = MavenUpdateProvider.toString(this.snapshot.get("classifier"), "");
            String extension = MavenUpdateProvider.toString(this.snapshot.get("extension"), "");
            String value = MavenUpdateProvider.toString(this.snapshot.get("value"), "");
            String key = Util.isEmpty(classifier) ? extension : classifier + "." + extension;
            this.snapshot.put("url", this.base + this.artifact + "-" + value + "." + extension);
            this.snapshots.put(key, this.snapshot);
            this.snapshot = null;
        }
        this.content.delete(0, this.content.length());
        this.tree.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.content.append(ch, start, length);
    }
}

