/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantArtifactSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentMetadata, LocalComponentMetadata>
implements LocalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final ConcurrentMap<String, DefaultLocalConfigurationGraphResolveState> configurations = new ConcurrentHashMap<String, DefaultLocalConfigurationGraphResolveState>();
    private final Lazy<Optional<List<? extends VariantGraphResolveState>>> allVariantsForGraphResolution = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(variant -> this.getConfiguration(variant.getName()).asVariant()).collect(Collectors.toList())));
    private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariantsForArtifactSelection = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(LocalConfigurationGraphResolveMetadata.class::cast).map(LocalConfigurationGraphResolveMetadata::prepareToResolveArtifacts).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet())));
    private final Lazy<List<ResolvedVariantResult>> selectableVariantResults;

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator) {
        super(instanceId, metadata, metadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.selectableVariantResults = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().orElse(Collections.emptyList()).stream().map(LocalConfigurationGraphResolveMetadata.class::cast).flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList()));
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public LocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        return ((LocalComponentMetadata)this.getMetadata()).copy(componentIdentifier, artifacts);
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new LocalComponentArtifactResolveMetadata((LocalComponentMetadata)this.getMetadata());
    }

    @Override
    public ModuleSources getSources() {
        return ((LocalComponentMetadata)this.getMetadata()).getSources();
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return (List)this.selectableVariantResults.get();
    }

    @Override
    protected Optional<List<? extends VariantGraphResolveState>> getVariantsForGraphTraversal() {
        return (Optional)this.allVariantsForGraphResolution.get();
    }

    @Override
    @Nullable
    public ConfigurationGraphResolveState getConfiguration(String configurationName) {
        return this.configurations.computeIfAbsent(configurationName, n -> {
            LocalConfigurationMetadata configuration = ((LocalComponentMetadata)this.getMetadata()).getConfiguration(configurationName);
            if (configuration == null) {
                return null;
            }
            return new DefaultLocalConfigurationGraphResolveState(this.idGenerator.nextVariantId(), (LocalComponentMetadata)this.getMetadata(), configuration, this.allVariantsForArtifactSelection);
        });
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final LocalComponentMetadata metadata;

        public LocalComponentArtifactResolveMetadata(LocalComponentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class LocalVariantArtifactSelectionCandidates
    implements VariantArtifactSelectionCandidates {
        private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants;
        private final Set<? extends VariantResolveMetadata> legacyVariants;

        public LocalVariantArtifactSelectionCandidates(Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants, Set<? extends VariantResolveMetadata> legacyVariants) {
            this.allVariants = allVariants;
            this.legacyVariants = legacyVariants;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getAllVariants() {
            return ((Optional)this.allVariants.get()).orElse(this.legacyVariants);
        }

        @Override
        public Set<? extends VariantResolveMetadata> getLegacyVariants() {
            return this.legacyVariants;
        }
    }

    private static class DefaultLocalConfigurationArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final LocalComponentMetadata component;
        private final LocalConfigurationGraphResolveMetadata graphSelectedConfiguration;
        private final Set<? extends VariantResolveMetadata> legacyVariants;
        private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants;

        public DefaultLocalConfigurationArtifactResolveState(LocalComponentMetadata component, LocalConfigurationGraphResolveMetadata graphSelectedConfiguration, Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariantsForArtifactSelection, Set<? extends VariantResolveMetadata> legacyVariants) {
            this.component = component;
            this.graphSelectedConfiguration = graphSelectedConfiguration;
            this.legacyVariants = legacyVariants;
            this.allVariants = allVariantsForArtifactSelection;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedConfiguration.prepareToResolveArtifacts().getArtifacts();
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            return this.graphSelectedConfiguration.prepareToResolveArtifacts().artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            return artifactSelector.resolveArtifacts(new LocalComponentArtifactResolveMetadata(this.component), new LocalVariantArtifactSelectionCandidates(this.allVariants, this.legacyVariants), exclusions, overriddenAttributes);
        }
    }

    private class DefaultLocalConfigurationGraphResolveState
    extends AbstractComponentGraphResolveState.AbstractVariantGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final LocalConfigurationMetadata configuration;
        private final Lazy<DefaultLocalConfigurationArtifactResolveState> artifactResolveState;

        public DefaultLocalConfigurationGraphResolveState(long instanceId, LocalComponentMetadata component, LocalConfigurationMetadata configuration, Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariantsForArtifactSelection) {
            super(DefaultLocalComponentGraphResolveState.this);
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = Lazy.atomic().of(() -> {
                Set<? extends VariantResolveMetadata> legacyVariants = configuration.prepareToResolveArtifacts().getVariants();
                return new DefaultLocalConfigurationArtifactResolveState(component, configuration, allVariantsForArtifactSelection, legacyVariants);
            });
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            return (VariantArtifactGraphResolveMetadata)this.artifactResolveState.get();
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

