/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class AbstractTypeAnnotationHandler
implements TypeAnnotationHandler {
    private final Class<? extends Annotation> annotationType;

    protected AbstractTypeAnnotationHandler(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    protected static void reportInvalidUseOfTypeAnnotation(Class<?> classWithAnnotationAttached, TypeValidationContext visitor, Class<? extends Annotation> annotationType, Class<?> ... appliesOnlyTo) {
        visitor.visitTypeProblem((Action<? super TypeProblemBuilder>)((Action)problem -> ((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)problem.forType(classWithAnnotationAttached).reportAs(Severity.ERROR)).withId(ValidationProblemId.INVALID_USE_OF_TYPE_ANNOTATION)).withDescription(() -> "is incorrectly annotated with @" + annotationType.getSimpleName())).happensBecause(() -> String.format("This annotation only makes sense on %s types", Arrays.stream(appliesOnlyTo).map(Class::getSimpleName).collect(Collectors.joining(", "))))).documentedAt("validation_problems", "invalid_use_of_cacheable_annotation")).addPossibleSolution("Remove the annotation")));
    }
}

