/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class TradeRouteTest
extends FreeColTestCase {
    private static final GoodsType fursGoodsType = TradeRouteTest.spec().getGoodsType("model.goods.furs");
    private static final TileType mixedForestType = TradeRouteTest.spec().getTileType("model.tile.mixedForest");
    private static final UnitType caravel = TradeRouteTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType wagonTrainType = TradeRouteTest.spec().getUnitType("model.unit.wagonTrain");

    public void testTradeRoute() {
        Game game = TradeRouteTest.getGame();
        game.changeMap(TradeRouteTest.getTestMap(mixedForestType, true));
        Colony colony1 = this.getStandardColony(4, 1, 1);
        Colony colony2 = this.getStandardColony(4, 3, 1);
        Colony colony3 = this.getStandardColony(4, 5, 1);
        Tile tile1 = colony1.getTile();
        Tile tile2 = colony2.getTile();
        Tile tile3 = colony3.getTile();
        TradeRouteTest.assertEquals((Object)mixedForestType, (Object)tile1.getType());
        TradeRouteTest.assertEquals((Object)mixedForestType, (Object)tile2.getType());
        TradeRouteTest.assertEquals((Object)mixedForestType, (Object)tile3.getType());
        Player player = colony1.getOwner();
        ServerUnit wagon = new ServerUnit(game, tile1, player, wagonTrainType);
        wagon.setLocation(tile1);
        TradeRouteTest.assertEquals((int)2, (int)wagon.getTurnsToReach(colony2));
        TradeRouteTest.assertEquals((int)4, (int)wagon.getTurnsToReach(colony3));
        wagon.setLocation(tile2);
        TradeRouteTest.assertEquals((int)2, (int)wagon.getTurnsToReach(colony1));
        TradeRouteTest.assertEquals((int)2, (int)wagon.getTurnsToReach(colony3));
        wagon.setLocation(tile3);
        TradeRouteTest.assertEquals((int)4, (int)wagon.getTurnsToReach(colony1));
        TradeRouteTest.assertEquals((int)2, (int)wagon.getTurnsToReach(colony2));
        wagon.setLocation(tile1);
        TradeRoute tr = new TradeRoute(game, "TR", player);
        TradeRouteTest.assertNotNull((Object)tr);
        TradeRouteTest.assertNotNull((Object)tr.verify());
        TradeRouteTest.assertEquals((int)0, (int)tr.getStopCount());
        TradeRouteStop trs1 = new TradeRouteStop(game, colony1);
        TradeRouteTest.assertTrue((boolean)trs1.isValid(player));
        tr.addStop(trs1);
        TradeRouteTest.assertNotNull((Object)tr.verify());
        TradeRouteStop trs2 = new TradeRouteStop(game, colony2);
        TradeRouteTest.assertTrue((boolean)trs2.isValid(player));
        tr.addStop(trs2);
        TradeRouteTest.assertNotNull((Object)tr.verify());
        trs1.addCargo(fursGoodsType);
        TradeRouteTest.assertNull((Object)tr.verify());
        trs2.addCargo(fursGoodsType);
        TradeRouteTest.assertNotNull((Object)tr.verify());
        TradeRouteStop trs3 = new TradeRouteStop(game, colony3);
        TradeRouteTest.assertTrue((boolean)trs3.isValid(player));
        tr.addStop(trs3);
        TradeRouteTest.assertNull((Object)tr.verify());
        wagon.setTradeRoute(tr);
        int ex = 50;
        TradeRouteTest.assertEquals((int)200, (int)wagon.getLoadableAmount(fursGoodsType));
        TradeRouteTest.assertEquals((int)0, (int)colony1.getGoodsCount(fursGoodsType));
        TradeRouteTest.assertEquals((int)0, (int)colony2.getGoodsCount(fursGoodsType));
        TradeRouteTest.assertEquals((int)0, (int)colony3.getGoodsCount(fursGoodsType));
        colony1.getExportData(fursGoodsType).setExportLevel(50).setExported(true);
        colony2.getExportData(fursGoodsType).setExportLevel(50).setExported(true);
        colony3.getExportData(fursGoodsType).setExportLevel(50).setExported(true);
        TradeRouteTest.assertEquals((int)0, (int)colony1.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)0, (int)colony2.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)0, (int)colony3.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)0, (int)trs1.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)0, (int)trs2.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)0, (int)trs3.getExportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)100, (int)trs1.getImportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)100, (int)trs2.getImportAmount(fursGoodsType, 0));
        TradeRouteTest.assertEquals((int)100, (int)trs3.getImportAmount(fursGoodsType, 0));
        TradeRouteTest.assertFalse((boolean)trs1.hasWork(wagon, 0));
        TradeRouteTest.assertFalse((boolean)trs2.hasWork(wagon, 0));
        TradeRouteTest.assertFalse((boolean)trs3.hasWork(wagon, 0));
        wagon.addGoods(fursGoodsType, 10);
        TradeRouteTest.assertFalse((boolean)trs1.hasWork(wagon, 0));
        TradeRouteTest.assertFalse((boolean)trs2.hasWork(wagon, 0));
        TradeRouteTest.assertTrue((boolean)trs3.hasWork(wagon, 0));
        wagon.removeGoods(fursGoodsType);
        TradeRouteTest.assertFalse((boolean)trs1.hasWork(wagon, 0));
        TradeRouteTest.assertFalse((boolean)trs2.hasWork(wagon, 2));
        TradeRouteTest.assertFalse((boolean)trs3.hasWork(wagon, 4));
        colony1.getExportData(fursGoodsType).setExportLevel(0);
        colony2.getExportData(fursGoodsType).setExportLevel(0);
        colony3.getExportData(fursGoodsType).setExportLevel(0);
        TradeRouteTest.assertFalse((boolean)trs1.hasWork(wagon, 0));
        TradeRouteTest.assertTrue((boolean)trs2.hasWork(wagon, 2));
        TradeRouteTest.assertFalse((boolean)trs3.hasWork(wagon, 4));
        wagon.addGoods(fursGoodsType, 10);
        TradeRouteTest.assertTrue((boolean)trs3.hasWork(wagon, 4));
        wagon.removeGoods(fursGoodsType);
    }
}

