/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.util.HashMap;
import java.util.Iterator;
import jde.debugger.Debugger;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.JDEbug;
import jde.debugger.Protocol;
import jde.debugger.command.CommandHandler;
import jde.debugger.command.SessionCommandHandler;

public class SessionManager
implements Protocol {
    private HashMap m_debuggers = new HashMap();
    private SessionCommandHandler m_handler = new SessionCommandHandler();
    private static SessionManager s_theManager = new SessionManager();
    private static long s_nextObjectID = 0L;

    private SessionManager() {
        this.m_handler.start();
    }

    private synchronized CommandHandler p_getCommandHandler(Integer procID) throws JDEException {
        if (procID.equals(JDEbug.debuggerID)) {
            return this.m_handler;
        }
        Debugger debugger = (Debugger)this.m_debuggers.get(procID);
        if (debugger == null) {
            throw new JDEException("No process with id " + procID + " found");
        }
        return debugger.getCommandHandler();
    }

    private synchronized Debugger p_getDebugger(Integer procID) throws JDEException {
        Debugger debugger = (Debugger)this.m_debuggers.get(procID);
        if (debugger == null) {
            throw new JDEException("No debugger for process id " + procID + " found");
        }
        return debugger;
    }

    private synchronized void p_registerDebugger(Debugger debugger) throws JDEException {
        Integer procID = debugger.getProcID();
        if (this.m_debuggers.containsKey(procID)) {
            throw new JDEException("registerDebugger: A process with id " + procID + " already exists!");
        }
        this.m_debuggers.put(procID, debugger);
        JDE.debug(4, "registered debugger with procid: " + procID);
    }

    private synchronized void p_deregisterDebugger(Debugger debugger) throws JDEException {
        Integer procID = debugger.getProcID();
        if (null != this.m_debuggers) {
            if (!this.m_debuggers.containsKey(procID)) {
                throw new JDEException("deregisterDebugger: No process with id " + procID + " exists!");
            }
            if (debugger.isValid()) {
                throw new JDEException("INTERNAL ERROR: an attempt was made at deregistering a valid debugger. The debugger must be shut down first.");
            }
            this.m_debuggers.remove(procID);
        }
        JDE.debug(4, "removed debugger with procid: " + procID);
    }

    private synchronized void p_shutdown() {
        if (this.m_handler != null) {
            this.m_handler.requestStop();
        }
        if (this.m_debuggers != null) {
            Iterator iter = this.m_debuggers.values().iterator();
            while (iter.hasNext()) {
                Debugger dbgr = (Debugger)iter.next();
                try {
                    dbgr.shutdown();
                }
                catch (JDEException e) {
                    JDE.signal(dbgr.getProcID(), "error", "SessionManager.p_shutdown() caught exception when shutting down debugger: " + e, true);
                }
            }
        }
        if (null != this.m_debuggers) {
            this.m_debuggers.clear();
        }
        this.m_debuggers = null;
        this.m_handler = null;
    }

    public static CommandHandler getCommandHandler(Integer procID) throws JDEException {
        return s_theManager.p_getCommandHandler(procID);
    }

    public static Debugger getDebugger(Integer procID) throws JDEException {
        return s_theManager.p_getDebugger(procID);
    }

    public static void registerDebugger(Debugger debugger) throws JDEException {
        s_theManager.p_registerDebugger(debugger);
    }

    public static void deregisterDebugger(Debugger debugger) throws JDEException {
        s_theManager.p_deregisterDebugger(debugger);
    }

    public static void shutdown() {
        s_theManager.p_shutdown();
    }

    public static synchronized Long generateObjectID() {
        return new Long(s_nextObjectID++);
    }
}

