/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;

public abstract class VariantAbstractQuery
implements Variant {
    private List<NameValuePair> listParam = Collections.emptyList();
    private List<String> originalNames = Collections.emptyList();
    private boolean addQueryParam;

    protected abstract void buildMessage(HttpMessage var1, String var2);

    protected abstract String getEscapedValue(HttpMessage var1, String var2);

    protected String getEscapedName(HttpMessage msg, String name) {
        return name != null ? AbstractPlugin.getURLEncode(name) : "";
    }

    protected abstract String getUnescapedValue(String var1);

    @Deprecated
    protected void setParams(int type, Map<String, String> params) {
        int i = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            this.listParam.add(new NameValuePair(type, param.getKey(), this.getUnescapedValue(param.getValue()), i));
            ++i;
        }
    }

    protected void setParameters(int type, List<org.zaproxy.zap.model.NameValuePair> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters must not be null.");
        }
        int size = parameters.isEmpty() ? 1 : parameters.size();
        this.listParam = new ArrayList<NameValuePair>(size);
        this.originalNames = new ArrayList<String>(size);
        HashMap<String, MutableInt> arraysMap = new HashMap<String, MutableInt>();
        int i = 0;
        for (org.zaproxy.zap.model.NameValuePair parameter : parameters) {
            String originalName = VariantAbstractQuery.nonNullString(parameter.getName());
            this.originalNames.add(originalName);
            String name = VariantAbstractQuery.isParamArray(originalName) ? this.getArrayName(originalName, arraysMap) : originalName;
            this.listParam.add(new NameValuePair(type, name, VariantAbstractQuery.nonNullString(parameter.getValue()), i));
            ++i;
        }
        if (i == 0 && this.addQueryParam) {
            String param = "query";
            this.listParam.add(new NameValuePair(type, param, param, i));
            this.originalNames.add(param);
        }
    }

    private static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private String getArrayName(String originalName, Map<String, MutableInt> arraysMap) {
        MutableInt count = arraysMap.get(originalName);
        if (count == null) {
            count = new MutableInt();
            arraysMap.put(originalName, count);
        }
        String arrayName = originalName.substring(0, originalName.length() - 2) + "[" + count + "]";
        count.increment();
        return arrayName;
    }

    private static boolean isParamArray(String name) {
        return name.endsWith("[]");
    }

    @Override
    public List<NameValuePair> getParamList() {
        return Collections.unmodifiableList(this.listParam);
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        ParameterParser parser = originalPair.getType() == 2 ? Model.getSingleton().getSession().getFormParamParser(msg.getRequestHeader().getURI().toString()) : (originalPair.getType() == 1 ? Model.getSingleton().getSession().getUrlParamParser(msg.getRequestHeader().getURI().toString()) : new StandardParameterParser());
        StringBuilder sb = new StringBuilder();
        String encodedValue = escaped ? value : this.getEscapedValue(msg, value);
        for (int i = 0; i < this.getParamList().size(); ++i) {
            NameValuePair pair = this.getParamList().get(i);
            String origName = this.originalNames.get(i);
            boolean isAppended = i == originalPair.getPosition() ? this.paramAppend(sb, this.getEscapedName(msg, pair.getName() == name ? origName : name), encodedValue, parser) : this.paramAppend(sb, this.getEscapedName(msg, origName), this.getEscapedValue(msg, pair.getValue()), parser);
            if (!isAppended || i >= this.getParamList().size() - 1) continue;
            sb.append(parser.getDefaultKeyValuePairSeparator());
        }
        if (sb.length() == 0) {
            sb.append(encodedValue);
        }
        String query = sb.toString();
        this.buildMessage(msg, query);
        return query;
    }

    private boolean paramAppend(StringBuilder sb, String name, String value, ParameterParser parser) {
        boolean isEdited = false;
        if (name != null) {
            sb.append(name);
            isEdited = true;
        }
        if (value != null) {
            sb.append(parser.getDefaultKeyValueSeparator());
            sb.append(value);
            isEdited = true;
        }
        return isEdited;
    }

    public void setAddQueryParam(boolean addQueryParam) {
        this.addQueryParam = addQueryParam;
    }
}

