/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropView(SessionLocal sessionLocal, Schema schema) {
        super(sessionLocal, schema);
        this.dropAction = this.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    @Override
    public long update() {
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.VIEW != table.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkSchemaOwner(table.getSchema());
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                for (DbObject dbObject : table.getChildren()) {
                    if (!(dbObject instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, dbObject.getName());
                }
            }
            table.lock(this.session, 2);
            Database database = this.getDatabase();
            database.removeSchemaObject(this.session, table);
            database.unlockMeta(this.session);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 48;
    }
}

