/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.state.StateTransitionListener;

public abstract class MultiStateTransitionListener<OPERAND, EVENT, STATE extends Enum<STATE>>
implements StateTransitionListener<OPERAND, EVENT, STATE> {
    private final List<StateTransitionListener<OPERAND, EVENT, STATE>> listeners = new ArrayList<StateTransitionListener<OPERAND, EVENT, STATE>>();

    public void addListener(StateTransitionListener<OPERAND, EVENT, STATE> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void preTransition(OPERAND op, STATE beforeState, EVENT eventToBeProcessed) {
        for (StateTransitionListener<OPERAND, EVENT, STATE> listener : this.listeners) {
            listener.preTransition(op, beforeState, eventToBeProcessed);
        }
    }

    @Override
    public void postTransition(OPERAND op, STATE beforeState, STATE afterState, EVENT processedEvent) {
        for (StateTransitionListener<OPERAND, EVENT, STATE> listener : this.listeners) {
            listener.postTransition(op, beforeState, afterState, processedEvent);
        }
    }
}

