/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.GsonContentAdapter;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import java.lang.reflect.Type;

class GsonChatMessageAdapter
implements JsonDeserializer<ChatMessage>,
JsonSerializer<ChatMessage> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Content.class, (Object)new GsonContentAdapter()).registerTypeAdapter(TextContent.class, (Object)new GsonContentAdapter()).registerTypeAdapter(ImageContent.class, (Object)new GsonContentAdapter()).registerTypeAdapter(AudioContent.class, (Object)new GsonContentAdapter()).registerTypeAdapter(VideoContent.class, (Object)new GsonContentAdapter()).registerTypeAdapter(PdfFileContent.class, (Object)new GsonContentAdapter()).create();
    private static final String CHAT_MESSAGE_TYPE = "type";

    GsonChatMessageAdapter() {
    }

    public JsonElement serialize(ChatMessage chatMessage, Type ignored, JsonSerializationContext context) {
        JsonObject messageJsonObject = GSON.toJsonTree((Object)chatMessage).getAsJsonObject();
        messageJsonObject.addProperty(CHAT_MESSAGE_TYPE, chatMessage.type().toString());
        return messageJsonObject;
    }

    public ChatMessage deserialize(JsonElement messageJsonElement, Type ignored, JsonDeserializationContext context) {
        String chatMessageTypeString = messageJsonElement.getAsJsonObject().get(CHAT_MESSAGE_TYPE).getAsString();
        ChatMessageType chatMessageType = ChatMessageType.valueOf(chatMessageTypeString);
        ChatMessage chatMessage = (ChatMessage)GSON.fromJson(messageJsonElement, chatMessageType.messageClass());
        if (chatMessage instanceof UserMessage && ((UserMessage)chatMessage).contents() == null) {
            chatMessage = UserMessage.from(messageJsonElement.getAsJsonObject().get("text").getAsString());
        }
        return chatMessage;
    }
}

