/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.CreateCoreSnapshotResponse;
import org.apache.solr.client.api.model.ListCoreSnapshotsResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CoreSnapshotsApi {

    public static class ListSnapshots1
    extends SolrRequest<ListSnapshots1Response> {
        private final String coreName;

        public ListSnapshots1(String coreName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/snapshots".replace("{coreName}", coreName));
            this.coreName = coreName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ListSnapshots1Response createResponse(SolrClient client) {
            return new ListSnapshots1Response();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListSnapshots1Response
    extends JacksonParsingResponse<ListCoreSnapshotsResponse> {
        public ListSnapshots1Response() {
            super(ListCoreSnapshotsResponse.class);
        }
    }

    public static class DeleteSnapshot
    extends SolrRequest<DeleteSnapshotResponse> {
        private final String coreName;
        private final String snapshotName;
        private String async;

        public DeleteSnapshot(String coreName, String snapshotName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/cores/{coreName}/snapshots/{snapshotName}".replace("{coreName}", coreName).replace("{snapshotName}", snapshotName));
            this.coreName = coreName;
            this.snapshotName = snapshotName;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteSnapshotResponse createResponse(SolrClient client) {
            return new DeleteSnapshotResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteSnapshotResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.DeleteSnapshotResponse> {
        public DeleteSnapshotResponse() {
            super(org.apache.solr.client.api.model.DeleteSnapshotResponse.class);
        }
    }

    public static class CreateSnapshot
    extends SolrRequest<CreateSnapshotResponse> {
        private final String coreName;
        private final String snapshotName;
        private String async;

        public CreateSnapshot(String coreName, String snapshotName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/snapshots/{snapshotName}".replace("{coreName}", coreName).replace("{snapshotName}", snapshotName));
            this.coreName = coreName;
            this.snapshotName = snapshotName;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected CreateSnapshotResponse createResponse(SolrClient client) {
            return new CreateSnapshotResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateSnapshotResponse
    extends JacksonParsingResponse<CreateCoreSnapshotResponse> {
        public CreateSnapshotResponse() {
            super(CreateCoreSnapshotResponse.class);
        }
    }
}

