/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.GitActionIdsHolder;
import git4idea.commit.signing.GpgAgentConfigurator;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurationNotificator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "proposeCustomPinentryAgentConfiguration", "", "isSuggestion", "", "notifyConfigurationSuccessful", "paths", "Lgit4idea/commit/signing/GpgAgentPaths;", "notifyConfigurationFailed", "exception", "", "GpgAgentConfiguratorNotification", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGpgAgentConfigurationNotificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,110:1\n31#2,2:111\n31#2,2:113\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator\n*L\n34#1:111,2\n45#1:113,2\n*E\n"})
public final class GpgAgentConfigurationNotificator {
    @NotNull
    private final Project project;

    public GpgAgentConfigurationNotificator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @RequiresBackgroundThread
    public final void proposeCustomPinentryAgentConfiguration(boolean isSuggestion) {
        GpgAgentConfiguratorNotification gpgAgentConfiguratorNotification;
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        if (!GpgAgentConfigurator.Companion.isEnabled(this.project, executable)) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GpgAgentConfigurator> serviceClass$iv = GpgAgentConfigurator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((GpgAgentConfigurator)object).isConfigured(this.project)) {
            return;
        }
        String displayId = isSuggestion ? "git.gpg.agent.configuration.propose" : "git.gpg.agent.configuration.propose.suggestion";
        String string = GitBundle.message("pgp.pinentry.configuration.proposal.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message("pgp.pinentry.configuration.proposal.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GpgAgentConfiguratorNotification $this$proposeCustomPinentryAgentConfiguration_u24lambda_u242 = gpgAgentConfiguratorNotification = new GpgAgentConfiguratorNotification(this, displayId, string, string2, null, isSuggestion, 8, null);
        boolean bl = false;
        String configureActionId = isSuggestion ? GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_SUGGESTION_CONFIGURE.id : GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_CONFIGURE.id;
        $this$proposeCustomPinentryAgentConfiguration_u24lambda_u242.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("pgp.pinentry.configuration.proposal.configure", new Object[0]), (String)configureActionId, () -> GpgAgentConfigurationNotificator.proposeCustomPinentryAgentConfiguration$lambda$2$lambda$0($this$proposeCustomPinentryAgentConfiguration_u24lambda_u242, this)));
        String manualActionId = isSuggestion ? GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_SUGGESTION_MANUAL.id : GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_MANUAL.id;
        $this$proposeCustomPinentryAgentConfiguration_u24lambda_u242.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("gpg.error.see.documentation.link.text", new Object[0]), (String)manualActionId, GpgAgentConfigurationNotificator::proposeCustomPinentryAgentConfiguration$lambda$2$lambda$1));
        gpgAgentConfiguratorNotification.notifyExpirePrevious(this.project);
    }

    public final void notifyConfigurationSuccessful(@NotNull GpgAgentPaths paths) {
        GpgAgentConfiguratorNotification gpgAgentConfiguratorNotification;
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        String message = null;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(paths.getGpgAgentConfBackup(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            var3_3 = new Object[]{paths.getGpgAgentConfBackup()};
            message = GitBundle.message("pgp.pinentry.configured.successfully.backup.message", var3_3);
        } else {
            var3_3 = new Object[]{paths.getGpgAgentConf()};
            message = GitBundle.message("pgp.pinentry.configured.successfully.message", var3_3);
        }
        String displayId = "git.gpg.agent.configuration.success";
        String string = GitBundle.message("pgp.pinentry.configured.successfully.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GpgAgentConfiguratorNotification $this$notifyConfigurationSuccessful_u24lambda_u244 = gpgAgentConfiguratorNotification = new GpgAgentConfiguratorNotification(this, displayId, string, message, NotificationType.INFORMATION, false, 16, null);
        boolean bl = false;
        $this$notifyConfigurationSuccessful_u24lambda_u244.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("gpg.error.see.documentation.link.text", new Object[0]), (String)GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_SUCCESS_MANUAL.id, GpgAgentConfigurationNotificator::notifyConfigurationSuccessful$lambda$4$lambda$3));
        gpgAgentConfiguratorNotification.notifyExpirePrevious(this.project);
    }

    public final void notifyConfigurationFailed(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = exception.getMessage();
        if (string == null) {
            return;
        }
        String exceptionMessage = string;
        String string2 = new HtmlBuilder().append(HtmlChunk.text((String)exceptionMessage)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String message = string2;
        String string3 = GitBundle.message("pgp.pinentry.configuration.error.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        new GpgAgentConfiguratorNotification(this, "git.gpg.agent.configuration.error", string3, message, NotificationType.ERROR, false, 16, null).notifyExpirePrevious(this.project);
    }

    private static final void proposeCustomPinentryAgentConfiguration$lambda$2$lambda$0(GpgAgentConfiguratorNotification $this_apply, GpgAgentConfigurationNotificator this$0) {
        $this_apply.expire();
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<GpgAgentConfigurator> serviceClass$iv = GpgAgentConfigurator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GpgAgentConfigurator)object).configure();
    }

    private static final void proposeCustomPinentryAgentConfiguration$lambda$2$lambda$1() {
        HelpManager.getInstance().invokeHelp(GitBundle.message("gpg.pinentry.jb.manual.link", new Object[0]));
    }

    private static final void notifyConfigurationSuccessful$lambda$4$lambda$3() {
        HelpManager.getInstance().invokeHelp(GitBundle.message("gpg.pinentry.jb.manual.link", new Object[0]));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification;", "Lcom/intellij/notification/Notification;", "displayId", "", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "type", "Lcom/intellij/notification/NotificationType;", "isSuggestion", "", "<init>", "(Lgit4idea/commit/signing/GpgAgentConfigurationNotificator;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/notification/NotificationType;Z)V", "notifyExpirePrevious", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGpgAgentConfigurationNotificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n3829#2:111\n4344#2,2:112\n1863#3,2:114\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification\n*L\n103#1:111\n103#1:112,2\n104#1:114,2\n*E\n"})
    private final class GpgAgentConfiguratorNotification
    extends Notification {
        final /* synthetic */ GpgAgentConfigurationNotificator this$0;

        public GpgAgentConfiguratorNotification(@NotNull GpgAgentConfigurationNotificator this$0, @NotNull String displayId, @NotNull String title, @NotNull String content, NotificationType type, boolean isSuggestion) {
            Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.this$0 = this$0;
            super(VcsNotifier.importantNotification().getDisplayId(), title, content, type);
            this.setDisplayId(displayId);
            this.setSuggestionType(isSuggestion);
        }

        public /* synthetic */ GpgAgentConfiguratorNotification(GpgAgentConfigurationNotificator gpgAgentConfigurationNotificator, String string, String string2, String string3, NotificationType notificationType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                notificationType = NotificationType.INFORMATION;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(gpgAgentConfigurationNotificator, string, string2, string3, notificationType, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void notifyExpirePrevious(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GpgAgentConfigurationNotificator gpgAgentConfigurationNotificator = this.this$0;
            synchronized (gpgAgentConfigurationNotificator) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                boolean bl = false;
                Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(GpgAgentConfiguratorNotification.class, project);
                Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
                Object[] objectArray = notificationArray;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    GpgAgentConfiguratorNotification notification = (GpgAgentConfiguratorNotification)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)notification.getDisplayId(), (Object)this.getDisplayId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GpgAgentConfiguratorNotification p0 = (GpgAgentConfiguratorNotification)((Object)element$iv);
                    boolean bl3 = false;
                    boolean $i$f$notifyExpirePrevious$lambda$1$stub_for_inlining = false;
                    p0.expire();
                }
                this.notify(project);
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

