/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.RequestorsKt;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionProviderBase;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitNewBranchOptions;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitBranchValidatorKt;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u000389:Be\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0002J\u001d\u0010#\u001a\u0017\u0012\u0013\u0012\u00110\b\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\b'0$H\u0002J\u001d\u0010(\u001a\u0017\u0012\u0013\u0012\u00110\b\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\b'0$H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+2\u0006\u0010,\u001a\u00020\u000bH\u0002J1\u0010-\u001a\u001b\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u000200\u0012\u0006\u0012\u0004\u0018\u0001010.\u00a2\u0006\u0002\b22\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0002J\f\u00106\u001a\u000207*\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lgit4idea/branch/GitNewBranchDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "dialogTitle", "", "initialName", "showCheckOutOption", "", "showResetOption", "showSetTrackingOption", "localConflictsAllowed", "operation", "Lgit4idea/branch/GitBranchOperationType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;ZZZZLgit4idea/branch/GitBranchOperationType;)V", "checkout", "reset", "tracking", "branchName", "validator", "Lgit4idea/validators/GitRefNameValidator;", "kotlin.jvm.PlatformType", "Lgit4idea/validators/GitRefNameValidator;", "localBranchDirectories", "", "showAndGetOptions", "Lgit4idea/branch/GitNewBranchOptions;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createBranchNameCompletion", "Lgit4idea/branch/GitNewBranchDialog$BranchNamesCompletion;", "collectLocalBranchNames", "Lkotlin/sequences/Sequence;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "collectRemoteBranchNames", "collectDirectories", "branchNames", "", "withTrailingSlash", "validateBranchName", "Lkotlin/Function2;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lkotlin/ExtensionFunctionType;", "onApply", "overwriteCheckbox", "Ljavax/swing/JCheckBox;", "cleanBranchNameAndAdjustCursorIfNeeded", "", "Companion", "BranchNamesCompletion", "HasConflictingLocalBranchPredicate", "intellij.vcs.git"})
public final class GitNewBranchDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    private final boolean showCheckOutOption;
    private final boolean showResetOption;
    private final boolean showSetTrackingOption;
    private final boolean localConflictsAllowed;
    @NotNull
    private final GitBranchOperationType operation;
    private boolean checkout;
    private boolean reset;
    private boolean tracking;
    @NotNull
    private String branchName;
    private final GitRefNameValidator validator;
    @NotNull
    private final Set<String> localBranchDirectories;
    private static final char NAME_SEPARATOR = '/';

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption, boolean localConflictsAllowed, @NotNull GitBranchOperationType operation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        super(project, true);
        this.project = project;
        this.repositories = repositories;
        this.showCheckOutOption = showCheckOutOption;
        this.showResetOption = showResetOption;
        this.showSetTrackingOption = showSetTrackingOption;
        this.localConflictsAllowed = localConflictsAllowed;
        this.operation = operation;
        this.checkout = true;
        this.tracking = this.showSetTrackingOption;
        String string = initialName;
        if (string == null) {
            string = "";
        }
        this.branchName = string;
        this.validator = GitRefNameValidator.getInstance();
        this.localBranchDirectories = CollectionsKt.toSet((Iterable)this.collectDirectories(SequencesKt.asIterable(this.collectLocalBranchNames()), false));
        this.setTitle(dialogTitle);
        this.setOKButtonText(this.operation.getText());
        this.init();
        if (((CharSequence)this.branchName).length() > 0) {
            this.initValidation();
        }
    }

    public /* synthetic */ GitNewBranchDialog(Project project, Collection collection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, GitBranchOperationType gitBranchOperationType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        if ((n & 0x100) != 0) {
            gitBranchOperationType = bl ? GitBranchOperationType.CREATE : GitBranchOperationType.CHECKOUT;
        }
        this(project, collection, string, string2, bl, bl2, bl3, bl4, gitBranchOperationType);
    }

    @Nullable
    public final GitNewBranchOptions showAndGetOptions() {
        if (!this.showAndGet()) {
            return null;
        }
        String string = this.validator.cleanUpBranchName(this.branchName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanUpBranchName(...)");
        return new GitNewBranchOptions(((Object)StringsKt.trim((CharSequence)string)).toString(), this.checkout, this.reset, this.tracking);
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel(arg_0 -> GitNewBranchDialog.createCenterPanel$lambda$5(this, arg_0));
    }

    private final BranchNamesCompletion createBranchNameCompletion() {
        Sequence<String> localBranches2 = this.collectLocalBranchNames();
        Sequence<String> remoteBranches2 = this.collectRemoteBranchNames();
        Collection<String> localDirectories = this.collectDirectories(SequencesKt.asIterable(localBranches2), true);
        Collection<String> remoteDirectories = this.collectDirectories(SequencesKt.asIterable(remoteBranches2), true);
        Set allSuggestions = new LinkedHashSet();
        CollectionsKt.addAll((Collection)allSuggestions, localBranches2);
        CollectionsKt.addAll((Collection)allSuggestions, remoteBranches2);
        CollectionsKt.addAll((Collection)allSuggestions, (Iterable)localDirectories);
        CollectionsKt.addAll((Collection)allSuggestions, (Iterable)remoteDirectories);
        return new BranchNamesCompletion(CollectionsKt.toList((Iterable)localDirectories), CollectionsKt.toList((Iterable)allSuggestions));
    }

    private final Sequence<String> collectLocalBranchNames() {
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.repositories), GitNewBranchDialog::collectLocalBranchNames$lambda$6), GitNewBranchDialog::collectLocalBranchNames$lambda$7);
    }

    private final Sequence<String> collectRemoteBranchNames() {
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.repositories), GitNewBranchDialog::collectRemoteBranchNames$lambda$8), GitNewBranchDialog::collectRemoteBranchNames$lambda$9);
    }

    private final Collection<String> collectDirectories(Iterable<String> branchNames, boolean withTrailingSlash) {
        Set directories = new LinkedHashSet();
        for (String branchName : branchNames) {
            int end;
            if (!StringsKt.contains$default((CharSequence)branchName, (char)'/', (boolean)false, (int)2, null)) continue;
            int index = 0;
            while (index < branchName.length() && (end = StringsKt.indexOf$default((CharSequence)branchName, (char)'/', (int)index, (boolean)false, (int)4, null)) != -1) {
                String string;
                Collection collection = directories;
                if (withTrailingSlash) {
                    String string2 = branchName.substring(0, end + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    String string3 = branchName.substring(0, end);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
                collection.add(string);
                index = end + 1;
            }
        }
        return directories;
    }

    private final Function2<ValidationInfoBuilder, TextFieldWithCompletion, ValidationInfo> validateBranchName(boolean onApply, JCheckBox overwriteCheckbox) {
        return (arg_0, arg_1) -> GitNewBranchDialog.validateBranchName$lambda$11(this, onApply, overwriteCheckbox, arg_0, arg_1);
    }

    private final void cleanBranchNameAndAdjustCursorIfNeeded(TextFieldWithCompletion $this$cleanBranchNameAndAdjustCursorIfNeeded) {
        if (this.isDisposed()) {
            return;
        }
        String string = $this$cleanBranchNameAndAdjustCursorIfNeeded.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String initialText = string;
        int initialCaret = $this$cleanBranchNameAndAdjustCursorIfNeeded.getCaretModel().getOffset();
        String string2 = this.validator.cleanUpBranchNameOnTyping(initialText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cleanUpBranchNameOnTyping(...)");
        String fixedText = string2;
        if (Intrinsics.areEqual((Object)fixedText, (Object)initialText)) {
            return;
        }
        String initialTextBeforeCaret = StringsKt.take((String)initialText, (int)initialCaret);
        String string3 = this.validator.cleanUpBranchNameOnTyping(initialTextBeforeCaret);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cleanUpBranchNameOnTyping(...)");
        String fixedTextBeforeCaret = string3;
        int fixedCaret = fixedTextBeforeCaret.length();
        $this$cleanBranchNameAndAdjustCursorIfNeeded.setText(fixedText);
        $this$cleanBranchNameAndAdjustCursorIfNeeded.getCaretModel().moveToOffset(fixedCaret);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption, boolean localConflictsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories, dialogTitle, initialName, showCheckOutOption, showResetOption, showSetTrackingOption, localConflictsAllowed, null, 256, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories, dialogTitle, initialName, showCheckOutOption, showResetOption, showSetTrackingOption, false, null, 384, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories, dialogTitle, initialName, showCheckOutOption, showResetOption, false, false, null, 448, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories, dialogTitle, initialName, showCheckOutOption, false, false, false, null, 480, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories, dialogTitle, initialName, false, false, false, false, null, 496, null);
    }

    private static final String createCenterPanel$lambda$5$lambda$3$lambda$0(TextFieldWithCompletion c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        String string = c.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$3$lambda$1(TextFieldWithCompletion c, String v) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        c.setText(v);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$3$lambda$2(TextFieldWithCompletion $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.selectAll();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$3(TextFieldWithCompletion $branchNameField, GitNewBranchDialog this$0, JCheckBox $overwriteCheckbox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.cell((JComponent)$branchNameField).bind(GitNewBranchDialog::createCenterPanel$lambda$5$lambda$3$lambda$0, GitNewBranchDialog::createCenterPanel$lambda$5$lambda$3$lambda$1, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return GitNewBranchDialog.access$getBranchName$p((GitNewBranchDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                GitNewBranchDialog.access$setBranchName$p((GitNewBranchDialog)((Object)this.receiver), (String)value);
            }
        }))).align((Align)AlignX.FILL.INSTANCE);
        String string = GitBundle.message("new.branch.dialog.branch.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).focused().applyToComponent(GitNewBranchDialog::createCenterPanel$lambda$5$lambda$3$lambda$2).validationRequestor(RequestorsKt.getWHEN_STATE_CHANGED().invoke((Object)$overwriteCheckbox)).validationRequestor(RequestorsKt.getWHEN_DOCUMENT_CHANGED()).validationOnApply(this$0.validateBranchName(true, $overwriteCheckbox)).validationOnInput(this$0.validateBranchName(false, $overwriteCheckbox));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4(GitNewBranchDialog this$0, JCheckBox $overwriteCheckbox, TextFieldWithCompletion $branchNameField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if (this$0.showCheckOutOption) {
            String string = GitBundle.message("new.branch.dialog.checkout.branch.checkbox", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GitNewBranchDialog.access$getCheckout$p((GitNewBranchDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GitNewBranchDialog.access$setCheckout$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
        }
        if (this$0.showResetOption) {
            ButtonKt.bindSelected((Cell)$this$row.cell((JComponent)$overwriteCheckbox), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GitNewBranchDialog.access$getReset$p((GitNewBranchDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GitNewBranchDialog.access$setReset$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                }
            })).enabledIf((ComponentPredicate)this$0.new HasConflictingLocalBranchPredicate((EditorTextField)$branchNameField)).getComponent();
        }
        if (this$0.showSetTrackingOption) {
            String string = GitBundle.message("new.branch.dialog.set.tracking.branch.checkbox", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GitNewBranchDialog.access$getTracking$p((GitNewBranchDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GitNewBranchDialog.access$setTracking$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                }
            })).getComponent();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5(GitNewBranchDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        JCheckBox overwriteCheckbox = new JCheckBox(GitBundle.message("new.branch.dialog.overwrite.existing.branch.checkbox", new Object[0]));
        TextFieldWithCompletion branchNameField = new TextFieldWithCompletion(this$0.project, (TextCompletionProvider)this$0.createBranchNameCompletion(), this$0.branchName, true, true, false, false);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitNewBranchDialog.createCenterPanel$lambda$5$lambda$3(branchNameField, this$0, overwriteCheckbox, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitNewBranchDialog.createCenterPanel$lambda$5$lambda$4(this$0, overwriteCheckbox, branchNameField, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Iterable collectLocalBranchNames$lambda$6(GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection<GitLocalBranch> collection = it.getBranches().getLocalBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalBranches(...)");
        return collection;
    }

    private static final String collectLocalBranchNames$lambda$7(GitLocalBranch it) {
        return it.getName();
    }

    private static final Iterable collectRemoteBranchNames$lambda$8(GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection<GitRemoteBranch> collection = it.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemoteBranches(...)");
        return collection;
    }

    private static final String collectRemoteBranchNames$lambda$9(GitRemoteBranch it) {
        return it.getNameForRemoteOperations();
    }

    private static final Unit validateBranchName$lambda$11$lambda$10(GitNewBranchDialog this$0, TextFieldWithCompletion $it) {
        this$0.cleanBranchNameAndAdjustCursorIfNeeded($it);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo validateBranchName$lambda$11(GitNewBranchDialog this$0, boolean $onApply, JCheckBox $overwriteCheckbox, ValidationInfoBuilder validationInfoBuilder, TextFieldWithCompletion it) {
        ValidationInfo validationInfo;
        ValidationInfo errorInfo;
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ActionsKt.invokeLater$default(null, () -> GitNewBranchDialog.validateBranchName$lambda$11$lambda$10(this$0, it), (int)1, null);
        String string = this$0.validator.cleanUpBranchName(it.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanUpBranchName(...)");
        String branchName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        ValidationInfo validationInfo2 = $onApply ? GitBranchValidatorKt.checkRefNameEmptyOrHead(branchName) : null;
        if (validationInfo2 == null && (validationInfo2 = GitBranchValidatorKt.conflictsWithRemoteBranch(this$0.repositories, branchName)) == null) {
            validationInfo2 = GitBranchValidatorKt.conflictsWithLocalBranchDirectory(this$0.localBranchDirectories, branchName);
        }
        ValidationInfo validationInfo3 = errorInfo = validationInfo2;
        if (validationInfo3 != null) {
            String string2 = validationInfo3.message;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message");
            validationInfo = validationInfoBuilder.error(string2);
        } else {
            ValidationInfo localBranchConflict = GitBranchValidatorKt.conflictsWithLocalBranch(this$0.repositories, branchName);
            if (localBranchConflict == null || $overwriteCheckbox.isSelected()) {
                validationInfo = null;
            } else if (localBranchConflict.warning && this$0.localConflictsAllowed) {
                String string3 = new HtmlBuilder().append(localBranchConflict.message + ".").br().append(this$0.operation.getDescription()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                validationInfo = validationInfoBuilder.warning(string3);
            } else if (this$0.showResetOption) {
                String string4 = new HtmlBuilder().append(localBranchConflict.message + ".").br().append(GitBundle.message("new.branch.dialog.overwrite.existing.branch.warning", new Object[0])).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                validationInfo = validationInfoBuilder.error(string4);
            } else {
                String string5 = localBranchConflict.message;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message");
                validationInfo = validationInfoBuilder.error(string5);
            }
        }
        return validationInfo;
    }

    public static final /* synthetic */ String access$getBranchName$p(GitNewBranchDialog $this) {
        return $this.branchName;
    }

    public static final /* synthetic */ void access$setBranchName$p(GitNewBranchDialog $this, String string) {
        $this.branchName = string;
    }

    public static final /* synthetic */ boolean access$getCheckout$p(GitNewBranchDialog $this) {
        return $this.checkout;
    }

    public static final /* synthetic */ void access$setCheckout$p(GitNewBranchDialog $this, boolean bl) {
        $this.checkout = bl;
    }

    public static final /* synthetic */ boolean access$getReset$p(GitNewBranchDialog $this) {
        return $this.reset;
    }

    public static final /* synthetic */ void access$setReset$p(GitNewBranchDialog $this, boolean bl) {
        $this.reset = bl;
    }

    public static final /* synthetic */ boolean access$getTracking$p(GitNewBranchDialog $this) {
        return $this.tracking;
    }

    public static final /* synthetic */ void access$setTracking$p(GitNewBranchDialog $this, boolean bl) {
        $this.tracking = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lgit4idea/branch/GitNewBranchDialog$BranchNamesCompletion;", "Lcom/intellij/util/textCompletion/TextCompletionProviderBase;", "", "Lcom/intellij/openapi/project/DumbAware;", "localDirectories", "", "allSuggestions", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getLocalDirectories", "()Ljava/util/List;", "getAllSuggestions", "getValues", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.vcs.git"})
    private static final class BranchNamesCompletion
    extends TextCompletionProviderBase<String>
    implements DumbAware {
        @NotNull
        private final List<String> localDirectories;
        @NotNull
        private final List<String> allSuggestions;

        public BranchNamesCompletion(@NotNull List<String> localDirectories, @NotNull List<String> allSuggestions) {
            Intrinsics.checkNotNullParameter(localDirectories, (String)"localDirectories");
            Intrinsics.checkNotNullParameter(allSuggestions, (String)"allSuggestions");
            super((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), CollectionsKt.emptyList(), false);
            this.localDirectories = localDirectories;
            this.allSuggestions = allSuggestions;
        }

        @NotNull
        public final List<String> getLocalDirectories() {
            return this.localDirectories;
        }

        @NotNull
        public final List<String> getAllSuggestions() {
            return this.allSuggestions;
        }

        @NotNull
        protected Collection<String> getValues(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if (parameters.isAutoPopup()) {
                return this.localDirectories;
            }
            return this.allSuggestions;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/branch/GitNewBranchDialog$Companion;", "", "<init>", "()V", "NAME_SEPARATOR", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u000e\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lgit4idea/branch/GitNewBranchDialog$HasConflictingLocalBranchPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "branchNameField", "Lcom/intellij/ui/EditorTextField;", "<init>", "(Lgit4idea/branch/GitNewBranchDialog;Lcom/intellij/ui/EditorTextField;)V", "getBranchNameField", "()Lcom/intellij/ui/EditorTextField;", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.vcs.git"})
    private final class HasConflictingLocalBranchPredicate
    extends ComponentPredicate {
        @NotNull
        private final EditorTextField branchNameField;

        public HasConflictingLocalBranchPredicate(EditorTextField branchNameField) {
            Intrinsics.checkNotNullParameter((Object)branchNameField, (String)"branchNameField");
            this.branchNameField = branchNameField;
        }

        @NotNull
        public final EditorTextField getBranchNameField() {
            return this.branchNameField;
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.branchNameField.addDocumentListener(new DocumentListener(listener2, this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ HasConflictingLocalBranchPredicate this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
            });
        }

        @NotNull
        public Boolean invoke() {
            String string = GitNewBranchDialog.this.validator.cleanUpBranchName(this.branchNameField.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanUpBranchName(...)");
            String branchName = ((Object)StringsKt.trim((CharSequence)string)).toString();
            ValidationInfo localBranchConflict = GitBranchValidatorKt.conflictsWithLocalBranch(GitNewBranchDialog.this.repositories, branchName);
            return localBranchConflict != null;
        }
    }
}

