/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.cipher.CipherKt;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a8\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"gcmDecryptCipher", "Ljavax/crypto/Cipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "recordType", "Lio/ktor/network/tls/TLSRecordType;", "recordLength", "", "recordIv", "", "recordId", "gcmEncryptCipher", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nGCMCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCMCipher.kt\nio/ktor/network/tls/cipher/GCMCipherKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class GCMCipherKt {
    private static final Cipher gcmEncryptCipher(CipherSuite suite, byte[] keyMaterial2, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        byte[] byArray;
        Cipher cipher2 = Cipher.getInstance(suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher2);
        Cipher cipher3 = cipher2;
        SecretKeySpec key = KeysKt.clientKey(keyMaterial2, suite);
        byte[] fixedIv = KeysKt.clientIV(keyMaterial2, suite);
        byte[] byArray2 = Arrays.copyOf(fixedIv, suite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
        byte[] iv = byArray2;
        CipherKt.set(iv, suite.getFixedIvLength(), recordIv);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher3.init(1, (Key)key, gcmSpec);
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, recordId);
        it[8] = (byte)recordType.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)recordLength);
        byte[] aad = byArray;
        cipher3.updateAAD(aad);
        return cipher3;
    }

    private static final Cipher gcmDecryptCipher(CipherSuite suite, byte[] keyMaterial2, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        byte[] byArray;
        Cipher cipher2 = Cipher.getInstance(suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher2);
        Cipher cipher3 = cipher2;
        SecretKeySpec key = KeysKt.serverKey(keyMaterial2, suite);
        byte[] fixedIv = KeysKt.serverIV(keyMaterial2, suite);
        byte[] byArray2 = Arrays.copyOf(fixedIv, suite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
        byte[] iv = byArray2;
        CipherKt.set(iv, suite.getFixedIvLength(), recordIv);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher3.init(2, (Key)key, gcmSpec);
        int contentSize = recordLength - (suite.getIvLength() - suite.getFixedIvLength()) - suite.getCipherTagSizeInBytes();
        if (!(contentSize < 65536)) {
            boolean bl = false;
            String string = "Content size should fit in 2 bytes, actual: " + contentSize;
            throw new IllegalStateException(string.toString());
        }
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, recordId);
        it[8] = (byte)recordType.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)contentSize);
        byte[] aad = byArray;
        cipher3.updateAAD(aad);
        return cipher3;
    }

    public static final /* synthetic */ Cipher access$gcmEncryptCipher(CipherSuite suite, byte[] keyMaterial2, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        return GCMCipherKt.gcmEncryptCipher(suite, keyMaterial2, recordType, recordLength, recordIv, recordId);
    }

    public static final /* synthetic */ Cipher access$gcmDecryptCipher(CipherSuite suite, byte[] keyMaterial2, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        return GCMCipherKt.gcmDecryptCipher(suite, keyMaterial2, recordType, recordLength, recordIv, recordId);
    }
}

