/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(PrefixReferenceProvider.class);

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue value;
        String s;
        int i;
        if (element == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((i = (s = (value = (XmlAttributeValue)element).getValue()).indexOf(58)) <= 0 || s.startsWith("xml:")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PrefixReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PrefixReference(value, i)};
        if (psiReferenceArray == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class PrefixReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        PrefixReference(XmlAttributeValue value, int length) {
            super((PsiElement)value, TextRange.from((int)1, (int)length));
        }

        @Nullable
        public PsiElement resolve() {
            String prefix = this.getCanonicalText();
            for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); tag != null; tag = tag.getParentTag()) {
                if (!tag.getLocalNamespaceDeclarations().containsKey(prefix)) continue;
                XmlAttribute attribute = tag.getAttribute("xmlns:" + prefix, "");
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix);
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element) {
            PsiElement e;
            if (element == null) {
                PrefixReference.$$$reportNull$$$0(0);
            }
            if (element instanceof SchemaPrefix && element.getContainingFile() == this.myElement.getContainingFile() && (e = this.resolve()) instanceof SchemaPrefix) {
                String s = ((SchemaPrefix)e).getName();
                return s != null && s.equals(((SchemaPrefix)element).getName());
            }
            return super.isReferenceTo(element);
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            PsiElement element = this.getElement();
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)element.getProject());
            String value = ((XmlAttributeValue)element).getValue();
            String[] name = value.split(":");
            XmlTag tag = factory.createTagFromText((CharSequence)("<" + (name.length > 1 ? name[1] : value) + " />"), (Language)XMLLanguage.INSTANCE);
            return new LocalQuickFix[]{XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)tag, this.getCanonicalText(), null)};
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = RelaxngBundle.message("relaxng.annotator.unresolved-namespace-prefix", new Object[0]);
            if (string == null) {
                PrefixReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

