/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentPropertyBuilder
extends AbstractPropertyBuilder {
    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            IdentValue ident;
            PropertyValue value2 = values.get(0);
            if (value2.getCssValueType() == 0) {
                return Collections.emptyList();
            }
            if (value2.getPrimitiveType() == 21 && ((ident = this.checkIdent(CSSName.CONTENT, value2)) == IdentValue.NONE || ident == IdentValue.NORMAL)) {
                return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, value2, important, origin));
            }
        }
        ArrayList<PropertyValue> resultValues = new ArrayList<PropertyValue>();
        for (PropertyValue value3 : values) {
            if (value3.getOperator() != null) {
                throw new CSSParseException("Found unexpected operator, " + value3.getOperator().getExternalName(), -1);
            }
            short type2 = value3.getPrimitiveType();
            if (type2 == 20) {
                resultValues.add(value3);
                continue;
            }
            if (type2 == 19) {
                resultValues.add(value3);
                continue;
            }
            if (value3.getPropertyValueType() == 7) {
                if (!this.isFunctionAllowed(value3.getFunction())) {
                    throw new CSSParseException("Function " + value3.getFunction().getName() + " is not allowed here", -1);
                }
                resultValues.add(value3);
                continue;
            }
            if (type2 == 21) {
                IdentValue ident = this.checkIdent(CSSName.CONTENT, value3);
                if (ident == IdentValue.OPEN_QUOTE || ident == IdentValue.CLOSE_QUOTE || ident == IdentValue.NO_CLOSE_QUOTE || ident == IdentValue.NO_OPEN_QUOTE) {
                    resultValues.add(value3);
                    continue;
                }
                throw new CSSParseException("Identifier " + ident + " is not a valid value for the content property", -1);
            }
            throw new CSSParseException(value3.getCssText() + " is not a value value for the content property", -1);
        }
        if (resultValues.size() > 0) {
            return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, new PropertyValue(resultValues), important, origin));
        }
        return Collections.emptyList();
    }

    private boolean isFunctionAllowed(FSFunction function) {
        String name = function.getName();
        return name.equals("attr") || name.equals("counter") || name.equals("counters") || name.equals("element") || name.startsWith("-fs") || name.equals("target-counter") || name.equals("leader") || name.startsWith("target-text");
    }
}

