/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ShareProjectAction;

public class ShareWholeProject
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShareWholeProject.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShareWholeProject.$$$reportNull$$$0(1);
        }
        MyChecker checker = new MyChecker();
        checker.execute(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(checker.isEnabled());
        presentation.setVisible(checker.isVisible());
        if (checker.isEnabled()) {
            presentation.setText(SvnBundle.messagePointer("action.share.whole.project.text", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShareWholeProject.$$$reportNull$$$0(2);
        }
        MyChecker checker = new MyChecker();
        checker.execute(e);
        if (!checker.isEnabled()) {
            return;
        }
        Project project = checker.getProject();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return;
        }
        boolean success = false;
        boolean excThrown = false;
        try {
            success = ShareProjectAction.share(project, baseDir);
        }
        catch (VcsException exc) {
            AbstractVcsHelper.getInstance((Project)project).showError(exc, SvnBundle.message("tab.title.failed.to.share.project", new Object[0]));
            excThrown = true;
        }
        finally {
            if (success || excThrown) {
                baseDir.refresh(true, true, () -> ApplicationManager.getApplication().invokeLater(() -> {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(project.getBaseDir());
                    if (checker.isHadNoMappings() && SvnUtil.seemsLikeVersionedDir(baseDir)) {
                        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                        vcsManager.setDirectoryMappings(Collections.singletonList(VcsDirectoryMapping.createDefault((String)"svn")));
                    }
                }, ModalityState.nonModal(), project.getDisposed()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/ShareWholeProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/ShareWholeProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyChecker {
        private boolean myEnabled;
        private boolean myVisible;
        private Project myProject;
        private boolean myHadNoMappings;

        private MyChecker() {
        }

        public void execute(AnActionEvent e) {
            DataContext dataContext = e.getDataContext();
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (this.myProject == null || this.myProject.isDefault()) {
                return;
            }
            VirtualFile baseDir = this.myProject.getBaseDir();
            if (baseDir == null) {
                return;
            }
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            MyCheckResult result = MyChecker.checkMappings(baseDir, vcsManager);
            if (MyCheckResult.disable.equals((Object)result)) {
                return;
            }
            this.myHadNoMappings = MyCheckResult.notMapped.equals((Object)result);
            if (MyCheckResult.notMapped.equals((Object)result) ? SvnUtil.seemsLikeVersionedDir(baseDir) : SvnStatusUtil.isUnderControl(this.myProject, baseDir)) {
                return;
            }
            if (!this.myHadNoMappings && !SvnVcs.getInstance(this.myProject).getSvnFileUrlMapping().isEmpty()) {
                return;
            }
            this.myVisible = true;
            this.myEnabled = !vcsManager.isBackgroundVcsOperationRunning();
        }

        private static MyCheckResult checkMappings(VirtualFile baseDir, ProjectLevelVcsManager vcsManager) {
            List mappings = vcsManager.getDirectoryMappings();
            boolean notMapped = true;
            boolean svnMappedToBase = false;
            for (VcsDirectoryMapping mapping : mappings) {
                String vcs = mapping.getVcs();
                if (vcs.length() <= 0) continue;
                notMapped = false;
                if (!"svn".equals(vcs) || !mapping.isDefaultMapping() && !baseDir.getPath().equals(mapping.getDirectory())) continue;
                svnMappedToBase = true;
                break;
            }
            return svnMappedToBase ? MyCheckResult.rootToSvn : (notMapped ? MyCheckResult.notMapped : MyCheckResult.disable);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        public Project getProject() {
            return this.myProject;
        }

        public boolean isHadNoMappings() {
            return this.myHadNoMappings;
        }

        private static enum MyCheckResult {
            disable,
            notMapped,
            rootToSvn;

        }
    }
}

