/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigurationRuntimeConfig;
import io.quarkus.runtime.configuration.DisableableConfigSource;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.SmallRyeConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

@Recorder
public class ConfigRecorder {
    private static final Logger log = Logger.getLogger(ConfigRecorder.class);
    final ConfigurationRuntimeConfig configurationConfig;

    public ConfigRecorder(ConfigurationRuntimeConfig configurationConfig) {
        this.configurationConfig = configurationConfig;
    }

    public void handleConfigChange(Map<String, ConfigValue> buildTimeRuntimeValues) {
        ConfigSource configSource;
        ConfigSource configSource2;
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        Optional builtTimeRunTimeFixedConfigSource = config.getConfigSource("BuildTime RunTime Fixed");
        if (builtTimeRunTimeFixedConfigSource.isPresent() && (configSource2 = (ConfigSource)builtTimeRunTimeFixedConfigSource.get()) instanceof DisableableConfigSource) {
            ((DisableableConfigSource)configSource2).disable();
        }
        ArrayList<CallSite> mismatches = new ArrayList<CallSite>();
        for (Map.Entry<String, ConfigValue> entry : buildTimeRuntimeValues.entrySet()) {
            io.smallrye.config.ConfigValue currentValue = config.getConfigValue(entry.getKey());
            if (currentValue.getValue() == null || Objects.equals(entry.getValue().getValue(), currentValue.getValue()) || entry.getValue().getSourceOrdinal() >= currentValue.getSourceOrdinal()) continue;
            mismatches.add((CallSite)((Object)(" - " + entry.getKey() + " is set to '" + currentValue.getValue() + "' but it is build time fixed to '" + entry.getValue().getValue() + "'. Did you change the property " + entry.getKey() + " after building the application?")));
        }
        if (builtTimeRunTimeFixedConfigSource.isPresent() && (configSource = (ConfigSource)builtTimeRunTimeFixedConfigSource.get()) instanceof DisableableConfigSource) {
            ((DisableableConfigSource)configSource).enable();
        }
        if (!mismatches.isEmpty()) {
            String msg = "Build time property cannot be changed at runtime:\n" + String.join((CharSequence)"\n", mismatches);
            switch (this.configurationConfig.buildTimeMismatchAtRuntime) {
                case fail: {
                    throw new IllegalStateException(msg);
                }
                case warn: {
                    log.warn((Object)msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + ConfigurationRuntimeConfig.BuildTimeMismatchAtRuntime.class.getName() + ": " + String.valueOf((Object)this.configurationConfig.buildTimeMismatchAtRuntime));
                }
            }
        }
    }

    public void handleNativeProfileChange(List<String> buildProfiles) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        List runtimeProfiles = config.getProfiles();
        if (buildProfiles.size() != runtimeProfiles.size()) {
            log.warn((Object)("The profile '" + String.valueOf(buildProfiles) + "' used to build the native image is different from the runtime profile '" + String.valueOf(runtimeProfiles) + "'. This may lead to unexpected results."));
            return;
        }
        for (int i = 0; i < buildProfiles.size(); ++i) {
            String runtimeProfile;
            String buildProfile = buildProfiles.get(i);
            if (buildProfile.equals(runtimeProfile = (String)runtimeProfiles.get(i))) continue;
            log.warn((Object)("The profile '" + buildProfile + "' used to build the native image is different from the runtime profile '" + runtimeProfile + "'. This may lead to unexpected results."));
        }
    }

    public void unknownConfigFiles() throws Exception {
        ConfigDiagnostic.unknownConfigFiles(ConfigDiagnostic.configFilesFromLocations());
    }

    public void releaseConfig(ShutdownContext shutdownContext) {
        shutdownContext.addLastShutdownTask(QuarkusConfigFactory::releaseTCCLConfig);
    }
}

