/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoggedOutAuthentication;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredAuthentication
implements Authentication.Deferred {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredAuthentication.class);
    protected final LoginAuthenticator _authenticator;
    private Object _previousAssociation;
    static final HttpServletResponse __deferredResponse = new HttpServletResponse(){

        @Override
        public void addCookie(Cookie cookie) {
        }

        @Override
        public void addDateHeader(String name, long date) {
        }

        @Override
        public void addHeader(String name, String value2) {
        }

        @Override
        public void addIntHeader(String name, int value2) {
        }

        @Override
        public boolean containsHeader(String name) {
            return false;
        }

        @Override
        public String encodeRedirectURL(String url) {
            return null;
        }

        @Override
        @Deprecated(since="Servlet API 2.1")
        public String encodeRedirectUrl(String url) {
            return null;
        }

        @Override
        public String encodeURL(String url) {
            return null;
        }

        @Override
        @Deprecated(since="Servlet API 2.1")
        public String encodeUrl(String url) {
            return null;
        }

        @Override
        public void sendError(int sc) throws IOException {
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
        }

        @Override
        public void sendRedirect(String location) throws IOException {
        }

        @Override
        public void setDateHeader(String name, long date) {
        }

        @Override
        public void setHeader(String name, String value2) {
        }

        @Override
        public void setIntHeader(String name, int value2) {
        }

        @Override
        public void setStatus(int sc) {
        }

        @Override
        @Deprecated(since="Servlet API 2.1")
        public void setStatus(int sc, String sm) {
        }

        @Override
        public void flushBuffer() throws IOException {
        }

        @Override
        public int getBufferSize() {
            return 1024;
        }

        @Override
        public String getCharacterEncoding() {
            return null;
        }

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return __nullOut;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return IO.getNullPrintWriter();
        }

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public void reset() {
        }

        @Override
        public void resetBuffer() {
        }

        @Override
        public void setBufferSize(int size) {
        }

        @Override
        public void setCharacterEncoding(String charset) {
        }

        @Override
        public void setContentLength(int len) {
        }

        @Override
        public void setContentLengthLong(long len) {
        }

        @Override
        public void setContentType(String type2) {
        }

        @Override
        public void setLocale(Locale loc) {
        }

        @Override
        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }

        @Override
        public String getHeader(String arg0) {
            return null;
        }

        @Override
        public Collection<String> getHeaders(String arg0) {
            return Collections.emptyList();
        }

        @Override
        public int getStatus() {
            return 0;
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void print(String s2) throws IOException {
        }

        @Override
        public void println(String s2) throws IOException {
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
        }

        @Override
        public boolean isReady() {
            return false;
        }
    };

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    @Override
    public Authentication authenticate(ServletRequest request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, __deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                LoginService loginService = this._authenticator.getLoginService();
                IdentityService identityService = loginService.getIdentityService();
                if (identityService != null) {
                    this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
        }
        return this;
    }

    @Override
    public Authentication authenticate(ServletRequest request, ServletResponse response) {
        try {
            LoginService loginService = this._authenticator.getLoginService();
            IdentityService identityService = loginService.getIdentityService();
            Authentication authentication = this._authenticator.validateRequest(request, response, true);
            if (authentication instanceof Authentication.User && identityService != null) {
                this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
            return this;
        }
    }

    @Override
    public Authentication login(String username2, Object password, ServletRequest request) {
        if (username2 == null) {
            return null;
        }
        UserIdentity identity = this._authenticator.login(username2, password, request);
        if (identity != null) {
            IdentityService identityService = this._authenticator.getLoginService().getIdentityService();
            UserAuthentication authentication = new UserAuthentication("API", identity);
            if (identityService != null) {
                this._previousAssociation = identityService.associate(identity);
            }
            return authentication;
        }
        return null;
    }

    @Override
    public Authentication logout(ServletRequest request) {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout(null);
            this._authenticator.logout(request);
            return new LoggedOutAuthentication(this._authenticator);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public static boolean isDeferred(HttpServletResponse response) {
        return response == __deferredResponse;
    }
}

