/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.Choice;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.Name;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.Sequence;
import com.thaiopensource.xml.dtd.parse.Atom;
import com.thaiopensource.xml.dtd.parse.Decl;
import com.thaiopensource.xml.dtd.parse.Param;
import com.thaiopensource.xml.dtd.parse.ParamStream;
import com.thaiopensource.xml.dtd.parse.Particle;
import com.thaiopensource.xml.em.ExternalId;
import java.util.Vector;

class Entity {
    final String name;
    final boolean isParameter;
    char[] text;
    String entityValue;
    String systemId;
    String publicId;
    String baseUri;
    String encoding;
    String uri;
    Entity overrides;
    boolean overridden;
    Reference[] references;
    boolean open;
    String notationName;
    Vector atoms;
    boolean mustReparse;
    static final int NO_PROBLEM = 0;
    static final int INCONSISTENT_LEVEL_PROBLEM = 1;
    static final int INCONSISTENT_PARSE_PROBLEM = 2;
    static final int UNEXPAND_PROBLEM = 3;
    static final int UNKNOWN_SEMANTIC_PROBLEM = 4;
    static final int EMPTY_PARTICLE_PROBLEM = 5;
    static final int REPARSE_PROBLEM = 6;
    static final int UNREFERENCED_PROBLEM = 7;
    static final int INTERNAL_DECL_PROBLEM = 8;
    static final int NOT_PARSED_PROBLEM = 9;
    int problem = 7;
    static final int INCONSISTENT_LEVEL = -1;
    static final int NO_LEVEL = 0;
    static final int DECL_LEVEL = 1;
    static final int PARAM_LEVEL = 2;
    static final int PARTICLE_LEVEL = 3;
    int referenceLevel = 0;
    static final int GROUP_CONTAINS_OR = 1;
    static final int GROUP_CONTAINS_SEQ = 2;
    static final int GROUP_CONTAINS_PCDATA = 4;
    static final int GROUP_CONTAINS_GROUP = 8;
    static final int GROUP_CONTAINS_ELEMENT_NAME = 16;
    static final int GROUP_CONTAINS_NMTOKEN = 32;
    int groupFlags = 0;
    static final int SEMANTIC_NONE = 0;
    static final int SEMANTIC_MODEL_GROUP = 1;
    static final int SEMANTIC_ATTRIBUTE_GROUP = 2;
    static final int SEMANTIC_ENUM_GROUP = 3;
    static final int SEMANTIC_DATATYPE = 4;
    static final int SEMANTIC_FLAG = 5;
    static final int SEMANTIC_NAME_SPEC = 6;
    static final int SEMANTIC_ATTRIBUTE_DEFAULT = 7;
    int semantic = 0;
    boolean maybeNameSpec;
    ModelGroup modelGroup;
    AttributeGroup attributeGroup;
    EnumGroup enumGroup;
    Datatype datatype;
    Flag flag;
    NameSpec nameSpec;
    AttributeDefault attributeDefault;
    Decl decl;
    Vector parsed;
    static final int GROUP_MODEL_GROUP_FLAGS = 28;

    Entity(String string2, boolean bl) {
        this.name = string2;
        this.isParameter = bl;
    }

    void inconsistentParse() {
        this.parsed = null;
        this.referenceLevel = -1;
        this.problem = 2;
    }

    void setParsed(int n, Vector vector, int n2, int n3) {
        if (this.referenceLevel < 0) {
            return;
        }
        if (n == this.referenceLevel) {
            if (!Entity.sliceEqual(this.parsed, vector, n2, n3)) {
                this.inconsistentParse();
            }
            return;
        }
        if (this.referenceLevel == 0) {
            this.parsed = new Vector();
            Entity.appendSlice(this.parsed, vector, n2, n3);
            this.referenceLevel = n;
            return;
        }
        if (this.parsed.size() == n3 - n2) {
            if (n == 2 && this.referenceLevel == 3) {
                if (Entity.paramsParticlesConsistent(vector, n2, this.parsed, 0, n3 - n2)) {
                    this.referenceLevel = 2;
                    this.parsed = new Vector();
                    Entity.appendSlice(this.parsed, vector, n2, n3);
                    return;
                }
            } else if (n == 3 && this.referenceLevel == 2 && Entity.paramsParticlesConsistent(this.parsed, 0, vector, n2, n3 - n2)) {
                return;
            }
        }
        this.problem = 1;
        this.parsed = null;
        this.referenceLevel = -1;
    }

    static boolean paramsParticlesConsistent(Vector vector, int n, Vector vector2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (!Entity.paramParticleConsistent((Param)vector.elementAt(n + n4), (Particle)vector2.elementAt(n2 + n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static boolean paramParticleConsistent(Param param, Particle particle) {
        switch (param.type) {
            case 3: {
                return param.group.equals(particle);
            }
            case 10: {
                return particle.type == 2;
            }
            case 0: {
                return particle.type == 0;
            }
            case 1: {
                return particle.type == 5;
            }
        }
        return false;
    }

    int textIndexToAtomIndexOccur(int n) {
        if (n == this.text.length) {
            return -1;
        }
        switch (this.text[n]) {
            case '*': 
            case '+': 
            case '?': {
                break;
            }
            default: {
                return -1;
            }
        }
        return this.textIndexToAtomIndex(n + 1);
    }

    int textIndexToAtomIndex(int n) {
        int n2 = this.atoms.size();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            Atom atom;
            if (n3 == n) {
                return n4;
            }
            if (n4 >= n2 || (n3 += (atom = (Atom)this.atoms.elementAt(n4)).getToken().length()) > n) break;
            ++n4;
        }
        return -1;
    }

    void unexpandEntities() {
        if (this.references == null || this.atoms == null) {
            return;
        }
        Vector<Atom> vector = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.references.length) {
            Object object;
            int n3 = this.textIndexToAtomIndex(this.references[n2].start);
            int n4 = this.textIndexToAtomIndex(this.references[n2].end);
            if (n3 >= 0 && n4 >= 0 && (n3 != n4 || !this.atomMaybePasted(n3)) && this.atomsAreProperlyNested(n3, n4, true)) {
                if (vector == null) {
                    vector = new Vector<Atom>();
                }
                Entity.appendSlice(vector, this.atoms, n, n3);
                vector.addElement(new Atom(this.references[n2].entity));
                if (this.references[n2].entity.atoms == null) {
                    this.references[n2].entity.atoms = object = new Vector();
                    Entity.appendSlice((Vector)object, this.atoms, n3, n4);
                    this.references[n2].entity.unexpandEntities();
                }
                n = n4;
            } else if (n3 >= 0 && (n4 = this.textIndexToAtomIndexOccur(this.references[n2].end)) >= 0 && this.atomsAreProperlyNested(n3, n4, false)) {
                if (vector == null) {
                    vector = new Vector();
                }
                object = Entity.splitAtom((Atom)this.atoms.elementAt(n4 - 1));
                Entity.appendSlice(vector, this.atoms, n, n3);
                vector.addElement(new Atom(27, "("));
                vector.addElement(new Atom(this.references[n2].entity));
                vector.addElement(object[1]);
                if (this.references[n2].entity.atoms == null) {
                    Vector<Atom> vector2;
                    this.references[n2].entity.atoms = vector2 = new Vector<Atom>();
                    Entity.appendSlice(vector2, this.atoms, n3, n4 - 1);
                    vector2.addElement(object[0]);
                    this.references[n2].entity.unexpandEntities();
                }
                n = n4;
            } else if (!this.overridden) {
                this.references[n2].entity.problem = 3;
            }
            ++n2;
        }
        if (vector == null) {
            return;
        }
        Entity.appendSlice(vector, this.atoms, n, this.atoms.size());
        this.atoms = vector;
        this.references = null;
        if (this.overrides != null) {
            this.overrides.unexpandEntities();
        }
    }

    private static Atom[] splitAtom(Atom atom) {
        Atom[] atomArray = new Atom[2];
        switch (atom.getTokenType()) {
            case 32: {
                atomArray[1] = new Atom(37, ")?");
                break;
            }
            case 33: {
                atomArray[1] = new Atom(38, ")*");
                break;
            }
            case 34: {
                atomArray[1] = new Atom(39, ")+");
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                atomArray[0] = new Atom(28, ")");
                atomArray[1] = atom;
                return atomArray;
            }
        }
        atomArray[0] = new Atom(21, atom.getToken().substring(0, atom.getToken().length() - 1));
        return atomArray;
    }

    private boolean atomsAreProperlyNested(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            switch (((Atom)this.atoms.elementAt(n4)).getTokenType()) {
                case 19: 
                case 27: 
                case 29: 
                case 35: {
                    ++n3;
                    break;
                }
                case 20: 
                case 28: 
                case 30: 
                case 37: 
                case 38: 
                case 39: {
                    if (--n3 >= 0) break;
                    return false;
                }
                case 36: {
                    if ((n3 -= 2) >= 0) break;
                    return false;
                }
                case 25: 
                case 40: {
                    if (bl || n3 != 0) break;
                    return false;
                }
            }
            ++n4;
        }
        return n3 == 0;
    }

    private boolean atomMaybePasted(int n) {
        if (n > 0) {
            switch (((Atom)this.atoms.elementAt(n - 1)).getTokenType()) {
                case 21: 
                case 22: 
                case 23: {
                    return true;
                }
            }
        }
        if (n < this.atoms.size()) {
            switch (((Atom)this.atoms.elementAt(n)).getTokenType()) {
                case 21: 
                case 22: 
                case 23: 
                case 32: 
                case 33: 
                case 34: {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean sliceEqual(Vector vector, Vector vector2, int n, int n2) {
        int n3 = vector.size();
        if (n2 - n != n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!vector.elementAt(n4).equals(vector2.elementAt(n + n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static void appendSlice(Vector vector, Vector vector2, int n, int n2) {
        while (n < n2) {
            vector.addElement(vector2.elementAt(n));
            ++n;
        }
    }

    void analyzeSemantic() {
        if (this.problem != 0) {
            return;
        }
        switch (this.referenceLevel) {
            case 2: {
                this.analyzeSemanticParam();
                break;
            }
            case 3: {
                this.analyzeSemanticParticle();
                break;
            }
            case 1: {
                this.problem = 8;
                break;
            }
            case 0: {
                this.problem = 9;
            }
        }
        Entity entity = this.overrides;
        while (entity != null) {
            entity.analyzeSemanticOverride(this);
            entity = entity.overrides;
        }
    }

    private void analyzeSemanticOverride(Entity entity) {
        if (this.parsed == null || this.problem != 0) {
            return;
        }
        switch (this.referenceLevel) {
            case 2: {
                this.analyzeSemanticParam();
                break;
            }
            case 3: {
                this.groupFlags = entity.groupFlags;
                this.analyzeSemanticParticle();
            }
        }
        if (this.semantic != entity.semantic) {
            this.semantic = 0;
        }
    }

    private void analyzeSemanticParam() {
        if (this.isAttributeGroup()) {
            this.semantic = 2;
        } else if (this.isDatatype()) {
            this.semantic = 4;
        } else if (this.isFlag()) {
            this.semantic = 5;
        } else if (this.isModelGroup()) {
            this.semantic = 1;
        } else if (this.isNameSpec()) {
            this.semantic = 6;
        } else if (this.isAttributeDefault()) {
            this.semantic = 7;
        } else if (this.isEnumGroup()) {
            this.semantic = 3;
        } else {
            this.problem = 4;
        }
    }

    private boolean isAttributeGroup() {
        ParamStream paramStream = new ParamStream(this.parsed);
        if (!paramStream.advance()) {
            return false;
        }
        do {
            if (paramStream.type == 16 || paramStream.type == 11 && paramStream.advance() && (paramStream.type != 13 || paramStream.advance()) && paramStream.advance() && (paramStream.type != 7 || paramStream.advance())) continue;
            return false;
        } while (paramStream.advance());
        return true;
    }

    private boolean isDatatype() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && (paramStream.type == 12 || paramStream.type == 15 || paramStream.type == 13 && paramStream.advance()) && !paramStream.advance();
    }

    private boolean isAttributeDefault() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && (paramStream.type == 14 || paramStream.type == 5 || paramStream.type == 6 || paramStream.type == 7 && paramStream.advance()) && !paramStream.advance();
    }

    private boolean isFlag() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && (paramStream.type == 19 || paramStream.type == 18) && !paramStream.advance();
    }

    private boolean isModelGroup() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && (paramStream.type == 3 || paramStream.type == 8 || paramStream.type == 8) && !paramStream.advance();
    }

    private boolean isNameSpec() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && (paramStream.type == 10 || paramStream.type == 11) && !paramStream.advance();
    }

    private boolean isEnumGroup() {
        ParamStream paramStream = new ParamStream(this.parsed);
        return paramStream.advance() && paramStream.type == 17 && !paramStream.advance();
    }

    private void analyzeSemanticParticle() {
        if (this.maybeNameSpec) {
            this.semantic = 6;
            return;
        }
        int n = this.parsed.size();
        if (n == 0) {
            this.analyzeEmptySemanticParticle();
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            switch (((Particle)this.parsed.elementAt((int)n2)).type) {
                case 1: 
                case 2: 
                case 4: {
                    this.semantic = 1;
                    return;
                }
                case 3: {
                    this.semantic = 3;
                    return;
                }
            }
            ++n2;
        }
        this.problem = 4;
    }

    private void analyzeEmptySemanticParticle() {
        if ((this.groupFlags & 0x1C) == 0) {
            this.semantic = 3;
            return;
        }
        if ((this.groupFlags & 0x20) == 0) {
            switch (this.groupFlags & 3) {
                case 0: {
                    this.groupFlags |= 1;
                }
                case 1: 
                case 2: {
                    this.semantic = 1;
                    return;
                }
            }
        }
        this.problem = 5;
    }

    ModelGroup toModelGroup() {
        if (this.referenceLevel == 2) {
            return Param.paramsToModelGroup(this.parsed);
        }
        if (this.parsed.size() == 0) {
            if ((this.groupFlags & 2) != 0) {
                return new Sequence(new ModelGroup[0]);
            }
            return new Choice(new ModelGroup[0]);
        }
        return Particle.particlesToModelGroup(this.parsed);
    }

    EnumGroup toEnumGroup() {
        if (this.referenceLevel == 3) {
            return Particle.particlesToEnumGroup(this.parsed);
        }
        return Particle.particlesToEnumGroup(((Param)this.parsed.elementAt((int)0)).group.particles);
    }

    NameSpec toNameSpec() {
        if (this.referenceLevel == 3) {
            return new Name(((Particle)this.parsed.elementAt((int)0)).value);
        }
        return Param.paramsToNameSpec(this.parsed);
    }

    ExternalId getExternalId() {
        return new ExternalId(this.systemId, this.publicId, this.baseUri);
    }

    void noteReferenced() {
        if (this.problem == 7) {
            this.problem = 0;
        }
        if (this.overrides != null) {
            this.overrides.noteReferenced();
        }
    }

    String ambiguousNameSpec() {
        if (this.problem != 0 || this.referenceLevel != 3 || this.parsed.size() != 1) {
            return null;
        }
        Particle particle = (Particle)this.parsed.elementAt(0);
        if (particle.type != 2) {
            return null;
        }
        this.maybeNameSpec = true;
        return particle.value;
    }

    static class Reference {
        final Entity entity;
        final int start;
        final int end;

        Reference(Entity entity, int n, int n2) {
            this.entity = entity;
            this.start = n;
            this.end = n2;
        }
    }
}

