/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlArrangementVisitor;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRearranger
implements Rearranger<XmlElementArrangementEntry>,
ArrangementStandardSettingsAware {
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.XML_TAG, StdArrangementTokens.EntryType.XML_ATTRIBUTE});
    private static final List<StdArrangementMatchRule> DEFAULT_MATCH_RULES = new ArrayList<StdArrangementMatchRule>();
    private static final StdArrangementSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    @NotNull
    public static StdArrangementMatchRule attrArrangementRule(@NotNull String nameFilter, @NotNull String namespaceFilter, @NotNull ArrangementSettingsToken orderType) {
        if (nameFilter == null) {
            XmlRearranger.$$$reportNull$$$0(0);
        }
        if (namespaceFilter == null) {
            XmlRearranger.$$$reportNull$$$0(1);
        }
        if (orderType == null) {
            XmlRearranger.$$$reportNull$$$0(2);
        }
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)nameFilter), new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.XML_NAMESPACE, (Object)namespaceFilter)})), orderType);
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            XmlRearranger.$$$reportNull$$$0(3);
        }
        return defaultArrangementSettingsSerializer;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            XmlRearranger.$$$reportNull$$$0(4);
        }
        return SUPPORTED_TYPES.contains(token) || StdArrangementTokens.Regexp.NAME.equals((Object)token) || StdArrangementTokens.Regexp.XML_NAMESPACE.equals((Object)token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token);
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        Set<Set<ArrangementSettingsToken>> set = Collections.singleton(SUPPORTED_TYPES);
        if (set == null) {
            XmlRearranger.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public Pair<XmlElementArrangementEntry, List<XmlElementArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            XmlRearranger.$$$reportNull$$$0(6);
        }
        if (ranges == null) {
            XmlRearranger.$$$reportNull$$$0(7);
        }
        if (element == null) {
            XmlRearranger.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            XmlRearranger.$$$reportNull$$$0(9);
        }
        XmlArrangementParseInfo newEntryInfo = new XmlArrangementParseInfo();
        element.accept((PsiElementVisitor)new XmlArrangementVisitor(newEntryInfo, Collections.singleton(element.getTextRange())));
        if (newEntryInfo.getEntries().size() != 1) {
            return null;
        }
        XmlElementArrangementEntry entry2 = newEntryInfo.getEntries().get(0);
        XmlArrangementParseInfo existingEntriesInfo = new XmlArrangementParseInfo();
        root.accept((PsiElementVisitor)new XmlArrangementVisitor(existingEntriesInfo, ranges));
        return Pair.create((Object)((Object)entry2), existingEntriesInfo.getEntries());
    }

    @NotNull
    public List<XmlElementArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            XmlRearranger.$$$reportNull$$$0(10);
        }
        if (ranges == null) {
            XmlRearranger.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            XmlRearranger.$$$reportNull$$$0(12);
        }
        XmlArrangementParseInfo parseInfo = new XmlArrangementParseInfo();
        root.accept((PsiElementVisitor)new XmlArrangementVisitor(parseInfo, ranges));
        List<XmlElementArrangementEntry> list2 = parseInfo.getEntries();
        if (list2 == null) {
            XmlRearranger.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable XmlElementArrangementEntry parent, @Nullable XmlElementArrangementEntry previous, @NotNull XmlElementArrangementEntry target) {
        if (settings == null) {
            XmlRearranger.$$$reportNull$$$0(14);
        }
        if (target == null) {
            XmlRearranger.$$$reportNull$$$0(15);
        }
        return -1;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return null;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return List.of(new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, SUPPORTED_TYPES), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.XML_NAMESPACE), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME}));
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            XmlRearranger.$$$reportNull$$$0(16);
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    static {
        DEFAULT_MATCH_RULES.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)"xmlns:.*"))));
        DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(Collections.emptyList(), DEFAULT_MATCH_RULES);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderType";
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/arrangement/XmlRearranger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/arrangement/XmlRearranger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attrArrangementRule";
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseWithNew";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 13 -> new IllegalStateException(string2);
        };
    }
}

