/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Scope;
import com.intellij.util.xml.ScopeProvider;
import com.intellij.util.xml.TypeChooser;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileDescription<T> {
    @Deprecated(forRemoval=true)
    public static final ExtensionPointName<DomFileDescription> EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileDescription");
    private final Map<Class<? extends ScopeProvider>, ScopeProvider> myScopeProviders;
    protected final Class<T> myRootElementClass;
    protected final String myRootTagName;
    private final String[] myAllPossibleRootTagNamespaces;
    private volatile boolean myInitialized;
    private final Map<Class<? extends DomElement>, Class<? extends DomElement>> myImplementations;
    private final TypeChooserManager myTypeChooserManager;
    private final List<DomReferenceInjector> myInjectors;
    private final Map<String, NotNullFunction<XmlTag, List<String>>> myNamespacePolicies;

    public DomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, String ... allPossibleRootTagNamespaces) {
        if (allPossibleRootTagNamespaces == null) {
            DomFileDescription.$$$reportNull$$$0(0);
        }
        this.myScopeProviders = ConcurrentFactoryMap.createMap(key2 -> {
            try {
                return (ScopeProvider)key2.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Couldn't instantiate " + key2, e);
            }
        });
        this.myImplementations = new HashMap<Class<? extends DomElement>, Class<? extends DomElement>>();
        this.myTypeChooserManager = new TypeChooserManager();
        this.myInjectors = new SmartList();
        this.myNamespacePolicies = new ConcurrentHashMap<String, NotNullFunction<XmlTag, List<String>>>();
        this.myRootElementClass = rootElementClass;
        this.myRootTagName = rootTagName;
        this.myAllPossibleRootTagNamespaces = allPossibleRootTagNamespaces.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : allPossibleRootTagNamespaces;
    }

    public String @NotNull [] getAllPossibleRootTagNamespaces() {
        if (this.myAllPossibleRootTagNamespaces == null) {
            DomFileDescription.$$$reportNull$$$0(1);
        }
        return this.myAllPossibleRootTagNamespaces;
    }

    public final void registerNamespacePolicy(String namespaceKey, String ... namespaces) {
        this.myNamespacePolicies.put(namespaceKey, (NotNullFunction<XmlTag, List<String>>)new ConstantFunction(Arrays.asList(namespaces)));
    }

    @NotNull
    public List<String> getAllowedNamespaces(@NotNull String namespaceKey, @NotNull XmlFile file) {
        NotNullFunction<XmlTag, List<String>> function;
        if (namespaceKey == null) {
            DomFileDescription.$$$reportNull$$$0(2);
        }
        if (file == null) {
            DomFileDescription.$$$reportNull$$$0(3);
        }
        if ((function = this.myNamespacePolicies.get(namespaceKey)) instanceof ConstantFunction) {
            List list2 = (List)function.fun(null);
            if (list2 == null) {
                DomFileDescription.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (function != null) {
            XmlTag tag;
            XmlDocument document = file.getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                List list3 = (List)function.fun((Object)tag);
                if (list3 == null) {
                    DomFileDescription.$$$reportNull$$$0(5);
                }
                return list3;
            }
        } else {
            List<String> list4 = Collections.singletonList(namespaceKey);
            if (list4 == null) {
                DomFileDescription.$$$reportNull$$$0(6);
            }
            return list4;
        }
        List<String> list5 = Collections.emptyList();
        if (list5 == null) {
            DomFileDescription.$$$reportNull$$$0(7);
        }
        return list5;
    }

    @Deprecated(forRemoval=true)
    public int getVersion() {
        return this.myRootTagName.hashCode();
    }

    protected final void registerTypeChooser(Type aClass, TypeChooser typeChooser) {
        this.myTypeChooserManager.registerTypeChooser(aClass, typeChooser);
    }

    public final TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    protected final void registerReferenceInjector(DomReferenceInjector injector) {
        this.myInjectors.add(injector);
    }

    public List<DomReferenceInjector> getReferenceInjectors() {
        return this.myInjectors;
    }

    public boolean isAutomaticHighlightingEnabled() {
        return true;
    }

    @Nullable
    public Icon getFileIcon(@Iconable.IconFlags int flags) {
        return null;
    }

    @Nullable
    public Icon getFileIcon(@NotNull XmlFile file, @Iconable.IconFlags int flags) {
        if (file == null) {
            DomFileDescription.$$$reportNull$$$0(8);
        }
        return this.getFileIcon(flags);
    }

    protected void initializeFileDescription() {
    }

    @Nullable
    public DomElementsAnnotator createAnnotator() {
        return null;
    }

    public final Map<Class<? extends DomElement>, Class<? extends DomElement>> getImplementations() {
        if (!this.myInitialized) {
            this.initializeFileDescription();
            this.myInitialized = true;
        }
        return this.myImplementations;
    }

    @NotNull
    public final Class<T> getRootElementClass() {
        Class<T> clazz = this.myRootElementClass;
        if (clazz == null) {
            DomFileDescription.$$$reportNull$$$0(9);
        }
        return clazz;
    }

    public final String getRootTagName() {
        return this.myRootTagName;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        Namespace namespace;
        if (file == null) {
            DomFileDescription.$$$reportNull$$$0(10);
        }
        if ((namespace = DomReflectionUtil.findAnnotationDFS(this.myRootElementClass, Namespace.class)) != null) {
            String key2 = namespace.value();
            HashSet<String> allNs = new HashSet<String>(this.getAllowedNamespaces(key2, file));
            if (allNs.isEmpty()) {
                return false;
            }
            XmlFileHeader header = DomService.getInstance().getXmlFileHeader(file);
            return allNs.contains(header.getPublicId()) || allNs.contains(header.getSystemId()) || allNs.contains(header.getRootTagNamespace());
        }
        return true;
    }

    public boolean acceptsOtherRootTagNames() {
        return false;
    }

    @NotNull
    public Set<?> getDependencyItems(XmlFile file) {
        Set set = Collections.emptySet();
        if (set == null) {
            DomFileDescription.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public DomElement getResolveScope(GenericDomValue<?> reference) {
        DomElement annotation = this.getScopeFromAnnotation(reference);
        if (annotation != null) {
            DomElement domElement = annotation;
            if (domElement == null) {
                DomFileDescription.$$$reportNull$$$0(12);
            }
            return domElement;
        }
        DomElement domElement = DomUtil.getRoot(reference);
        if (domElement == null) {
            DomFileDescription.$$$reportNull$$$0(13);
        }
        return domElement;
    }

    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        DomElement annotation = this.getScopeFromAnnotation(element);
        if (annotation != null) {
            DomElement domElement = annotation;
            if (domElement == null) {
                DomFileDescription.$$$reportNull$$$0(14);
            }
            return domElement;
        }
        DomElement domElement = element.getParent();
        if (domElement == null) {
            DomFileDescription.$$$reportNull$$$0(15);
        }
        return domElement;
    }

    @Nullable
    protected final DomElement getScopeFromAnnotation(DomElement element) {
        Scope scope = element.getAnnotation(Scope.class);
        if (scope != null) {
            return this.myScopeProviders.get(scope.value()).getScope(element);
        }
        return null;
    }

    @Deprecated
    public boolean hasStubs() {
        return false;
    }

    @Deprecated
    public int getStubVersion() {
        throw new UnsupportedOperationException("define \"stubVersion\" of \"com.intellij.dom.fileMetaData\" extension instead");
    }

    public String toString() {
        return this.getRootElementClass() + " <" + this.getRootTagName() + "> \n" + StringUtil.join((String[])this.getAllPossibleRootTagNamespaces());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPossibleRootTagNamespaces";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/DomFileDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceKey";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/DomFileDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPossibleRootTagNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyItems";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedNamespaces";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15 -> new IllegalStateException(string2);
        };
    }
}

