/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.javaee.ExternalResourceConfigurable;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IgnoreExtResourceAction
extends BaseExtResourceAction {
    private static final String KEY = "xml.intention.ignore.external.resource.text";

    @Override
    protected String getQuickFixKeyId() {
        return KEY;
    }

    @Override
    protected void doInvoke(@NotNull PsiFile file, int offset, @NotNull String uri, Editor editor) throws IncorrectOperationException {
        if (file == null) {
            IgnoreExtResourceAction.$$$reportNull$$$0(0);
        }
        if (uri == null) {
            IgnoreExtResourceAction.$$$reportNull$$$0(1);
        }
        ExternalResourceManagerEx.getInstanceEx().addIgnoredResources(Collections.singletonList(uri), null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        String uri;
        if (project2 == null) {
            IgnoreExtResourceAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            IgnoreExtResourceAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IgnoreExtResourceAction.$$$reportNull$$$0(4);
        }
        if ((uri = IgnoreExtResourceAction.findUri(file, offset = editor.getCaretModel().getOffset())) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                IgnoreExtResourceAction.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }
        String pathToConfigurable = ConfigurableExtensionPointUtil.getConfigurablePath(ExternalResourceConfigurable.class, (Project)project2);
        String text2 = new HtmlBuilder().wrapWithHtmlBody().child((HtmlChunk)HtmlChunk.body().child(HtmlChunk.template((String)XmlBundle.message("ignore.ext.resource.preview", "$uri$", "$path$"), (Map.Entry[])new Map.Entry[]{Map.entry("uri", HtmlChunk.link((String)"uri", (String)uri)), Map.entry("path", HtmlChunk.text((String)pathToConfigurable).italic())}))).toString();
        return new IntentionPreviewInfo.Html(text2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/IgnoreExtResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/IgnoreExtResourceAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

