/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitConfigUtil {
    @NlsSafe
    public static final String USER_NAME = "user.name";
    @NlsSafe
    public static final String USER_EMAIL = "user.email";
    @NlsSafe
    public static final String CORE_AUTOCRLF = "core.autocrlf";
    @NlsSafe
    public static final String CREDENTIAL_HELPER = "credential.helper";
    @NlsSafe
    public static final String CORE_SSH_COMMAND = "core.sshCommand";
    @NlsSafe
    public static final String LOG_OUTPUT_ENCODING = "i18n.logoutputencoding";
    @NlsSafe
    public static final String COMMIT_ENCODING = "i18n.commitencoding";
    @NlsSafe
    public static final String COMMIT_TEMPLATE = "commit.template";
    @NlsSafe
    public static final String GPG_PROGRAM = "gpg.program";
    @NlsSafe
    public static final String GPG_COMMIT_SIGN = "commit.gpgSign";
    @NlsSafe
    public static final String GPG_COMMIT_SIGN_KEY = "user.signingkey";

    private GitConfigUtil() {
    }

    public static void getValues(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String keyMask, @NotNull Map<String, String> result2) throws VcsException {
        int pos;
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GitConfigUtil.$$$reportNull$$$0(2);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setEnableInteractiveCallbacks(false);
        h.setSilent(true);
        h.addParameters("--null");
        if (keyMask != null) {
            h.addParameters("--get-regexp", keyMask);
        } else {
            h.addParameters("-l");
        }
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        int start = 0;
        while ((pos = output.indexOf(10, start)) != -1) {
            String key = output.substring(start, pos);
            start = pos + 1;
            if ((pos = output.indexOf(0, start)) == -1) break;
            String value = output.substring(start, pos);
            start = pos + 1;
            result2.put(key, value);
        }
    }

    @Nullable
    public static String getValue(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String key) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(5);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        return GitConfigUtil.getValue(h, key);
    }

    @Nullable
    public static String getValue(@NotNull Project project, @NotNull File root, @NotNull @NonNls String key) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(7);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(8);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        return GitConfigUtil.getValue(h, key);
    }

    @Nullable
    private static String getValue(@NotNull GitLineHandler h, @NotNull @NonNls String key) throws VcsException {
        if (h == null) {
            GitConfigUtil.$$$reportNull$$$0(9);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(10);
        }
        h.setEnableInteractiveCallbacks(false);
        h.setSilent(true);
        h.addParameters("--null", "--get", key);
        GitCommandResult result2 = Git.getInstance().runCommand(h);
        String output = result2.getOutputOrThrow(1);
        int pos = output.indexOf(0);
        if (result2.getExitCode() != 0 || pos == -1) {
            return null;
        }
        return output.substring(0, pos);
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable @NonNls String value) {
        if (value == null) {
            return null;
        }
        value = StringUtil.toLowerCase((String)value);
        if (ContainerUtil.newHashSet((Object[])new String[]{"true", "yes", "on", "1"}).contains(value)) {
            return true;
        }
        if (ContainerUtil.newHashSet((Object[])new String[]{"false", "no", "off", "0", ""}).contains(value)) {
            return false;
        }
        return null;
    }

    @NotNull
    public static String getCommitEncoding(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(12);
        }
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, COMMIT_ENCODING);
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        String string = StringUtil.isEmpty(encoding) ? "UTF-8" : encoding;
        if (string == null) {
            GitConfigUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static String getLogEncoding(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(15);
        }
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, LOG_OUTPUT_ENCODING);
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return StringUtil.isEmpty(encoding) ? GitConfigUtil.getCommitEncoding(project, root) : encoding;
    }

    public static void setValue(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String key, @NotNull @NonNls String value, String ... additionalParameters) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(16);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(17);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(18);
        }
        if (value == null) {
            GitConfigUtil.$$$reportNull$$$0(19);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setSilent(false);
        h.addParameters(additionalParameters);
        h.addParameters(key, value);
        Git.getInstance().runCommand(h).throwOnError(1);
    }

    public static boolean isCredentialHelperUsed(@NotNull Project project, @NotNull File workingDirectory) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(20);
        }
        if (workingDirectory == null) {
            GitConfigUtil.$$$reportNull$$$0(21);
        }
        try {
            GitLineHandler handler = new GitLineHandler(project, workingDirectory, GitCommand.CONFIG);
            String value = GitConfigUtil.getValue(handler, CREDENTIAL_HELPER);
            return StringUtil.isNotEmpty((String)value);
        }
        catch (VcsException ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitConfigUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitConfigUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitEncoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommitEncoding";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLogEncoding";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCredentialHelperUsed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

