/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import git4idea.commit.signing.GpgAgentConfiguratorKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.WslGpgAgentCommandExecutor;
import git4idea.config.GitExecutable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H&J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lgit4idea/commit/signing/PinentryLauncherGenerator;", "", "executable", "Lgit4idea/config/GitExecutable;", "getExecutable", "()Lgit4idea/config/GitExecutable;", "getScriptTemplate", "", "fallbackPinentryPath", "generate", "", "project", "Lcom/intellij/openapi/project/Project;", "gpgAgentPaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "getCommandLineParameters", "", "()[Ljava/lang/String;", "intellij.vcs.git"})
public interface PinentryLauncherGenerator {
    @NotNull
    public GitExecutable getExecutable();

    @NotNull
    public String getScriptTemplate(@Nullable String var1);

    default public boolean generate(@NotNull Project project, @NotNull GpgAgentPaths gpgAgentPaths, @Nullable String fallbackPinentryPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gpgAgentPaths, (String)"gpgAgentPaths");
        Path path = gpgAgentPaths.getGpgPinentryAppLauncher();
        try {
            FileUtil.writeToFile((File)path.toFile(), (String)this.getScriptTemplate(fallbackPinentryPath));
            GitExecutable executable = this.getExecutable();
            if (executable instanceof GitExecutable.Wsl) {
                String launcherConfigPath = gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
                String[] stringArray = new String[]{"+x", launcherConfigPath};
                new WslGpgAgentCommandExecutor(project, (GitExecutable.Wsl)executable).execute("chmod", stringArray);
            } else {
                NioFiles.setExecutable((Path)path);
            }
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot generate " + path, (Throwable)e);
            return false;
        }
        return true;
    }

    @NotNull
    default public String[] getCommandLineParameters() {
        String[] stringArray;
        if (GpgAgentConfiguratorKt.access$getLOG$p().isDebugEnabled()) {
            String[] stringArray2 = new String[]{"--log"};
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }
}

