/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;
import org.jetbrains.yaml.settingsSync.YamlBackendExtensionSuppressorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/yaml/smart/YAMLStatementMover;", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineMover;", "<init>", "()V", "checkAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "info", "Lcom/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover$MoveInfo;", "down", "findNextAtOffset", "Lcom/intellij/psi/PsiElement;", "psiFile", "beginAt", "", "document", "Lcom/intellij/openapi/editor/Document;", "findPrevAtOffset", "getDestinationScope", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineRange;", "elementToMove", "getDestinationElement", "intellij.yaml.editing"})
public final class YAMLStatementMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (YamlBackendExtensionSuppressorKt.shouldDoNothingInBackendMode()) {
            return false;
        }
        if (!file.getViewProvider().hasLanguage((Language)YAMLLanguage.INSTANCE)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineNumber = document2.getLineNumber(offset);
        int start = 0;
        int end = 0;
        if (selectionModel2.hasSelection()) {
            start = selectionModel2.getSelectionStart();
            int selectionEnd = selectionModel2.getSelectionEnd();
            end = selectionEnd == 0 ? 0 : selectionEnd - 1;
        } else {
            start = LineMover.getLineStartSafeOffset((Document)document2, (int)lineNumber);
            int lineEndOffset = document2.getLineEndOffset(lineNumber);
            end = lineEndOffset == 0 ? 0 : lineEndOffset - 1;
        }
        PsiElement psiElement = this.findNextAtOffset(file, start, document2);
        if (psiElement == null) {
            return false;
        }
        PsiElement elementToMove1 = psiElement;
        PsiElement psiElement2 = this.findPrevAtOffset(file, end, document2);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement elementToMove2 = psiElement2;
        if (PsiTreeUtil.isAncestor((PsiElement)elementToMove1, (PsiElement)elementToMove2, (boolean)false)) {
            elementToMove2 = elementToMove1;
        } else if (PsiTreeUtil.isAncestor((PsiElement)elementToMove2, (PsiElement)elementToMove1, (boolean)false)) {
            elementToMove1 = elementToMove2;
        }
        if (elementToMove2 != elementToMove1) {
            Object[] objectArray = new PsiElement[]{elementToMove1, elementToMove2};
            PsiElement psiElement3 = PsiTreeUtil.findCommonParent((List)CollectionsKt.listOf((Object[])objectArray));
            if (psiElement3 == null) {
                return false;
            }
            PsiElement commonParent = psiElement3;
            Class[] classArray = new Class[]{YAMLBlockMappingImpl.class, YAMLBlockSequenceImpl.class};
            YAMLCompoundValueImpl yAMLCompoundValueImpl = (YAMLCompoundValueImpl)PsiTreeUtil.getNonStrictParentOfType((PsiElement)commonParent, (Class[])classArray);
            if (yAMLCompoundValueImpl == null) {
                return false;
            }
            YAMLCompoundValueImpl moveScope = yAMLCompoundValueImpl;
            if (elementToMove1 != moveScope) {
                while (elementToMove1.getParent() != moveScope) {
                    if (elementToMove1.getParent() != null) continue;
                    return false;
                }
            }
            if (elementToMove2 != moveScope) {
                while (elementToMove2.getParent() != moveScope) {
                    if (elementToMove2.getParent() != null) continue;
                    return false;
                }
            }
        }
        LineRange lineRange = this.getDestinationScope(file, down ? elementToMove2 : elementToMove1, down);
        if (lineRange == null) {
            return false;
        }
        LineRange destination = lineRange;
        info.toMove = new LineRange(elementToMove1, elementToMove2);
        info.toMove2 = destination;
        info.indentTarget = false;
        info.indentSource = false;
        return true;
    }

    private final PsiElement findNextAtOffset(PsiFile psiFile, int beginAt, Document document) {
        for (int offset = beginAt; offset < document.getTextLength(); ++offset) {
            if (CharsKt.isWhitespace((char)document.getCharsSequence().charAt(offset))) continue;
            return psiFile.findElementAt(offset);
        }
        return null;
    }

    private final PsiElement findPrevAtOffset(PsiFile psiFile, int beginAt, Document document) {
        for (int offset = beginAt; offset >= 0; --offset) {
            if (CharsKt.isWhitespace((char)document.getCharsSequence().charAt(offset))) continue;
            return psiFile.findElementAt(offset);
        }
        return null;
    }

    private final LineRange getDestinationScope(PsiFile file, PsiElement elementToMove, boolean down) {
        int lineNumber;
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int offset = down ? elementToMove.getTextRange().getEndOffset() : elementToMove.getTextRange().getStartOffset();
        int n = lineNumber = down ? document2.getLineNumber(offset) + 1 : document2.getLineNumber(offset) - 1;
        if (lineNumber < 0 || lineNumber >= document2.getLineCount()) {
            return null;
        }
        PsiElement psiElement = this.getDestinationElement(elementToMove, down);
        if (psiElement == null) {
            return null;
        }
        PsiElement destination = psiElement;
        int startLine = document2.getLineNumber(destination.getTextRange().getStartOffset());
        int endLine = document2.getLineNumber(destination.getTextRange().getEndOffset());
        return new LineRange(startLine, endLine + 1);
    }

    private final PsiElement getDestinationElement(PsiElement elementToMove, boolean down) {
        PsiElement destination = elementToMove;
        do {
            Object object;
            if (down) {
                PsiElement psiElement = destination;
                if (psiElement != null) {
                    object = psiElement.getNextSibling();
                    continue;
                }
                object = null;
                continue;
            }
            PsiElement psiElement = destination;
            object = destination = psiElement != null ? psiElement.getPrevSibling() : null;
        } while (destination != null && YAMLElementTypes.SPACE_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)destination)));
        return Intrinsics.areEqual((Object)destination, (Object)elementToMove) ? null : destination;
    }
}

