/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.Settings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.TimeoutWatch;

public class ComponentDragAndDrop {
    private final Robot robot;
    public static final int DRAG_THRESHOLD = Platform.isWindows() || Platform.isMacintosh() ? 10 : 16;

    public ComponentDragAndDrop(@Nonnull Robot robot) {
        this.robot = robot;
    }

    @RunsInEDT
    public void drag(@Nonnull Component target, @Nonnull Point where) {
        this.robot.pressMouse(target, where, this.robot.settings().dragButton());
        int dragDelay = this.settings().dragDelay();
        if (dragDelay > this.delayBetweenEvents()) {
            Pause.pause(dragDelay);
        }
        this.mouseMove(target, where.x, where.y);
        this.robot.waitForIdle();
    }

    private void mouseMove(@Nonnull Component target, int x, int y) {
        if (Platform.isWindows() || Platform.isMacintosh()) {
            this.mouseMoveOnWindowsAndMacintosh(target, x, y);
            return;
        }
        this.mouseMove(target, this.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), this.point(x + DRAG_THRESHOLD, y + DRAG_THRESHOLD), this.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), this.point(x, y));
    }

    @RunsInEDT
    private void mouseMoveOnWindowsAndMacintosh(@Nonnull Component target, int x, int y) {
        Dimension size = target.getSize();
        int dx = this.distance(x, size.width);
        int dy = this.distance(y, size.height);
        if (dx == 0 && dy == 0) {
            dx = DRAG_THRESHOLD;
        }
        this.mouseMove(target, this.point(x + dx / 4, y + dy / 4), this.point(x + dx / 2, y + dy / 2), this.point(x + dx, y + dy), this.point(x + dx + 1, y + dy));
    }

    private int distance(int coordinate, int dimension) {
        return coordinate + DRAG_THRESHOLD < dimension ? DRAG_THRESHOLD : 0;
    }

    @Nonnull
    private Point point(int x, int y) {
        return new Point(x, y);
    }

    @RunsInEDT
    public void drop(@Nonnull Component target, @Nonnull Point where) {
        int delayBetweenEvents;
        this.dragOver(target, where);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().eventPostingDelay() * 4);
        while (!this.robot.isDragging()) {
            if (watch.isTimeOut()) {
                throw ActionFailedException.actionFailure("There is no drag in effect");
            }
            Pause.pause();
        }
        int dropDelay = this.settings().dropDelay();
        if (dropDelay > (delayBetweenEvents = this.delayBetweenEvents())) {
            Pause.pause(dropDelay - delayBetweenEvents);
        }
        this.robot.releaseMouseButtons();
        this.robot.waitForIdle();
    }

    private int delayBetweenEvents() {
        return this.settings().delayBetweenEvents();
    }

    @Nonnull
    private Settings settings() {
        return this.robot.settings();
    }

    public void dragOver(@Nonnull Component target, @Nonnull Point where) {
        this.dragOver(target, where.x, where.y);
    }

    private void dragOver(@Nonnull Component target, int x, int y) {
        this.robot.moveMouse(target, x - 4, y);
        this.robot.moveMouse(target, x, y);
    }

    private void mouseMove(@Nonnull Component target, Point ... points) {
        for (Point p : points) {
            Preconditions.checkNotNull(p);
            this.robot.moveMouse(target, p.x, p.y);
        }
    }
}

