/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public final class HgStatusCommand {
    private static final Logger LOG = Logger.getInstance((String)HgStatusCommand.class.getName());
    private static final int ITEM_COUNT = 3;
    private static final int STATUS_INDEX = 0;
    @NotNull
    private final Project myProject;
    private final boolean myIncludeAdded;
    private final boolean myIncludeModified;
    private final boolean myIncludeRemoved;
    private final boolean myIncludeDeleted;
    private final boolean myIncludeUnknown;
    private final boolean myIncludeIgnored;
    private final boolean myIncludeCopySource;
    private boolean myCleanStatus;
    @Nullable
    private final HgRevisionNumber myBaseRevision;
    @Nullable
    private final HgRevisionNumber myTargetRevision;

    public void cleanFilesOption(boolean clean) {
        this.myCleanStatus = clean;
    }

    private HgStatusCommand(@NotNull Project project, @NotNull Builder builder) {
        if (project == null) {
            HgStatusCommand.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            HgStatusCommand.$$$reportNull$$$0(1);
        }
        this.myCleanStatus = false;
        this.myProject = project;
        this.myIncludeAdded = builder.includeAdded;
        this.myIncludeModified = builder.includeModified;
        this.myIncludeRemoved = builder.includeRemoved;
        this.myIncludeDeleted = builder.includeDeleted;
        this.myIncludeUnknown = builder.includeUnknown;
        this.myIncludeIgnored = builder.includeIgnored;
        this.myIncludeCopySource = builder.includeCopySource;
        this.myBaseRevision = builder.baseRevision;
        this.myTargetRevision = builder.targetRevision;
    }

    public Set<HgChange> executeInCurrentThread(VirtualFile repo) {
        return this.executeInCurrentThread(repo, null);
    }

    public Set<HgChange> executeInCurrentThread(VirtualFile repo, @Nullable Collection<FilePath> paths) {
        if (repo == null) {
            return Collections.emptySet();
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        LinkedList<String> options = new LinkedList<String>();
        if (this.myIncludeAdded) {
            options.add("--added");
        }
        if (this.myIncludeModified) {
            options.add("--modified");
        }
        if (this.myIncludeRemoved) {
            options.add("--removed");
        }
        if (this.myIncludeDeleted) {
            options.add("--deleted");
        }
        if (this.myIncludeUnknown) {
            options.add("--unknown");
        }
        if (this.myIncludeIgnored) {
            options.add("--ignored");
        }
        if (this.myIncludeCopySource) {
            options.add("--copies");
        }
        if (this.myCleanStatus) {
            options.add("--clean");
        }
        executor.setOutputAlwaysSuppressed(this.myCleanStatus || this.myIncludeUnknown || this.myIncludeIgnored);
        if (!(this.myBaseRevision == null || this.myBaseRevision.getRevision().isEmpty() && this.myBaseRevision.getChangeset().isEmpty())) {
            options.add("--rev");
            options.add(StringUtil.isEmptyOrSpaces((String)this.myBaseRevision.getChangeset()) ? this.myBaseRevision.getRevision() : this.myBaseRevision.getChangeset());
            if (this.myTargetRevision != null) {
                options.add("--rev");
                options.add(this.myTargetRevision.getChangeset());
            }
        }
        HashSet<HgChange> changes = new HashSet<HgChange>();
        if (paths != null) {
            List chunked = VcsFileUtil.chunkPaths((VirtualFile)repo, paths);
            for (List chunk : chunked) {
                ArrayList<String> args = new ArrayList<String>();
                args.addAll(options);
                args.addAll(chunk);
                HgCommandResult result = executor.executeInCurrentThread(repo, "status", args);
                changes.addAll(this.parseChangesFromResult(repo, result, args));
            }
        } else {
            HgCommandResult result = executor.executeInCurrentThread(repo, "status", options);
            changes.addAll(this.parseChangesFromResult(repo, result, options));
        }
        return changes;
    }

    private Collection<HgChange> parseChangesFromResult(VirtualFile repo, HgCommandResult result, List<String> args) {
        HashSet<HgChange> changes = new HashSet<HgChange>();
        HgChange previous = null;
        if (result == null) {
            return changes;
        }
        List<@NlsSafe String> errors = result.getErrorLines();
        if (!errors.isEmpty()) {
            if (result.getExitValue() != 0 && !this.myProject.isDisposed()) {
                String title = HgBundle.message("action.hg4idea.status.error", new Object[0]);
                LOG.warn(title + errors.toString());
                String message = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(errors, HtmlChunk::text)).toString();
                VcsNotifier.getInstance((Project)this.myProject).logInfo("hg.status.command.error", title, message);
                return changes;
            }
            LOG.debug(errors.toString());
        }
        for (String line : result.getOutputLines()) {
            if (StringUtil.isEmptyOrSpaces((String)line) || line.length() < 3) {
                LOG.warn("Unexpected line in status '" + line + "'");
                continue;
            }
            char statusChar = line.charAt(0);
            HgFileStatusEnum status = HgFileStatusEnum.parse(statusChar);
            if (status == null) {
                LOG.warn("Unknown status [" + statusChar + "] in line [" + line + "]\n with arguments " + args);
                continue;
            }
            File ioFile = new File(repo.getPath(), line.substring(2));
            if (HgFileStatusEnum.COPY == status && previous != null && previous.getStatus() == HgFileStatusEnum.ADDED) {
                previous.setStatus(HgFileStatusEnum.COPY);
                previous.setBeforeFile(new HgFile(repo, ioFile));
                previous = null;
                continue;
            }
            previous = new HgChange(new HgFile(repo, ioFile), status);
            changes.add(previous);
        }
        return changes;
    }

    @NotNull
    public Collection<VirtualFile> getFiles(@NotNull VirtualFile repo) {
        if (repo == null) {
            HgStatusCommand.$$$reportNull$$$0(2);
        }
        Collection<VirtualFile> collection = this.getFiles(repo, (Collection<FilePath>)null);
        if (collection == null) {
            HgStatusCommand.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<VirtualFile> getFiles(@NotNull VirtualFile repo, @Nullable List<VirtualFile> files) {
        if (repo == null) {
            HgStatusCommand.$$$reportNull$$$0(4);
        }
        Collection<VirtualFile> collection = this.getFiles(repo, files != null ? ContainerUtil.map(files, VcsUtil::getFilePath) : null);
        if (collection == null) {
            HgStatusCommand.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public Collection<VirtualFile> getFiles(@NotNull VirtualFile repo, @Nullable Collection<FilePath> paths) {
        if (repo == null) {
            HgStatusCommand.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.mapNotNull(this.getFilePaths(repo, paths), FilePath::getVirtualFile);
        if (list == null) {
            HgStatusCommand.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Collection<FilePath> getFilePaths(@NotNull VirtualFile repo, @Nullable Collection<FilePath> paths) {
        if (repo == null) {
            HgStatusCommand.$$$reportNull$$$0(8);
        }
        HashSet<FilePath> resultFiles = new HashSet<FilePath>();
        Set<HgChange> change = this.executeInCurrentThread(repo, paths);
        for (HgChange hgChange : change) {
            FilePath file = hgChange.afterFile().toFilePath();
            resultFiles.add(file);
        }
        HashSet<FilePath> hashSet = resultFiles;
        if (hashSet == null) {
            HgStatusCommand.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/command/HgStatusCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/command/HgStatusCommand";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilePaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private final boolean includeAdded;
        private final boolean includeModified;
        private boolean includeRemoved;
        private final boolean includeDeleted;
        private boolean includeUnknown;
        private boolean includeIgnored;
        private boolean includeCopySource;
        private HgRevisionNumber baseRevision;
        private HgRevisionNumber targetRevision;

        public Builder(boolean initValue) {
            this.includeAdded = initValue;
            this.includeModified = initValue;
            this.includeRemoved = initValue;
            this.includeDeleted = initValue;
            this.includeUnknown = initValue;
            this.includeIgnored = initValue;
            this.includeCopySource = initValue;
            this.baseRevision = null;
            this.targetRevision = null;
        }

        public Builder removed(boolean val) {
            this.includeRemoved = val;
            return this;
        }

        public Builder unknown(boolean val) {
            this.includeUnknown = val;
            return this;
        }

        public Builder ignored(boolean val) {
            this.includeIgnored = val;
            return this;
        }

        public Builder copySource(boolean val) {
            this.includeCopySource = val;
            return this;
        }

        public Builder baseRevision(HgRevisionNumber val) {
            this.baseRevision = val;
            return this;
        }

        public Builder targetRevision(HgRevisionNumber val) {
            this.targetRevision = val;
            return this;
        }

        public HgStatusCommand build(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return new HgStatusCommand(project, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgStatusCommand$Builder", "build"));
        }
    }
}

