/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaModuleTestCase
extends JavaProjectTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (!this.myModulesToDispose.isEmpty()) {
                WriteAction.run(() -> {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                    for (Module module2 : this.myModulesToDispose) {
                        try {
                            String moduleName = module2.getName();
                            if (moduleManager.findModuleByName(moduleName) == null) continue;
                            moduleManager.disposeModule(module2);
                        }
                        catch (Throwable e) {
                            this.addSuppressedException(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile) {
        if (moduleFile == null) {
            JavaModuleTestCase.$$$reportNull$$$0(0);
        }
        Module module2 = this.createModule(moduleFile, StdModuleTypes.JAVA);
        if (module2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(1);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile, @NotNull ModuleType<?> moduleType) {
        if (moduleFile == null) {
            JavaModuleTestCase.$$$reportNull$$$0(2);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(3);
        }
        Module module2 = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(moduleFile, moduleType.getId()));
        this.myModulesToDispose.add(module2);
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        Module module3 = module2;
        if (module3 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(4);
        }
        return module3;
    }

    @NotNull
    protected Module createModule(@NotNull String path, @NotNull ModuleType<?> moduleType) {
        if (path == null) {
            JavaModuleTestCase.$$$reportNull$$$0(5);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(6);
        }
        Module module2 = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(path, moduleType.getId()));
        this.myModulesToDispose.add(module2);
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        Module module3 = module2;
        if (module3 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(7);
        }
        return module3;
    }

    @NotNull
    protected Module loadModule(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(8);
        }
        return this.loadModule(file2.toNioPath());
    }

    @NotNull
    protected final Module loadModule(@NotNull Path modulePath) {
        Module module2;
        if (modulePath == null) {
            JavaModuleTestCase.$$$reportNull$$$0(9);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        try {
            module2 = (Module)ApplicationManager.getApplication().runWriteAction(() -> moduleManager.loadModule(modulePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myModulesToDispose.add(module2);
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        Module module3 = module2;
        if (module3 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(10);
        }
        return module3;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        if (rootDir == null) {
            JavaModuleTestCase.$$$reportNull$$$0(11);
        }
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<? super Module> moduleConsumer) {
        if (rootDir == null) {
            JavaModuleTestCase.$$$reportNull$$$0(12);
        }
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootDir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && file2.getName().endsWith(".iml")) {
                    Module module2 = JavaModuleTestCase.this.loadModule(file2);
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module2);
                    }
                    result.setIfNull((Object)module2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/JavaModuleTestCase$1", "visitFile"));
            }
        });
        Module module2 = (Module)result.get();
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        return module2;
    }

    @NotNull
    protected final Module createModuleFromTestData(@NotNull String dirInTestData, @NotNull String newModuleFileName, @NotNull ModuleType<?> moduleType, boolean addSourceRoot) throws IOException {
        if (dirInTestData == null) {
            JavaModuleTestCase.$$$reportNull$$$0(13);
        }
        if (newModuleFileName == null) {
            JavaModuleTestCase.$$$reportNull$$$0(14);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(15);
        }
        VirtualFile moduleDir = this.getTempDir().createVirtualDir();
        FileUtil.copyDir((File)new File(dirInTestData), (File)moduleDir.toNioPath().toFile());
        moduleDir.refresh(false, true);
        Module module2 = this.createModule(moduleDir.toNioPath().resolve(newModuleFileName), moduleType);
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots(module2, moduleDir);
        } else {
            PsiTestUtil.addContentRoot(module2, moduleDir);
        }
        Module module3 = module2;
        if (module3 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(16);
        }
        return module3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 10, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/JavaModuleTestCase";
                break;
            }
            case 3: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirInTestData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModuleFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/JavaModuleTestCase";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleFromTestData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadAllModulesUnder";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createModuleFromTestData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 10, 16 -> new IllegalStateException(string);
        };
    }
}

